/*                                                           
Cookie.h
*/


#ifndef __COOKIE_H
#define __COOKIE_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "Config.h"
#include "Utils.h"
#include "XSocket.h"
#include "XVector.h"
#include "XString.h"
#include "Language.h"

class Cookie
  { 
  private:
    XString thecookie, fName, fValue, fDomain, fPath, acook;
    bool fSecure;
  public:
    Cookie (const char *user, const char *connid);
    virtual ~Cookie();
    void newCookie (const char *connid);
    const char *getName (void);
    const char *getValue (void);
    const char *getDomain (void);
    const char *getPath (void);
    bool isSecure() const;
    void setName(const char *name);
    void setValue(const char *value);
    void setDomain(const char *domain);
    void setPath(const char *path);
    void setSecure(bool secure);
    const char *getSetFullCookieLine (void);
    const char *getSetClearFullCookieLine (void);
    bool isGoodCookie (const char *acookiestring);
  };

#endif
