/*
 * dirwatch.h - detect changes of directory content
 * Copyright (C) 2003  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef CS_DIRWATCH_H
#define CS_DIRWATCH_H

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include<qobject.h>

class FileWatch : public QObject
{
	Q_OBJECT
public:
	FileWatch(const QString &fname="", QObject *parent=0);
	~FileWatch();

	QString fileName() const;
	void setFileName(const QString &);

signals:
	void changed();

private slots:
	void dirChanged();

private:
	class Private;
	Private *d;
};

class DirWatch : public QObject
{
	Q_OBJECT
public:
	DirWatch(const QString &dir="", QObject *parent=0);
	~DirWatch();

	QString dir() const;
	void setDir(const QString &);

	bool usingPlatform() const;

signals:
	void changed();

private slots:
	void doCheck();
	void pf_dirChanged(int);

private:
	class Private;
	Private *d;
};

class DirWatchPlatform : public QObject
{
	Q_OBJECT
public:
	DirWatchPlatform();
	~DirWatchPlatform();

	bool init();
	int addDir(const QString &);
	void removeDir(int);

signals:
	void dirChanged(int);

public:
	class Private;
private:
	Private *d;

	friend class Private;
private slots:
	void triggerDirChanged(int x) { dirChanged(x); }
};

#endif
