#ifndef PLAYLISTWRAPPER_H
#define PLAYLISTWRAPPER_H

#include <xmmsctrl.h>
#include <string>
#include <qtimer.h>
#include <map>

class t_songInfo
{
public:
	string m_title;
	string m_filename;
	int m_position;
	int m_time;
	int m_freq;
	int m_bitrate;
	int m_nch;

	/**
	 * Constructor.
	 */
	t_songInfo();
	t_songInfo(const string &title, const string &filename, int position, int time, int freq, int bitrate, int nch);
	t_songInfo(const t_songInfo &rhs);
	t_songInfo & operator=(const t_songInfo &rhs);
};

typedef map<int, t_songInfo>::const_iterator t_citer_songInfo;

class playlistWrapper
{
public:

	// initialise, attempt to get information out of running xmms process.
	static playlistWrapper & self();

	void updatePlaylist();
	void playFileByPos(int pos) const;
	unsigned int length() const;
	unsigned int getCurrentTime() const;
	int getPlayerStatus() const;
	bool getRandomStatus() const;
	void setRandomStatus() const;
	const t_songInfo & operator[](unsigned int) const;
	const t_songInfo & getCurrentSong() const;

	void pressPlay() const;
	void pressStop() const;
	void pressNext() const;
	void pressPrev() const;
	void pressPause() const;

	enum { PAUSED, PLAYING, STOPPED };

private:
	playlistWrapper();
	map<int, t_songInfo> m_list;
	static playlistWrapper * m_self;
};

inline t_songInfo::t_songInfo()
	: m_title(""), m_filename(""), m_position(0), m_time(0), m_freq(0), m_bitrate(0), m_nch(0)
{

}

inline t_songInfo::t_songInfo(const string &title, const string &filename, int position, int time, int freq, int bitrate, int nch)
	: m_title(title), m_filename(filename), m_position(position), m_time(time), m_freq(freq), m_bitrate(bitrate), m_nch(nch)
{
}

inline t_songInfo::t_songInfo(const t_songInfo &rhs)
{
	m_title = rhs.m_title;
	m_filename = rhs.m_filename;
	m_position = rhs.m_position;
	m_time = rhs.m_time;
	m_freq = rhs.m_freq;
	m_bitrate = rhs.m_bitrate;
	m_nch = rhs.m_nch;
}

inline t_songInfo & t_songInfo::operator =(const t_songInfo &rhs)
{
	m_title = rhs.m_title;
	m_filename = rhs.m_filename;
	m_position = rhs.m_position;
	m_time = rhs.m_time;
	m_freq = rhs.m_freq;
	m_bitrate = rhs.m_bitrate;
	m_nch = rhs.m_nch;
	return *this;
}

#endif
