/*
 * CP4D.cpp
 * $Id: CP4D.cpp,v 1.2 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

   
// System
///////////

// Own
////////
#include "CP4D.h"
#include "CP3D.h"
#include "GeoGeneric.h"

// Initialisation of statics:
double CP4D::epsilon= DOUBLE_EPSILON; //EPS_CP4D;



// Function   : operator CP3D() 
// Parameters : 
// Purpose    : for casting a CP4D to a CP3D
// Comments   : Each component is divided by the fourth component
CP4D::operator CP3D() const
/*******************************************************************/
{ 
   if(fabs(m_ard[3]) < epsilon) { 
      cout << "CP4D::CP3D() Can't normalize" << endl;
      return CP3D(0.0, 0.0, 0.0);;
   }
   else {
     return CP3D(m_ard[0] / m_ard[3],
		 m_ard[1] / m_ard[3],
		 m_ard[2] / m_ard[3]); 
   }
}



// Function   : operator==
// Parameters : const CP4D& pnt
// Purpose    : compares one point with another.
// Comments   :
int CP4D::operator==(const CP4D& pnt)
/*******************************************************************/
{
   return ( (fabs(m_ard[0]-pnt.m_ard[0]) < epsilon) &&
            (fabs(m_ard[1]-pnt.m_ard[1]) < epsilon) &&
            (fabs(m_ard[2]-pnt.m_ard[2]) < epsilon) &&
            (fabs(m_ard[3]-pnt.m_ard[3]) < epsilon));
}



// Function   : operator!=
// Parameters : const CP4D& pnt 
// Purpose    : Compares two CP4D 
// Comments   : They are equal if all components are equal
int CP4D::operator!=(const CP4D& pnt) 
/*******************************************************************/
{
   return  !( *this == pnt);
}



// Function  : operator+=
// Parameters: const CP4D& v
// Purpose   : adds a vector to this point.
// Comments  : See docu for details.
CP4D& CP4D::operator+=(const CV4D& v) 
/*********************************************************************/
{
  m_ard[0] += v[0];
  m_ard[1] += v[1];
  m_ard[2] += v[2];
  m_ard[3] += v[3];

  return *this;
}



// Function  : operator-=
// Parameters: const CP4D& v
// Purpose   : subtracts a vector from this point.
// Comments  : See docu for details.
CP4D& CP4D::operator-=(const CV4D& v) {
/*********************************************************************/
  m_ard[0] -= v[0];
  m_ard[1] -= v[1];
  m_ard[2] -= v[2];
  m_ard[3] -= v[3];

  return *this;
}



// Function  : operator+
// Parameters: const CV4D& v
// Purpose   : adds a vector to a point.
// Comments  : See docu for details.
CP4D CP4D::operator+(const CV4D& v) const 
/*********************************************************************/
{
  return CP4D(m_ard[0] + v[0], 
	      m_ard[1] + v[1],
	      m_ard[2] + v[2],
	      m_ard[3] + v[3]);
}



// Function  : operator-
// Parameters: const CV4D& v
// Purpose   : subtracts a vector from a point.
// Comments  : See docu for details.
CP4D CP4D::operator-(const CV4D& v) const 
/*********************************************************************/
{
  return CP4D(m_ard[0] - v[0], 
	      m_ard[1] - v[1],
	      m_ard[2] - v[2],
	      m_ard[3] - v[3]);
}



// Function  : operator-
// Parameters: const CP4D& v
// Purpose   : subtracts two points
// Comments  : See docu for details.
CV4D CP4D::operator-(const CP4D& cPoint) const 
/*********************************************************************/
{
  return CV4D(m_ard[0] - cPoint.m_ard[0], 
	      m_ard[1] - cPoint.m_ard[1],
	      m_ard[2] - cPoint.m_ard[2],
	      m_ard[3] - cPoint.m_ard[3]);
}



// Function  : operator-
// Parameters: 
// Purpose   : negates this point.
// Comments  : See docu for details.
CP4D CP4D::operator-() const 
/*********************************************************************/
{
  return CP4D(-m_ard[0], -m_ard[1], -m_ard[2], -m_ard[3]);
}




// Function  : print
// Parameters: 
// Purpose   : prints this vector to stdout
// Comments  : See docu for details.
void CP4D::print() const 
/*********************************************************************/
{
  cout << "(" << m_ard[0] << "," <<  m_ard[1] << ",";
  cout <<  m_ard[2] << "," <<  m_ard[3] << ")" << endl;

  return;
}


  
// Function  : operator<<
// Parameters: ostream& s, const CV4D& v
// Purpose   : same as above with streams.
// Comments  : See docu for details.
ostream& operator<<(ostream& s, const CP4D& v) 
/*********************************************************************/
{
  return s << "(" << v.m_ard[0] << "," << v.m_ard[1] << ","
	   << v.m_ard[2] << "," << v.m_ard[3] << ")";
}



// Function  : operator>>
// Parameters: istream& s, CV4D& v
// Purpose   : reads a vector from stdin.
// Comments  : See docu for details.
istream& operator>>(istream& s, CP4D& v) 
/*********************************************************************/
{
  char c;

  return s >> c >> v.m_ard[0] >> c >> v.m_ard[1] >> c >> v.m_ard[2] >> c >> v.m_ard[3] >> c;
}
