\name{pkgInfo-class}
\docType{class}
\alias{pkgInfo-class}
\alias{pkgName}
\alias{pkgVersion}
\alias{pkgPath}
\alias{pkgInfo}
\alias{pkgContains}
\alias{pkgRelLevel}
\alias{==,pkgInfo-method}
\alias{pkgContains,pkgInfo-method}
\alias{pkgName,pkgInfo-method}
\alias{pkgRelLevel,pkgInfo-method}
\alias{pkgPath,pkgInfo-method}
\alias{pkgVersion,pkgInfo-method}
\alias{show,pkgInfo-method}
\title{A class to hold package information}
\description{This class contains some succinct information about a
  package, including its name and version}
\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("pkgInfo", ...)}.
  The helper function 'buildPkgInfo' is also provided.
}
\section{Slots}{
  \describe{
    \item{\code{pkgName}:}{Object of class \code{"character"} A string
      representing the name of the package}
    \item{\code{pkgVersion}:}{Object of class \code{"VersionNumber"} A
      VersionNumber object representing the version number of the package }
    \item{\code{pkgPath}:}{Object of class \code{"character"} A string
      reprsenting the path of the installed package}
    \item{\code{pkgRelLevel}:}{Object of class \code{"character"} A string
      reprsenting the release level of the installed package}
    \item{\code{pkgContains}:}{Object of class \code{"character"} If
      this is a package bundle, a character vector describing any
      packages contained in the bundle}
  }
}

\section{Methods}{
  \describe{
    \item{pkgName}{\code{(pkgInfo)}: The name of the package}
    \item{pkgPath}{\code{(pkgInfo)}: The path to the installed copy of
      the package}
    \item{pkgVersion}{\code{(pkgInfo)}: The version number of the
      package}
    \item{pkgRelLevel}{\code{(pkgInfo)}: The release level of the package.}
    \item{pkgContains}{\code{(pkgInfo)}: Any packages contained, if this
      is a bundle}
    \item{show}{\code{(pkgInfo)}: Displays in the form <pkgName>: <pkgVersion>}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{buildPkgInfo}}}
\examples{
 a <- buildPkgInfo("Foo","1.2.3")
}
\keyword{classes}
