# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Thread", "Object", "class")
aClass.addFragment(Paragraph.new("<code>Thread</code> encapsulates the behavior of a thread of execution, including the main thread of the Ruby script. See the tutorial in Chapter 11, beginning on page 113.\n"))
aClass.addFragment(Paragraph.new("In the descriptions that follow, the parameter <i>aSymbol</i> refers to a symbol, which is either a quoted string or a <code>Symbol</code> (such as <code>:name</code>).\n"))
m0002 = MethodDesc.new("abort_on_exception", "class", "Thread.abort_on_exception -> <code>true</code> or <code>false</code>")
m0002.addFragment(Paragraph.new("Returns the status of the global ``abort on exception'' condition. The default is <code>false</code>. When set to <code>true</code>, will cause all threads to abort (the process will <code>exit(0)</code>) if an exception is raised in any thread. See also <code>Thread::abort_on_exception=</code>.\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("abort_on_exception=", "class", "Thread.abort_on_exception= <i>aBoolean</i>-> <code>true</code> or <code>false</code>")
m0003.addFragment(Paragraph.new("When set to <code>true</code>, all threads will abort if an exception is raised. Returns the new state.\n"))
m0003.addFragment(Verbatim.new("Thread.abort_on_exception = true\nt1 = Thread.new do\n  puts  \"In second thread\"\n  raise \"Raise exception\"\nend\nt1.join\nprint \"not reached\\n\""))
m0003.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0003.addFragment(Verbatim.new("In second thread\nprog.rb:4: Raise exception (RuntimeError)\n\tfrom prog.rb:2:in `initialize'\n\tfrom prog.rb:2:in `new'\n\tfrom prog.rb:2"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("critical", "class", "Thread.critical -> <code>true</code> or <code>false</code>")
m0004.addFragment(Paragraph.new("Returns the status of the global ``thread critical'' condition.\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("critical=", "class", "Thread.critical= <i>aBoolean</i> -> <code>true</code> or <code>false</code>")
m0005.addFragment(Paragraph.new("Sets the status of the global ``thread critical'' condition and returns it. When set to <code>true</code>, prohibits scheduling of any existing thread. Does not block new threads from being created and run. Certain thread operations (such as stopping or killing a thread, sleeping in the current thread, and raising an exception) may cause a thread to be scheduled even when in a critical section.\n"))
m0005.addFragment(Verbatim.new("count=0\nThread.new { while true; sleep(1); print \"a \"; count+=1; end }\nwhile count < 3 do end \# no-op wait\nThread.critical = true\nputs \"no more a's will come out.\""))
m0005.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0005.addFragment(Verbatim.new("a a a no more a's will come out."))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("current", "class", "Thread.current -> <i>aThread</i>")
m0006.addFragment(Paragraph.new("Returns the currently executing thread.\n"))
m0006.addFragment(Verbatim.new("Thread.current   \#=> \#<Thread:0x40196528 run>\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("exit", "class", "Thread.exit")
m0007.addFragment(Paragraph.new("Terminates the currently running thread and schedules another thread to be run. If this thread is already marked to be killed, <code>exit</code> returns the <code>Thread</code>. If this is the main thread, or the last thread, exit the process.\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("fork", "class", "Thread.fork { block } -> <i>aThread</i>")
m0008.addFragment(Paragraph.new("Synonym for <code>Thread::new</code>.\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("kill", "class", "Thread.kill( <i>aThread</i> )")
m0009.addFragment(Paragraph.new("Causes the given thread to exit (see <code>Thread::exit</code>).\n"))
m0009.addFragment(Verbatim.new("count = 0\na = Thread.new { while true do  count += 1 end }\nsleep(1)         \#=> 1\nThread.kill(a)   \#=> \#<Thread:0x4018d52c dead>\ncount            \#=> 911276\na.alive?         \#=> false\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("list", "class", "Thread.list -> <i>anArray</i>")
m0010.addFragment(Paragraph.new("Returns an array of <code>Thread</code> objects for all threads that are either runnable or stopped.\n"))
m0010.addFragment(Verbatim.new("Thread.new { sleep(200) }\nThread.new { 1000000.times {|i| i*i } }\nThread.new { Thread.stop }\nl = Thread.list\nl   \#=> [\#<Thread:0x4018d658 sleep>, \#<Thread:0x4018d6d0 run>, \#<Thread:0x4018d70c sleep>, \#<Thread:0x40196528 run>]\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("main", "class", "Thread.main -> <i>aThread</i>")
m0011.addFragment(Paragraph.new("Returns the main thread for the process.\n"))
m0011.addFragment(Verbatim.new("Thread.main   \#=> \#<Thread:0x40196528 run>\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("new", "class", "Thread.new( <i>[</i><i>arg</i><i>]*</i> ) {| args | block } <p></p> -> <i>aThread</i>")
m0012.addFragment(Paragraph.new("Creates a new thread to execute the instructions given in <i>block</i>, and begins running it. Any arguments passed to <code>Thread::new</code> are passed into the block.\n"))
m0012.addFragment(Verbatim.new("x = Thread.new { sleep .1; print \"x\"; print \"y\"; print \"z\" }\na = Thread.new { print \"a\"; print \"b\"; sleep .2; print \"c\" }\nx.join \# Let the threads finish before\na.join \# main thread exits..."))
m0012.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0012.addFragment(Verbatim.new("abxyzc"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("pass", "class", "Thread.pass")
m0013.addFragment(Paragraph.new("Invokes the thread scheduler to pass execution to another thread.\n"))
m0013.addFragment(Verbatim.new("a = Thread.new { print \"a\"; Thread.pass;\n                 print \"b\"; Thread.pass;\n                 print \"c\" }\nb = Thread.new { print \"x\"; Thread.pass;\n                 print \"y\"; Thread.pass;\n                 print \"z\" }\na.join\nb.join"))
m0013.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0013.addFragment(Verbatim.new("axbycz"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("start", "class", "Thread.start( <i>[</i><i>args</i><i>]*</i> ) {| args | block } <p></p> -> <i>aThread</i>")
m0014.addFragment(Paragraph.new("Basically the same as <code>Thread::new</code>. However, if class <code>Thread</code> is subclassed, then calling <code>start</code> in that subclass will not invoke the subclass's <code>initialize</code> method.\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("stop", "class", "Thread.stop")
m0015.addFragment(Paragraph.new("Stops execution of the current thread, putting it into a ``sleep'' state, and schedules execution of another thread. Resets the ``critical'' condition to <code>false</code>.\n"))
m0015.addFragment(Verbatim.new("a = Thread.new { print \"a\"; Thread.stop; print \"c\" }\nThread.pass\nprint \"b\"\na.run\na.join"))
m0015.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0015.addFragment(Verbatim.new("abc"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("[]", "instance", "<p></p> <i>thr</i>[ <i>aSymbol</i> ] -> <i>anObject</i> or <code>nil</code>")
m0016.addFragment(Paragraph.new("Attribute Reference---Returns the value of a thread-local variable, using either a symbol or a string name. If the specified variable does not exist, returns <code>nil</code>.\n"))
m0016.addFragment(Verbatim.new("a = Thread.new { Thread.current[\"name\"] = \"A\"; Thread.stop }\nb = Thread.new { Thread.current[:name]  = \"B\"; Thread.stop }\nc = Thread.new { Thread.current[\"name\"] = \"C\"; Thread.stop }\nThread.list.each {|x| print x.inspect, x[:name], \"\\n\" }"))
m0016.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0016.addFragment(Verbatim.new("\#<Thread:0x4018d3ec sleep>C\n\#<Thread:0x4018d43c sleep>B\n\#<Thread:0x4018d4a0 sleep>A\n\#<Thread:0x40196528 run>nil"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("[]=", "instance", "<p></p> <i>thr</i>[ <i>aSymbol</i> ] = <i>anObject</i>-> <i>anObject</i> <p></p>")
m0017.addFragment(Paragraph.new("Attribute Assignment---Sets or creates the value of a thread-local variable, using either a symbol or a string. See also <code>Thread\#[]</code>.\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("abort_on_exception", "instance", "<i>thr</i>.abort_on_exception -> <code>true</code> or <code>false</code>")
m0018.addFragment(Paragraph.new("Returns the status of the ``abort on exception'' condition for <i>thr</i>. The default is <code>false</code>. See also <code>Thread::abort_on_exception=</code>.\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("abort_on_exception=", "instance", "<i>thr</i>.abort_on_exception= <code>true</code> or <code>false</code>-> <code>true</code> or <code>false</code>")
m0019.addFragment(Paragraph.new("When set to <code>true</code>, causes all threads (including the main program) to abort if an exception is raised in <i>thr</i>. The process will effectively <code>exit(0)</code>.\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("alive?", "instance", "<i>thr</i>.alive? -> <code>true</code> or <code>false</code>")
m0020.addFragment(Paragraph.new("Returns <code>true</code> if <i>thr</i> is running or sleeping.\n"))
m0020.addFragment(Verbatim.new("Thread.current.alive?   \#=> true\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("exit", "instance", "<i>thr</i>.exit -> <i>thr</i> or <code>nil</code>")
m0021.addFragment(Paragraph.new("Terminates <i>thr</i> and schedules another thread to be run. If this thread is already marked to be killed, <code>exit</code> returns the <code>Thread</code>. If this is the main thread, or the last thread, exits the process.\n"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("join", "instance", "<i>thr</i>.join -> <i>thr</i>")
m0022.addFragment(Paragraph.new("The calling thread will suspend execution and run <i>thr</i>. Does not return until <i>thr</i> exits. Any threads not joined will be killed when the main program exits.\n"))
m0022.addFragment(Verbatim.new("a = Thread.new { print \"a\"; sleep(10); print \"b\"; print \"c\" }\nx = Thread.new { print \"x\"; Thread.pass; print \"y\"; print \"z\" }\nx.join \# Let x thread finish, a will be killed on exit."))
m0022.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0022.addFragment(Verbatim.new("axyz"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("key?", "instance", "<i>thr</i>.key?( <i>aSymbol</i> ) -> <code>true</code> or <code>false</code><br></br>")
m0023.addFragment(Paragraph.new("Returns <code>true</code> if the given string (or symbol) exists as a thread-local variable.\n"))
m0023.addFragment(Verbatim.new("me = Thread.current\nme[:oliver] = \"a\"\nme.key?(:oliver)    \#=> true\nme.key?(:stanley)   \#=> false\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("kill", "instance", "<i>thr</i>.kill")
m0024.addFragment(Paragraph.new("Synonym for <code>Thread\#exit</code>.\n"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("priority", "instance", "<i>thr</i>.priority -> <i>anInteger</i>")
m0025.addFragment(Paragraph.new("Returns the priority of <i>thr</i>. Default is zero; higher-priority threads will run before lower-priority threads.\n"))
m0025.addFragment(Verbatim.new("Thread.current.priority   \#=> 0\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("priority=", "instance", "<i>thr</i>.priority= <i>anInteger</i> -> <i>thr</i>")
m0026.addFragment(Paragraph.new("Sets the priority of <i>thr</i> to <i>anInteger</i>. Higher-priority threads will run before lower-priority threads.\n"))
m0026.addFragment(Verbatim.new("count1 = count2 = 0\na = Thread.new do\n      loop { count1 += 1 }\n    end\na.priority = -1"))
m0026.addFragment(Verbatim.new("b = Thread.new do\n      loop { count2 += 1 }\n    end\nb.priority = -2\nsleep 1   \#=> 1\nThread.critical = 1\ncount1    \#=> 619920\ncount2    \#=> 11586\n"))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("raise", "instance", "<i>thr</i>.raise( <i>anException</i> )")
m0027.addFragment(Paragraph.new("Raises an exception (see <code>Kernel::raise</code> on page 425 for details) from <i>thr</i>. The caller does not have to be <i>thr</i>.\n"))
m0027.addFragment(Verbatim.new("Thread.abort_on_exception = true\na = Thread.new { sleep(200) }\na.raise(\"Gotcha\")"))
m0027.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0027.addFragment(Verbatim.new("prog.rb:3: Gotcha (RuntimeError)\n\tfrom prog.rb:2:in `initialize'\n\tfrom prog.rb:2:in `new'\n\tfrom prog.rb:2"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("run", "instance", "<i>thr</i>.run -> <i>thr</i>")
m0028.addFragment(Paragraph.new("Wakes up <i>thr</i>, making it eligible for scheduling. If not in a critical section, then invokes the scheduler.\n"))
m0028.addFragment(Verbatim.new("a = Thread.new { puts \"a\"; Thread.stop; puts \"c\" }\nThread.pass\nputs \"Got here\"\na.run\na.join"))
m0028.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0028.addFragment(Verbatim.new("a\nGot here\nc"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("safe_level", "instance", "<i>thr</i>.safe_level -> <i>anInteger</i>")
m0029.addFragment(Paragraph.new("Returns the safe level in effect for <i>thr</i>.\n"))
m0029.addFragment(Verbatim.new("Thread.current.safe_level   \#=> 0\n"))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("status", "instance", "<i>thr</i>.status -> <i>aString</i>, <code>false</code> or <code>nil</code>")
m0030.addFragment(Paragraph.new("Returns the status of <i>thr</i>: ``<code>sleep</code>'' if <i>thr</i> is sleeping or waiting on I/O, ``<code>run</code>'' if <i>thr</i> is executing, <code>false</code> if <i>thr</i> terminated normally, and <code>nil</code> if <i>thr</i> terminated with an exception.\n"))
m0030.addFragment(Verbatim.new("a = Thread.new { raise(\"die now\") }\nb = Thread.new { Thread.stop }\nc = Thread.new { Thread.exit }\na.status                \#=> nil\nb.status                \#=> \"sleep\"\nc.status                \#=> false\nThread.current.status   \#=> \"run\"\n"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("stop?", "instance", "<i>thr</i>.stop? -> <code>true</code> or <code>false</code>")
m0031.addFragment(Paragraph.new("Returns <code>true</code> if <i>thr</i> is dead or sleeping.\n"))
m0031.addFragment(Verbatim.new("a = Thread.new { Thread.stop }\nb = Thread.current\na.stop?   \#=> true\nb.stop?   \#=> false\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("value", "instance", "<i>thr</i>.value -> <i>anObject</i>")
m0032.addFragment(Paragraph.new("Waits for <i>thr</i> to complete (via <code>Thread\#join</code>) and returns its value.\n"))
m0032.addFragment(Verbatim.new("a = Thread.new { 2+2 }\na.value   \#=> 4\n"))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("wakeup", "instance", "<i>thr</i>.wakeup -> <i>thr</i>")
m0033.addFragment(Paragraph.new("Marks <i>thr</i> as eligible for scheduling (it may still remain blocked on I/O, however). Does not invoke the scheduler (see <code>Thread\#run</code>).\n"))
m0033.addFragment(Verbatim.new("c = Thread.new { Thread.stop; puts \"hey!\" }\nc.wakeup"))
m0033.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0033.addFragment(Verbatim.new("hey!"))
aClass.addMethod(m0033)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
