import string, struct

# size of an integer
INT_SIZE = struct.calcsize('i')




strategies = {
        'exact'     : (0, 'Match words exactly'),
        'prefix'    : (1, 'Match prefixes'),
        'substring' : (2, 'Match substring occurring anywhere in word'),
        'suffix'    : (3, 'Match suffixes'),
        'soundex'   : (4, 'Match using SOUNDEX algorithm'),
        'lev'       : (5, 'Match words within Levenshtein distance one'),
        're'        : (6, 'POSIX 1003.2 regular expressions'),
        'fnmatch'   : (7, 'fnmatch-like (* ? as wildcards)'),
        'metaphone' : (8, 'metaphone algorithm')
        }

b64_list = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"


def b64_encode(val):
    """Takes as input an integer val and returns a string of it encoded
    with the base64 algorithm used by dict indexes."""
    startfound = 0
    retval = ""
    for i in range(5, -1, -1):
        thispart = (val >> (6 * i)) & ((2 ** 6) - 1)
        if (not startfound) and (not thispart):
            # Both zero -- keep going.
            continue
        startfound = 1
        retval += b64_list[thispart]
    if len(retval):
        return retval
    else:
        return b64_list[0]
    
def b64_decode(str):
    """Takes as input a string and returns an integer value of it decoded
    with the base64 algorithm used by dict indexes."""
    if not len(str):
        return 0
    retval = 0
    shiftval = 0
    for i in range(len(str) - 1, -1, -1):
        val = b64_list.index(str[i])
        retval = retval | (val << shiftval)
        shiftval += 6
    return retval

CRLF = "\r\n"
TAB = "\t"

def quote_reply(s):
    s = string.replace(s, "\n.", "\n..")
    s = string.replace(s, "\n", CRLF)
    return s

# compare two words, trying to be case insensitive
# input is assumed as two tuples of (strings, position),
# string is in UTF-8 encoding
def dict_compare(v1, v2):
    u1 = unicode(v1[0], 'utf-8').lower()
    u2 = unicode(v2[0], 'utf-8').lower()
    return cmp(u1,u2)
