/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __AG_TEXT_H__
#define __AG_TEXT_H__


#include <gtk/gtk.h>


/*
 * ag_text_insert
 * @text :   the text to make de insertion
 * @str  :   the string to insert
 * @len  :   the number of characters to insert
 * inserts a number (@len) of characters of the string (@str)
 * to the GtkText (@text) with the global normal text properties.
 */
void
ag_text_insert(GtkText     *text, 
	       gchar       *str, 
	       gint         len);


/*
 * ag_text_insert_error
 * @text :   the text to make de insertion
 * @str  :   the string to insert
 * @len  :   the number of characters to insert
 * inserts a number (@len) of characters of the string (@str)
 * to the GtkText (@text) with the global error text properties.
 */
void
ag_text_insert_error(GtkText     *text, 
		     gchar       *str, 
		     gint         len);


/*
 * ag_text_insert
 * @text :   the text to make de insertion
 * @str  :   the character to insert
 * inserts the first character of  (@str) to the GtkText (@text) 
 * with the global cursor text properties.
 */
void
ag_text_insert_cursor(GtkText   *text, 
		      gchar     *str);


/*
 * ag_text_delete_all
 * @text  : the text
 * delete all characters from a text.
 */
void
ag_text_delete_all(GtkText *text);



/*
 * ag_text_backward_delete
 * @text  : the text to delete from
 * @i     : number of characters to delete
 * backward deletes a number (@i) of characters of
 * the text (@text).
 */
void
ag_text_backward_delete(GtkText *text,
			gint     i);



/*
 * ag_text_forward_delete
 * @text  : the text to delete from
 * @i     : number of characters to delete
 * forward deletes a number (@i) of characters of
 * the text (@text).
 */
void
ag_text_forward_delete(GtkText *text,
			gint     i);



/*
 * ag_text_ac_input
 * @text  : the text
 * delete all from the GtkText (@text), and draw the cursor.
 * designed for the input_text. 
 */
void
ag_text_ac_input(GtkText   *text);



#endif /* __AG_TEXT_H__ */



