import straw
from dashboard import Dashboard
from error import log
import traceback

class DashboardFrontend:
    def __init__(self):
        self.dash = Dashboard(straw.APPNAME)
        self._encoding = straw.utils.get_locale_encoding()

    def build_clue(self, data, type='textblock', relevance=None):
        d = {'data': data, 'type': type}
        if relevance:
            d['relevance'] = relevance
        return d

    def item_changed(self, item):
        clues = []
        if item.feed.channel_creator:
            clues.append(self.build_clue(
                item.feed.channel_creator, 'email', 5))
        if item.feed.channel_link:
            clues.append(self.build_clue(
                item.feed.channel_link, 'url', 5))
        if item.feed.location:
            clues.append(self.build_clue(
                item.feed.location, 'rss', 4))
        if item.guid:
            clues.append(self.build_clue(
                item.guid, 'url', 6))
        if item.link:
            clues.append(self.build_clue(
                item.link, 'url', 6))
        if item.pub_date:
            clues.append(self.build_clue(
                straw.utils.format_date(item.pub_date, "%Y-%m-%d", self._encoding), 'date', 3))
        if item.source:
            clues.append(self.build_clue(
                item.source, 'url', 1))
        if item.creator:
            clues.append(self.build_clue(
                item.creator, 'email', 6))
        if item.title:
            clues.append(self.build_clue(
                item.title, 'textblock', 3))
        if item.description:
            clues.append(self.build_clue(
                item.description, 'textblock', 2))
        self.send_cluepacket(1, clues)

    def focus_in(self):
        self.send_cluepacket(1)

    def focus_out(self):
        self.send_cluepacket(0)

    def send_cluepacket(self, focus, clues=[]):
        try:
            self.dash.send_cluepacket('1', focus, clues)
        except Exception, e:
            log("Error occured when sending a cluepacket to Dashboard: ", str(e))
            traceback.print_exc()

fe_instance = None

def get_instance():
    global fe_instance
    if fe_instance is None:
        fe_instance = DashboardFrontend()
    return fe_instance
