/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.activities.ActivityActivityBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.util.Util;

final class Persistence {
    static final String PACKAGE_BASE = "activities";
    static final String PACKAGE_FULL = "org.eclipse.ui.activities";
    static final String PACKAGE_PREFIX = "org.eclipse.ui";
    static final String TAG_ACTIVITY = "activity";
    static final String TAG_ACTIVITY_ACTIVITY_BINDING = "activityActivityBinding";
    static final String TAG_DEFAULT_ENABLEMENT = "defaultEnablement";
    static final String TAG_ACTIVITY_ID = "activityId";
    static final String TAG_ACTIVITY_PATTERN_BINDING = "activityPatternBinding";
    static final String TAG_CATEGORY = "category";
    static final String TAG_CATEGORY_ACTIVITY_BINDING = "categoryActivityBinding";
    static final String TAG_CATEGORY_ID = "categoryId";
    static final String TAG_CHILD_ACTIVITY_ID = "childActivityId";
    static final String TAG_ID = "id";
    static final String TAG_NAME = "name";
    static final String TAG_PARENT_ACTIVITY_ID = "parentActivityId";
    static final String TAG_PATTERN = "pattern";
    static final String TAG_PLUGIN_ID = "pluginId";
    static final String TAG_DESCRIPTION = "description";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static ActivityActivityBindingDefinition readActivityActivityBindingDefinition(IMemento memento, String pluginIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String childActivityId = memento.getString(TAG_CHILD_ACTIVITY_ID);
        String parentActivityId = memento.getString(TAG_PARENT_ACTIVITY_ID);
        String pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        return new ActivityActivityBindingDefinition(childActivityId, parentActivityId, pluginId);
    }

    static List readActivityActivityBindingDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ActivityActivityBindingDefinition> list = new ArrayList<ActivityActivityBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readActivityActivityBindingDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static String readDefaultEnablement(IMemento memento) {
        if (memento == null) {
            throw new NullPointerException();
        }
        return memento.getString(TAG_ID);
    }

    static ActivityDefinition readActivityDefinition(IMemento memento, String pluginIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String description = memento.getString(TAG_DESCRIPTION);
        String pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        return new ActivityDefinition(id, name, pluginId, description);
    }

    static List readActivityDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ActivityDefinition> list = new ArrayList<ActivityDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readActivityDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static ActivityPatternBindingDefinition readActivityPatternBindingDefinition(IMemento memento, String pluginIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String activityId = memento.getString(TAG_ACTIVITY_ID);
        String pattern = memento.getString(TAG_PATTERN);
        String pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        return new ActivityPatternBindingDefinition(activityId, pattern, pluginId);
    }

    static List readActivityPatternBindingDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ActivityPatternBindingDefinition> list = new ArrayList<ActivityPatternBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readActivityPatternBindingDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static CategoryActivityBindingDefinition readCategoryActivityBindingDefinition(IMemento memento, String pluginIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String activityId = memento.getString(TAG_ACTIVITY_ID);
        String categoryId = memento.getString(TAG_CATEGORY_ID);
        String pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        return new CategoryActivityBindingDefinition(activityId, categoryId, pluginId);
    }

    static List readCategoryActivityBindingDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<CategoryActivityBindingDefinition> list = new ArrayList<CategoryActivityBindingDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readCategoryActivityBindingDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static CategoryDefinition readCategoryDefinition(IMemento memento, String pluginIdOverride) {
        if (memento == null) {
            throw new NullPointerException();
        }
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String description = memento.getString(TAG_DESCRIPTION);
        String pluginId = pluginIdOverride != null ? pluginIdOverride : memento.getString(TAG_PLUGIN_ID);
        return new CategoryDefinition(id, name, pluginId, description);
    }

    static List readCategoryDefinitions(IMemento memento, String name, String pluginIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<CategoryDefinition> list = new ArrayList<CategoryDefinition>(mementos.length);
        int i = 0;
        while (i < mementos.length) {
            list.add(Persistence.readCategoryDefinition(mementos[i], pluginIdOverride));
            ++i;
        }
        return list;
    }

    static void writeActivityActivityBindingDefinition(IMemento memento, ActivityActivityBindingDefinition activityActivityBindingDefinition) {
        if (memento == null || activityActivityBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_CHILD_ACTIVITY_ID, activityActivityBindingDefinition.getChildActivityId());
        memento.putString(TAG_PARENT_ACTIVITY_ID, activityActivityBindingDefinition.getParentActivityId());
        memento.putString(TAG_PLUGIN_ID, activityActivityBindingDefinition.getPluginId());
    }

    static void writeActivityActivityBindingDefinitions(IMemento memento, String name, List activityActivityBindingDefinitions) {
        if (memento == null || name == null || activityActivityBindingDefinitions == null) {
            throw new NullPointerException();
        }
        activityActivityBindingDefinitions = new ArrayList(activityActivityBindingDefinitions);
        Iterator iterator = activityActivityBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.ActivityActivityBindingDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = activityActivityBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActivityActivityBindingDefinition(memento.createChild(name), (ActivityActivityBindingDefinition)iterator.next());
        }
    }

    static void writeActivityDefinition(IMemento memento, ActivityDefinition activityDefinition) {
        if (memento == null || activityDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ID, activityDefinition.getId());
        memento.putString(TAG_NAME, activityDefinition.getName());
        memento.putString(TAG_PLUGIN_ID, activityDefinition.getPluginId());
    }

    static void writeActivityDefinitions(IMemento memento, String name, List activityDefinitions) {
        if (memento == null || name == null || activityDefinitions == null) {
            throw new NullPointerException();
        }
        activityDefinitions = new ArrayList(activityDefinitions);
        Iterator iterator = activityDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.ActivityDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = activityDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActivityDefinition(memento.createChild(name), (ActivityDefinition)iterator.next());
        }
    }

    static void writeActivityPatternBindingDefinition(IMemento memento, ActivityPatternBindingDefinition activityPatternBindingDefinition) {
        if (memento == null || activityPatternBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ACTIVITY_ID, activityPatternBindingDefinition.getActivityId());
        memento.putString(TAG_PATTERN, activityPatternBindingDefinition.getPattern());
        memento.putString(TAG_PLUGIN_ID, activityPatternBindingDefinition.getPluginId());
    }

    static void writeActivityPatternBindingDefinitions(IMemento memento, String name, List activityPatternBindingDefinitions) {
        if (memento == null || name == null || activityPatternBindingDefinitions == null) {
            throw new NullPointerException();
        }
        activityPatternBindingDefinitions = new ArrayList(activityPatternBindingDefinitions);
        Iterator iterator = activityPatternBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = activityPatternBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActivityPatternBindingDefinition(memento.createChild(name), (ActivityPatternBindingDefinition)iterator.next());
        }
    }

    static void writeCategoryActivityBindingDefinition(IMemento memento, CategoryActivityBindingDefinition categoryActivityBindingDefinition) {
        if (memento == null || categoryActivityBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ACTIVITY_ID, categoryActivityBindingDefinition.getActivityId());
        memento.putString(TAG_CATEGORY_ID, categoryActivityBindingDefinition.getCategoryId());
        memento.putString(TAG_PLUGIN_ID, categoryActivityBindingDefinition.getPluginId());
    }

    static void writeCategoryActivityBindingDefinitions(IMemento memento, String name, List categoryActivityBindingDefinitions) {
        if (memento == null || name == null || categoryActivityBindingDefinitions == null) {
            throw new NullPointerException();
        }
        categoryActivityBindingDefinitions = new ArrayList(categoryActivityBindingDefinitions);
        Iterator iterator = categoryActivityBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = categoryActivityBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCategoryActivityBindingDefinition(memento.createChild(name), (CategoryActivityBindingDefinition)iterator.next());
        }
    }

    static void writeCategoryDefinition(IMemento memento, CategoryDefinition categoryDefinition) {
        if (memento == null || categoryDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_ID, categoryDefinition.getId());
        memento.putString(TAG_NAME, categoryDefinition.getName());
        memento.putString(TAG_PLUGIN_ID, categoryDefinition.getPluginId());
    }

    static void writeCategoryDefinitions(IMemento memento, String name, List categoryDefinitions) {
        if (memento == null || name == null || categoryDefinitions == null) {
            throw new NullPointerException();
        }
        categoryDefinitions = new ArrayList(categoryDefinitions);
        Iterator iterator = categoryDefinitions.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.internal.activities.CategoryDefinition");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Util.assertInstance(e, clazz);
        }
        iterator = categoryDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCategoryDefinition(memento.createChild(name), (CategoryDefinition)iterator.next());
        }
    }

    private Persistence() {
    }
}

