/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ColorSchemeService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.presentations.BasicStackPresentation;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.themes.ITheme;

public class PartTabFolderPresentation
extends BasicStackPresentation {
    private IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("VIEW_TAB_POSITION".equals(propertyChangeEvent.getProperty()) && !PartTabFolderPresentation.this.isDisposed()) {
                int tabLocation = PartTabFolderPresentation.this.preferenceStore.getInt("VIEW_TAB_POSITION");
                PartTabFolderPresentation.this.setTabPosition(tabLocation);
            } else if ("SHOW_TRADITIONAL_STYLE_TABS".equals(propertyChangeEvent.getProperty()) && !PartTabFolderPresentation.this.isDisposed()) {
                boolean traditionalTab = PartTabFolderPresentation.this.preferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
                PartTabFolderPresentation.this.setTabStyle(traditionalTab);
            }
        }
    };

    public PartTabFolderPresentation(Composite parent, IStackPresentationSite newSite, int flags) {
        super(new CTabFolder(parent, 2048), newSite);
        CTabFolder tabFolder = this.getTabFolder();
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        int tabLocation = this.preferenceStore.getInt("VIEW_TAB_POSITION");
        this.setTabPosition(tabLocation);
        this.setTabStyle(this.preferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        tabFolder.setUnselectedCloseVisible(false);
        tabFolder.setUnselectedImageVisible(false);
        ColorSchemeService.setTabAttributes(this, tabFolder);
        this.updateGradient();
        tabFolder.setMinimizeVisible((flags & 0x80) != 0);
        tabFolder.setMaximizeVisible((flags & 0x400) != 0);
    }

    protected void setTabStyle(boolean traditionalTab) {
        this.getTabFolder().setSimpleTab(traditionalTab);
    }

    private void updateGradient() {
        boolean vertical;
        Color fgColor;
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        FontRegistry fontRegistry = currentTheme.getFontRegistry();
        ColorRegistry colorRegistry = currentTheme.getColorRegistry();
        Color[] bgColors = new Color[2];
        int[] percent = new int[1];
        if (this.isActive()) {
            CTabItem item = this.getTabFolder().getSelection();
            if (item != null && !this.getPartForTab(item).isBusy()) {
                Font tabFont = fontRegistry.get("org.eclipse.ui.workbench.TAB_TEXT_FONT");
                item.setFont(tabFont);
            }
            fgColor = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR");
            bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
            bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
            percent[0] = currentTheme.getInt("org.eclipse.ui.workbench.ACTIVE_TAB_PERCENT");
            vertical = currentTheme.getBoolean("org.eclipse.ui.workbench.ACTIVE_TAB_VERTICAL");
        } else {
            fgColor = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR");
            bgColors[0] = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START");
            bgColors[1] = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END");
            percent[0] = currentTheme.getInt("org.eclipse.ui.workbench.INACTIVE_TAB_PERCENT");
            vertical = currentTheme.getBoolean("org.eclipse.ui.workbench.INACTIVE_TAB_VERTICAL");
        }
        this.drawGradient(fgColor, bgColors, percent, vertical);
    }

    public void setActive(boolean isActive) {
        super.setActive(isActive);
        this.updateGradient();
    }

    public void dispose() {
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        super.dispose();
    }
}

