/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Orientable;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Insets;

public class ArrowButton
extends Button
implements Orientable {
    public ArrowButton() {
        this.createTriangle();
        this.setRequestFocusEnabled(false);
        this.setFocusTraversable(false);
    }

    public ArrowButton(int direction) {
        this.createTriangle();
        this.setRequestFocusEnabled(false);
        this.setFocusTraversable(false);
        this.setDirection(direction);
    }

    protected void createTriangle() {
        Triangle tri = new Triangle();
        tri.setOutline(true);
        tri.setBackgroundColor(ColorConstants.listForeground);
        tri.setBorder(new MarginBorder(new Insets(2)));
        this.setContents(tri);
    }

    public void setDirection(int value) {
        this.setChildrenDirection(value);
    }

    public void setOrientation(int value) {
        this.setChildrenOrientation(value);
    }
}

