/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    int hScrollBar;
    int vScrollBar;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int[] outMetric = new int[1];
        OS.GetThemeMetric((int)0, (int[])outMetric);
        if (this.horizontalBar != null) {
            height += outMetric[0];
        }
        if (this.verticalBar != null) {
            width += outMetric[0];
        }
        Rect inset = this.inset();
        return new Rectangle(x -= inset.left, y -= inset.top, width += inset.left + inset.right, height += inset.top + inset.bottom);
    }

    ScrollBar createScrollBar(int style) {
        return new ScrollBar(this, style);
    }

    ScrollBar createStandardBar(int style) {
        int[] outControl;
        short[] count = new short[1];
        OS.CountSubControls((int)this.handle, (short[])count);
        if (count[0] == 0) {
            return null;
        }
        int index = (style & 0x100) != 0 ? 1 : 2;
        int status = OS.GetIndexedSubControl((int)this.handle, (short)((short)index), (int[])(outControl = new int[1]));
        if (status != 0) {
            return null;
        }
        ScrollBar bar = new ScrollBar();
        bar.parent = this;
        bar.style = style;
        bar.display = this.display;
        bar.handle = outControl[0];
        bar.register();
        bar.hookEvents();
        return bar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.handle, (Rect)rect);
        return new Rectangle(0, 0, rect.right - rect.left, rect.bottom - rect.top);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0 && this.scrolledHandle != 0) {
            int controlProc = this.display.controlProc;
            int[] mask = new int[]{1668183148, 4};
            int controlTarget = OS.GetControlEventTarget((int)this.scrolledHandle);
            OS.InstallEventHandler((int)controlTarget, (int)controlProc, (int)(mask.length / 2), (int[])mask, (int)this.scrolledHandle, null);
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2) || this.hooks(31);
    }

    Rect inset() {
        if ((this.state & 2) != 0) {
            Rect rect = new Rect();
            int[] outMetric = new int[1];
            if (this.drawFocusRing() && (this.style & 0x80000) == 0 && this.hooksKeys()) {
                OS.GetThemeMetric((int)7, (int[])outMetric);
                rect.left = (short)(rect.left + outMetric[0]);
                rect.top = (short)(rect.top + outMetric[0]);
                rect.right = (short)(rect.right + outMetric[0]);
                rect.bottom = (short)(rect.bottom + outMetric[0]);
            }
            if (this.hasBorder()) {
                OS.GetThemeMetric((int)5, (int[])outMetric);
                rect.left = (short)(rect.left + outMetric[0]);
                rect.top = (short)(rect.top + outMetric[0]);
                rect.right = (short)(rect.right + outMetric[0]);
                rect.bottom = (short)(rect.bottom + outMetric[0]);
            }
            return rect;
        }
        return Widget.EMPTY_RECT;
    }

    boolean isTrimHandle(int trimHandle) {
        if (this.horizontalBar != null && this.horizontalBar.handle == trimHandle) {
            return true;
        }
        if (this.verticalBar != null && this.verticalBar.handle == trimHandle) {
            return true;
        }
        return trimHandle == this.scrolledHandle;
    }

    int kEventMouseWheelMoved(int nextHandler, int theEvent, int userData) {
        Event event;
        int position;
        int result = super.kEventMouseWheelMoved(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if ((this.state & 2) != 0) {
            ScrollBar bar;
            short[] wheelAxis = new short[1];
            OS.GetEventParameter((int)theEvent, (int)1836540280, (int)1836540280, null, (int)2, null, (short[])wheelAxis);
            ScrollBar scrollBar = bar = wheelAxis[0] == 0 ? this.horizontalBar : this.verticalBar;
            if (bar != null && bar.getVisible()) {
                int[] wheelDelta = new int[1];
                OS.GetEventParameter((int)theEvent, (int)1836541036, (int)1819242087, null, (int)4, null, (int[])wheelDelta);
                bar.setSelection(Math.max(0, bar.getSelection() - bar.getIncrement() * wheelDelta[0]));
                Event event2 = new Event();
                event2.detail = wheelDelta[0] > 0 ? 0x1000005 : 0x1000006;
                bar.sendEvent(13, event2);
                this.update();
            }
            return 0;
        }
        int vPosition = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int hPosition = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        result = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
        if (this.verticalBar != null && (position = this.verticalBar.getSelection()) != vPosition) {
            event = new Event();
            event.detail = position < vPosition ? 0x1000005 : 0x1000006;
            this.verticalBar.sendEvent(13, event);
        }
        if (this.horizontalBar != null && (position = this.horizontalBar.getSelection()) != hPosition) {
            event = new Event();
            event.detail = position < vPosition ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendEvent(13, event);
        }
        return result;
    }

    void layoutControl(boolean events) {
        boolean isVisibleVBar;
        if (this.scrolledHandle == 0) {
            return;
        }
        int vWidth = 0;
        int hHeight = 0;
        int[] outMetric = new int[1];
        OS.GetThemeMetric((int)0, (int[])outMetric);
        boolean isVisibleHBar = this.horizontalBar != null && this.horizontalBar.getVisible();
        boolean bl = isVisibleVBar = this.verticalBar != null && this.verticalBar.getVisible();
        if (isVisibleHBar) {
            hHeight = outMetric[0];
        }
        if (isVisibleVBar) {
            vWidth = outMetric[0];
        }
        Rect rect = new Rect();
        OS.GetControlBounds((int)this.scrolledHandle, (Rect)rect);
        Rect inset = this.inset();
        int width = Math.max(0, rect.right - rect.left - vWidth - inset.left - inset.right);
        int height = Math.max(0, rect.bottom - rect.top - hHeight - inset.top - inset.bottom);
        this.setBounds(this.handle, inset.left, inset.top, width, height, true, true, false);
        if (isVisibleHBar) {
            this.setBounds(this.horizontalBar.handle, inset.left, inset.top + height, width, hHeight, true, true, false);
        }
        if (isVisibleVBar) {
            this.setBounds(this.verticalBar.handle, inset.left + width, inset.top, vWidth, height, true, true, false);
        }
        if (events) {
            this.sendEvent(11);
        }
    }

    void register() {
        super.register();
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.scrolledHandle = 0;
    }

    void releaseWidget() {
        if (this.horizontalBar != null) {
            this.horizontalBar.releaseResources();
        }
        if (this.verticalBar != null) {
            this.verticalBar.releaseResources();
        }
        this.verticalBar = null;
        this.horizontalBar = null;
        super.releaseWidget();
    }

    void resetVisibleRegion(int control) {
        if (this.verticalBar != null) {
            this.verticalBar.resetVisibleRegion(control);
        }
        if (this.horizontalBar != null) {
            this.horizontalBar.resetVisibleRegion(control);
        }
        super.resetVisibleRegion(control);
    }

    int setBounds(int control, int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(control, x, y, width, height, move, resize, false);
        if ((result & 0x40) != 0 && events) {
            this.sendEvent(10);
        }
        if ((result & 0x80) != 0) {
            if (control == this.scrolledHandle) {
                this.layoutControl(false);
            }
            if (events) {
                this.sendEvent(11);
            }
        }
        return result;
    }

    void setScrollbarVisible(ScrollBar bar, boolean visible) {
        if (this.scrolledHandle == 0) {
            return;
        }
        if (visible) {
            if ((bar.state & 0x10) == 0) {
                return;
            }
            bar.state &= 0xFFFFFFEF;
        } else {
            if ((bar.state & 0x10) != 0) {
                return;
            }
            bar.state |= 0x10;
        }
        this.setVisible(bar.handle, visible);
        this.layoutControl(true);
        bar.sendEvent(visible ? 22 : 23);
    }

    int topHandle() {
        if (this.scrolledHandle != 0) {
            return this.scrolledHandle;
        }
        return this.handle;
    }
}

