/* -*- mode: c; c-file-style: "gnu" -*-
 * nqueue_devpoll.h - /dev/poll-based event system, prototypes
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef _THY_NQUEUE_DEVPOLL_H
#define _THY_NQUEUE_DEVPOLL_H

#include "types.h"

void thy_nq_fd_control_devpoll (int fd, thy_nq_event_t event, int set);
int thy_nq_init_devpoll (void);
int thy_nq_fd_check_devpoll (int fd, thy_nq_event_t event);
int thy_nq_wait_devpoll (long int timeout);

#endif

/* arch-tag: f774e4b1-cee9-4030-9222-64f12ef7696d */
