
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include "umserver.hpp"
#include "umsflow.hpp"
#include <ubit/umsproto.hpp>
#include <X11/Xatom.h>
using namespace std;


static inline void FIX_TIME(timeval& time) {
  while (time.tv_usec >= 1000000) {
    time.tv_usec -= 1000000;                  
    time.tv_sec++;                            
  }
  while (time.tv_usec < 0) {
    if (time.tv_sec > 0) {
      time.tv_usec += 1000000;
      time.tv_sec--;
    }
    else {         
      time.tv_usec = 0;
      break;
    }      
  }
}


Time UMServer::getTime() {
  timeval time;
  gettimeofday(&time, 0);
  FIX_TIME(time);
  return time.tv_sec * 1000 + time.tv_usec % 1000;
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

void UMServer::sendButtonEvent(UMSmouseFlow& output_flow, UMSpos& pos,
			       u_id btn_maskid, bool press) {
  XEvent e;
  e.xbutton.type       = (press ? ButtonPress : ButtonRelease);
  e.xbutton.serial     = 0;
  e.xbutton.send_event = false;    // true if this came from a SendEvent request

  // ici il y un pbm: ca doit etre le display de l'appli pas celui du mouse
  // driver. c'est OK pour XSendEvent (qui corrige) mais pas pour write direct
  // (il faut alors corriger a la reception) 
  e.xbutton.display   = xdisplay;    // Display the event was read from 
  e.xbutton.window    = pos.win;     // event window it is reported relative to
  e.xbutton.root      = xrootwin;    // root window that the event occurred on
  e.xbutton.subwindow = None;        // child window: 
  e.xbutton.time      = getTime();   // milliseconds
  e.xbutton.x         = pos.wx;      // pointer x, y coordinates in event window
  e.xbutton.y         = pos.wy;
  e.xbutton.x_root    = pos.rx;      // coordinates relative to root
  e.xbutton.y_root    = pos.ry;

  // The state member is set to indicate the logical state of the pointer 
  // buttons and modifier keys JUST PRIOR to the event
  e.xbutton.state = output_flow.getState();

  unsigned int btn = 0;
  switch (btn_maskid) {
    case Button1Mask:
      btn = Button1;
      break;
    case Button2Mask:
      btn = Button2;
      break;
    case Button3Mask:
      btn = Button3;
      break;
    case Button4Mask:
      btn = Button4;
      break;
    case Button5Mask:
      btn = Button5;
      break;
  }
  e.xbutton.button = btn;	// detail
  e.xbutton.same_screen = true;	// same screen flag:    A REVOIR!!!
  
  if (output_flow.getID() != 0 && pos.ptr_in_uwin) {
    e.xbutton.state = e.xbutton.state | UMSprotocol::UBIT_EVENT_FLOW;
    e.xbutton.subwindow = output_flow.getID();       // conventional !!
  }

#ifdef USE_SOCKET
  // cas (UMS flow  ET  Ubit win) => envoyer event sur canal specifique
  if (output_flow.getID() != 0 && pos.winsock > -1) {
    write(pos.winsock, &e, sizeof(XEvent));
  }
  // cas (X flow)  OU  (UMS flow mais non-Ubit win) => envoi standard X cnx
  else
#endif
  {
    long ev_mask = (press ? ButtonPressMask : ButtonReleaseMask);
    XSendEvent(xdisplay, pos.win, False, ev_mask, &e);
    XFlush(xdisplay);
  }
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

void UMServer::sendKeyEvent(UMSmouseFlow& output_flow, UMSpos& pos,
			    int keycode, bool press) {
  XEvent e;
  e.xbutton.type       = (press ? KeyPress : KeyRelease);
  e.xbutton.serial     = 0;
  e.xbutton.send_event = false;    // true if this came from a SendEvent request

  // ici il y un pbm: ca doit etre le display de l'appli pas celui du mouse
  // driver. c'est OK pour XSendEvent (qui corrige) mais pas pour write direct
  // (il faut alors corriger a la reception) 
  e.xbutton.display   = xdisplay;    // Display the event was read from 
  e.xbutton.window    = pos.win;     // event window it is reported relative to
  e.xbutton.root      = xrootwin;    // root window that the event occurred on
  e.xbutton.subwindow = None;        // child window: utile??
  e.xbutton.time      = getTime();   // milliseconds
  e.xbutton.x         = pos.wx;      // pointer x, y coordinates in event window
  e.xbutton.y         = pos.wy;
  e.xbutton.x_root    = pos.rx;      // coordinates relative to root
  e.xbutton.y_root    = pos.ry;

  // The state member is set to indicate the logical state of the pointer 
  // buttons and modifier keys JUST PRIOR to the event
  e.xbutton.state = output_flow.getState();

  e.xbutton.button = keycode;	// detail
  e.xbutton.same_screen = true;	// same screen flag:    A REVOIR!!!

  if (output_flow.getID() != 0 && pos.ptr_in_uwin) {
    e.xbutton.state = e.xbutton.state | UMSprotocol::UBIT_EVENT_FLOW;
    e.xbutton.subwindow = output_flow.getID();       // conventional !!
  }

#ifdef USE_SOCKET
  // cas (UMS flow  ET  Ubit win) => envoyer event sur canal specifique
  if (output_flow.getID() != 0 && pos.winsock > -1) {
    write(pos.winsock, &e, sizeof(XEvent));
  }
  // cas (X flow)  OU  (UMS flow mais non-Ubit win) => envoi standard X cnx
  else
#endif
  {
    long ev_mask = (press ? KeyPressMask : KeyReleaseMask);
    XSendEvent(xdisplay, pos.win, False, ev_mask, &e);
    XFlush(xdisplay);
  }
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

void UMServer::sendMotionEvent(UMSmouseFlow& output_flow, UMSpos& pos) {
  XEvent e;
  e.xmotion.type       = MotionNotify;
  e.xmotion.serial     = 0;
  e.xmotion.send_event = false;
  e.xmotion.display    = xdisplay;
  e.xmotion.window     = pos.win;
  e.xmotion.root       = xrootwin;
  e.xmotion.subwindow  = None;
  e.xmotion.time       = getTime();
  e.xmotion.x          = pos.wx;
  e.xmotion.y          = pos.wy;
  e.xmotion.x_root     = pos.rx;
  e.xmotion.y_root     = pos.ry;

  // The state member is set to indicate the logical state of the pointer 
  // buttons and modifier keys JUST PRIOR to the event
  e.xmotion.state = output_flow.getState();
  e.xmotion.is_hint = NotifyNormal; // ????
  e.xmotion.same_screen = true;	    // same screen flag:    A REVOIR!!!

  if (output_flow.getID() != 0 && pos.ptr_in_uwin) {
    e.xmotion.state =  e.xbutton.state | UMSprotocol::UBIT_EVENT_FLOW;
    e.xmotion.subwindow = output_flow.getID();       // conventional !!
  }

#ifdef USE_SOCKET
  // cas (UMS flow  ET  Ubit win) => envoyer event sur canal specifique
  if (output_flow.getID() != 0 && pos.winsock > -1) {
    write(pos.winsock, &e, sizeof(XEvent));
  }
  // cas (X flow)  OU  (UMS flow mais non-Ubit win) => envoi standard X cnx
  else
#endif
  {
    long ev_mask = PointerMotionMask;
    long state_mask = output_flow.getState();

    if (state_mask & Button1Mask) 
      ev_mask = ev_mask | (Button1MotionMask | ButtonMotionMask);
    if (state_mask & Button2Mask) 
      ev_mask = ev_mask | (Button2MotionMask | ButtonMotionMask);
    if (state_mask & Button3Mask) 
      ev_mask = ev_mask | (Button3MotionMask | ButtonMotionMask);
    if (state_mask & Button4Mask) 
      ev_mask = ev_mask | (Button4MotionMask | ButtonMotionMask);
    if (state_mask & Button5Mask) 
      ev_mask = ev_mask | (Button5MotionMask | ButtonMotionMask);

    XSendEvent(xdisplay, pos.win, False, ev_mask, &e);
    XFlush(xdisplay);
  }
}

/* ==================================================== [Elc:02] ======= */
/* ==================================================== ======== ======= */

void UMServer::sendCrossingEvent(UMSmouseFlow& output_flow, UMSpos& pos,
				 bool enter) {
  XEvent e;
  e.xcrossing.type       = (enter ? EnterNotify : LeaveNotify);
  e.xcrossing.serial     = 0;
  e.xcrossing.send_event = false;
  e.xcrossing.display    = xdisplay;
  e.xcrossing.window     = pos.win;
  e.xcrossing.root       = xrootwin;
  e.xcrossing.subwindow  = None;
  e.xcrossing.time       = getTime();
  e.xcrossing.x          = pos.wx;
  e.xcrossing.y          = pos.wy;
  e.xcrossing.x_root     = pos.rx;
  e.xcrossing.y_root     = pos.ry;
  e.xcrossing.mode       = NotifyNormal; // ?? NotifyNormal, NotifyGrab, NotifyUngrab
  // ?? NotifyAncestor, NotifyVirtual, NotifyInferior,
  // ?? NotifyNonlinear,NotifyNonlinearVirtual
  e.xcrossing.detail     = NotifyAncestor; 
  e.xcrossing.same_screen= true;
  e.xcrossing.focus      = True;                     // boolean focus  (???)
  e.xcrossing.state      = output_flow.getState();   // key or button mask

  if (output_flow.getID() != 0 && pos.ptr_in_uwin) {
    e.xcrossing.state =  e.xbutton.state | UMSprotocol::UBIT_EVENT_FLOW;
    e.xcrossing.subwindow = output_flow.getID();       // conventional !!
  }

#ifdef USE_SOCKET
  // cas (UMS flow  ET  Ubit win) => envoyer event sur canal specifique
  if (output_flow.getID() != 0 && pos.winsock > -1) {
    write(pos.winsock, &e, sizeof(XEvent));
  }
  // cas (X flow)  OU  (UMS flow mais non-Ubit win) => envoi standard X cnx
  else
#endif
  {
    long ev_mask = enter ? EnterWindowMask : LeaveWindowMask;
    XSendEvent(xdisplay, pos.win, False, ev_mask, &e);
    XFlush(xdisplay);
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UMServer::sendMessage(UMSeventFlow& output_flow, UMSpos& pos,
                           const char* message) {  
  if (!message) return;
  int len = strlen(message);
  
  if (len-1 < SHORT_MESSAGE_SIZE)
    sendShortMessage(output_flow, pos, message);
  else sendLongMessage(output_flow, pos, message, len);
}

/* ==================================================== ======== ======= */

void UMServer::sendShortMessage(UMSeventFlow& output_flow, UMSpos& pos,
                                const char message[SHORT_MESSAGE_SIZE]) {
  XEvent e;
  e.xclient.type       = ClientMessage;
  e.xclient.serial     = 0;
  e.xclient.send_event = false;	   // true if this came from a SendEvent request

  // ici il y un pbm: ca doit etre le display de l'appli pas celui du mouse
  // driver. c'est OK pour XSendEvent (qui corrige) mais pas pour write direct
  // (il faut alors corriger a la reception) 
  e.xclient.display = xdisplay;	// Display the event was read from
  e.xclient.window = pos.win;    //``event'' window it is reported relative to
  e.xclient.message_type = UBIT_MESSAGE;
  e.xclient.format = 8;         // table of chars
  memcpy(e.xclient.data.b, message, SHORT_MESSAGE_SIZE-1);
  e.xclient.data.b[SHORT_MESSAGE_SIZE-1] = 0;
  
#ifdef USE_SOCKET
  // cas (UMS flow  ET  Ubit win) => envoyer event sur canal specifique
  if (output_flow.getID() != 0 && pos.winsock > -1) {
    write(pos.winsock, &e, sizeof(XEvent));
  }
  // cas (X flow)  OU  (UMS flow mais non-Ubit win) => envoi standard X cnx
  else
#endif
   {
    long ev_mask = 0;		// ok??
    XSendEvent(xdisplay, pos.win, False, ev_mask, &e);
    XFlush(xdisplay);
  }
}

/* ==================================================== ======== ======= */

void UMServer::sendLongMessage(UMSeventFlow& output_flow, UMSpos& pos,
                               const char* message, int message_len) {

  // ATT: If there is insufficient space, a BadAlloc error results.

  XChangeProperty(xdisplay, pos.win,
                  UBIT_MESSAGE/*property*/,
                  XA_STRING/*type*/,
                  8/*format*/,
                  PropModeReplace/*mode*/,
                  (unsigned char*)message, message_len);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
