#ifndef HEADER_FILE_INCLUDED
#define HEADER_FILE_INCLUDED

#include <stdio.h>		/* size_t */
#include <sys/utsname.h>

/* How long are the records in utsname? */

#ifndef UTSLEN

#ifdef SYS_NMLN
#define UTSLEN SYS_NMLN
#else
#define UTSLEN 384		/* What the hell should one use as default?
				   Biggest SYS_NMLN I've seen was 257 */
#endif /* SYS_NMLN */
#endif /* UTSLEN */

/* max lenght of  kern_vers  */
#define VERSLEN 3*UTSLEN

/* max lenght of a line buffer used to parse the record file */
#define LINELEN 2048


struct logentry
  {
    float uptime;
    char kern_vers[VERSLEN];
  };

struct record
  {
    struct logentry le[3];
  };

extern int gethostname (char *, size_t);

#endif
