// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        fieldfilter.h
// 
// Purpose:     every Field may have a list of those filters
// 
// Created:     26 Sep 1996   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: fieldfilter.h,v 1.2 1996/10/30 10:08:46 jfasch Exp $
// 
// $Log: fieldfilter.h,v $
// Revision 1.2  1996/10/30 10:08:46  jfasch
// mainly debug output
//
// Revision 1.1  1996/10/15 15:45:43  jfasch
// verbose and assert movings
//
// 
// </file> 
#ifndef hg_hyperg_fieldfilter_h
#define hg_hyperg_fieldfilter_h

#include <hyperg/utils/fields.h>
#include <hyperg/utils/smartptr.h>

#ifndef VERBOSE
#  define VERBOSE
#endif
#include <hyperg/utils/verbose.h>

class RString ;

class FieldFilter : public RefCounted {
public:
   virtual ~FieldFilter() {} 
   virtual bool doIt (const RString& in, RString& out) = 0 ;
   virtual const char* description() const = 0 ;

public:
   static const char* version1 ;
} ;
static const char* hg_hyperg_fieldfilter_version = FieldFilter::version1 ;

SmartPtrdeclare (FieldFilterPtr, FieldFilter) ;

Fieldsdeclare (FieldFilterListBase, FieldFilterPtr) ;

class FieldFilterList : public FieldFilterListBase {
public:
   bool doIt (const RString& in, RString& out) ;
   const char* explain() const ;

   static Verbose verbose ;
} ;

class SGMLToISOFilter : public FieldFilter {
public:
   virtual bool doIt (const RString& in, RString& out) ;
   virtual const char* description() const { return "SGMLToISOFilter"; }
} ;

class ASCIILowerFilter : public FieldFilter {
public:
   bool doIt (const RString& in, RString& out) ;
   virtual const char* description() const { return "ASCIILowerFilter"; }
} ;

class SGMLISOToLowerASCIIFilter : public FieldFilter {
public:
   virtual bool doIt (const RString& in, RString& out) ;
   virtual const char* description() const { return "SGMLISOToLowerASCIIFilter"; }
} ;


#endif
