#!/usr/local/bin/perl
# index.cgi
# List all services currently being monitored

require './status-lib.pl';
print "Refresh: $config{'refresh'}\r\n"
	if ($config{'refresh'});
&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1);

# If we are using SNMP for notification, make sure the Perl module is installed
if ($config{'snmp_server'}) {
	eval "use Net::SNMP";
	if ($@) {
		&ui_print_endpage(
		    &ui_config_link('index_esnmp',
			[ "<tt>Net::SNMP</tt>",
			  "../cpan/download.cgi?source=3&cpan=Net::SNMP&mode=2&return=/$module_name/&returndesc=".&urlize($text{'index_return'}),
			  undef ]));
		}
	}

@serv = &list_services();
$mid = int((@serv-1) / 2);
$oldstatus = &read_file($oldstatus_file, \%oldstatus);

if (@serv) {
	if ($config{'sort_mode'} == 1) {
		@serv = sort { $a->{'desc'} cmp $b->{'desc'} } @serv;
		}
	elsif ($config{'sort_mode'} == 2) {
		@serv = sort { $a->{'remote'} cmp $b->{'remote'} } @serv;
		}
	if (!$config{'index_status'} && $oldstatus) {
		local @st = stat("$module_config_directory/oldstatus");
		local $t = localtime($st[9]);
		print &text('index_oldtime', $t),"<br>\n";
		}
	print "<table width=100%><tr>\n";
	&show_button();
	print "</tr></table>\n";

	print "<table width=100%><tr>\n";
	print "<td width=50% valign=top>\n";
	&service_table(@serv[0 .. $mid]);
	print "</td> <td width=50% valign=top>\n";
	&service_table(@serv[$mid+1 .. $#serv]) if (@serv > 1);
	print "</td></tr></table>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}

print "<table width=100%><tr>\n";
&show_button();

if ($access{'sched'}) {
	print "<form action=edit_sched.cgi>\n";
	print "<td align=right><input type=submit ",
	      "value='$text{'index_sched'}'></td></form>\n";
	}
else {
	print "<td></td>\n";
	}
print "</tr></table>\n";

&remote_finished();
&ui_print_footer("/", $text{'index'});

sub service_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_desc'}</b></td>\n";
print "<td><b>$text{'index_host'}</b></td>\n";
if ($config{'index_status'}) {
	print "<td><b>$text{'index_up'}</b></td> ";
	}
elsif ($oldstatus) {
	print "<td><b>$text{'index_last'}</b></td> ";
	}
print "</tr>\n";
foreach $s (@_) {
	print "<tr $cb>\n";
	if ($access{'edit'}) {
		print "<td><a href='edit_mon.cgi?id=$s->{'id'}'>",
		      &html_escape($s->{'desc'}),"</a></td>\n";
		}
	else {
		print "<td>",&html_escape($s->{'desc'}),"</td>\n";
		}
	print "<td>",$s->{'remote'} ? &html_escape($s->{'remote'})
				    : $text{'index_local'},"</td>\n";
	if ($config{'index_status'}) {
		$stat = &service_status($s, 1);
		print "<td><img src=images/",
		      $stat->{'up'} == 1 ? "up.gif" :
		      $stat->{'up'} == -1 ? "not.gif" :
		      $stat->{'up'} == -2 ? "webmin.gif" :
		      $stat->{'up'} == -3 ? "timed.gif" : "down.gif","></td>\n";
		}
	elsif ($oldstatus) {
		$o = $oldstatus{$s->{'id'}};
		print "<td><img src=images/",
		      $o eq '' ? "quest.gif" :
		      $o == 1 ? "up.gif" :
		      $o == -1 ? "not.gif" :
		      $o == -2 ? "webmin.gif" :
		      $o == -3 ? "timed.gif" : "down.gif","></td>\n";
		}
	print "</tr>\n";
	}
print "</table>\n";
}

sub show_button
{
if ($access{'edit'}) {
	print "<form action=edit_mon.cgi>\n";
	print "<td><input type=submit value='$text{'index_add'}'> ",
	      "<select name=type>\n";
	foreach $h (sort { $a->[1] cmp $b->[1] } &list_handlers()) {
		printf "<option value=%s>%s\n",
			$h->[0], $h->[1] || $h->[0];
		}
	print "</select></td></form>\n";
	}
else {
	print "<td></td>\n";
	}
}

