#!/usr/local/bin/perl
# index.cgi
# Display available apache or squid logfiles

require './webalizer-lib.pl';
&foreign_require("cron", "cron-lib.pl");

# Check if webalizer is actually installed
if (!&has_command($config{'webalizer'})) {
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
		&help_search_link("webalizer", "man", "doc", "google"));
	print &text('index_ewebalizer', "<tt>$config{'webalizer'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}

# Get the version number
$webalizer_version = &get_webalizer_version(\$out);
if (!$webalizer_version) {
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
		&help_search_link("webalizer", "man", "doc", "google"));
	print &text('index_egetversion',
			  "<tt>$config{'webalizer'} -v</tt>",
			  "<pre>$out</pre>"),"<p>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}

if ($webalizer_version < 2) {
	&main_header();
	print &text('index_eversion', "<tt>$config{'webalizer'}</tt>",
			  "$webalizer_version", "2.0"),"<p>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}

# Check if the config file exists
if (!-r $config{'webalizer_conf'} && -r $config{'alt_conf'}) {
	# No, but the sample one does
	system("cp '$config{'alt_conf'}' '$config{'webalizer_conf'}' >/dev/null 2>&1");
	}
if (!-r $config{'webalizer_conf'}) {
	&main_header();
	print &text('index_econf', "<tt>$config{'webalizer_conf'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}

# Query apache and squid for their logfiles
@logs = &get_all_logs();

# Remove in-accessible logs, and redirect if only one
@logs = grep { &can_edit_log($_->{'file'}) } @logs;
if (@logs == 1 && -r $logs[0]->{'file'} &&
    $access{'noconfig'} && !$access{'add'} && !$access{'global'}) {
	# User can only edit/view one log file ..
	local $l = $logs[0];
	if ($access{'view'}) {
		&redirect("view_log.cgi/".&urlize(&urlize($l->{'file'})).
			  "/index.html");
		}
	else {
		&redirect("edit_log.cgi?file=".&urlize($l->{'file'}).
                	  "&type=$l->{'type'}&custom=$l->{'custom'}");
		}
	exit;
	}

&main_header();
if (@logs) {
	print "<a href='edit_log.cgi?new=1'>$text{'index_add'}</a>\n"
		if (!$access{'view'} && $access{'add'});
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_path'}</b></td> ",
	      "<td><b>$text{'index_type'}</b></td> ",
	      "<td><b>$text{'index_size'}</b></td> ",
	      "<td><b>$text{'index_sched'}</b></td> ",
	      "<td><b>$text{'index_rep'}</b></td> </tr>\n";
	foreach $l (@logs) {
		next if ($done{$l->{'file'}}++);
		local @files = &all_log_files($l->{'file'});
		next if (!@files);
		local $lconf = &get_log_config($l->{'file'});
		print "<tr $cb>\n";
		local $short = $l->{'file'};
		if (length($short) > 40) {
			$short = "...".substr($short, -40);
			}
		if ($access{'view'}) {
			print "<td>$short</td>\n";
			}
		else {
			print "<td><a href='edit_log.cgi?file=",
			      &urlize($l->{'file'}),
			      "&type=$l->{'type'}&custom=$l->{'custom'}'>",
			      "$short</a></td>\n";
			}
		print "<td>",&text('index_type'.$l->{'type'}),"</td>\n";
		local ($size, $latest);
		foreach $f (@files) {
			local @st = stat($f);
			$size += $st[7];
			$latest = $st[9] if ($st[9] > $latest);
			}
		$latest = $latest ? localtime($latest) : "<br>";
		print "<td>",$size > 10*1024*1024 ? int($size/1024/1024)." MB" :
			     $size > 10*1024 ? int($size/1024)." KB" :
			     $size ? "$size B" : $text{'index_empty'},"</td>\n";
		print "<td>",$lconf->{'sched'} ?
			&text('index_when', &cron::when_text($lconf)) :
			$text{'no'},"</td>\n";
		if ($lconf->{'dir'} && -r "$lconf->{'dir'}/index.html") {
			print "<td><a href='view_log.cgi/",
			      &urlize(&urlize($l->{'file'})),
			      "/index.html'>$text{'index_view'}</a></td>\n";
			}
		else {
			print "<td><br></td>\n";
			}
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<p><b>$text{'index_nologs'}</b><p>\n";
	}
print "<a href='edit_log.cgi?new=1'>$text{'index_add'}</a><br>\n"
	if (!$access{'view'} && $access{'add'});

if (!$access{'view'} && $access{'global'}) {
	print "<hr>\n";
	print "<form action=edit_global.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value='$text{'index_global'}'></td>\n";
	print "<td>$text{'index_globaldesc'}</td>\n";
	print "</tr></table></form>\n";
	}

&ui_print_footer("/", $text{'index'});

sub main_header
{
&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("webalizer", "man", "doc", "google"),
	undef, undef, &text('index_version', $webalizer_version));
}

