/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_PORT_H
#define _WF_PORT_H

#include <inttypes.h>

#include "wfport_base.h"

/**
 * port
 */
class wf_port : public wf_port_base {
 public:
  wf_port();
  wf_port(uint16_t port);
  wf_port(const string& servname, const string& proto);
  virtual ~wf_port() {}
  // wf_port(const wf_port&) {} implicit copy constructor
  virtual wf_port_base* VClone() const;

  bool set(uint16_t port);
  bool set(const string& servname, const string& proto);
  /* for tcp, or udp if tcp not found */
  bool set(const string& servname);
  uint16_t get() const;

  string tostr(const string& proto) const;
  
  virtual enum metaport_elem_type gettype() const { return WF_METAPORT_PORT; }
  virtual ostream& print(ostream& os) const;
  virtual ostream& output_xml(ostream& os, unsigned int indent_level = 0) const;

  friend ostream& operator<<(ostream& os, const wf_port& port);

 private:
  uint16_t _port;
};

bool wf_port_check(uint16_t port);
bool wf_port_check(uint16_t port, const string& proto);
bool wf_port_check(const string& servname, const string& proto);
string wf_port_toservice(uint16_t port, const string& proto);

inline wf_port_base*
wf_port::VClone() const {
  return new wf_port(*this);
}

#endif
