/* back_geom.h */

/*
Copyright (c) 1999 Alban Hertroys
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/*
   Constants that define the geometry of the dock-app window
*/

#include "xpm/back.xpm"

#ifndef WMAKER
#include "xpm/tile.xpm"
#endif

#define TLEFT    0      /* left offset for drawing in window */
#define TTOP     0      /* top  offset for drawing in window */
#define TWIDTH   64     /* width of window */
#define THEIGHT  64     /* height of window */

#define W_WID 23        /* width of weekday-text */
#define W_HEI 7         /* height of weekday-text */

#define D_WID  16       /* width  of a day-number pixmap */
#define D_HEI  18       /* height of a day-number pixmap */
#define D_ONE  9			/* width of day-number 1 pixmap */

#define D_OFF1 0        /* Three offsets for placing the numbers of */
#define D_OFF2 3        /* the day. Those differ because the "1" is */
#define D_OFF3 6        /* smaller than the other numbers. Now things */
                        /* are centered properly if there's a "1" in */
                        /* the day. */

#define M_WID  23       /* width  of month-text */
#define M_HEI  7        /* height of month-text */

/* origins in master pixmap */
#define TW_LFT 100      /* offset of weekday left   position in master pixmap */
#define TD_TOP 64       /* offset of day top        position in master pixmap */
#define TM_LFT 160      /* offset of month left     position in master pixmap */

/* placement */
#define PW_LFT  20      /* left offset of weekday-text in window */
#define PW_TOP  17      /* top  offset of weekday-text in window */

#define PD_LFT1 16      /* hor. placement of left number of the day */
#define PD_LFT2 24      /* hor. placement if there's only one number of the day */
#define PD_LFT3 32      /* hor. placement of right number of the day */
#define PD_TOP  25      /* ver. placement of numbers of the day */

#define PM_LFT  20      /* hor. placement of month-text */
#define PM_TOP  44      /* ver. placement of month-text */

