
#include <stdarg.h>
#include <syslog.h>
#include <stdio.h>
#include "wmnetmon.h"
#include "logger.h"

int wheretolog;
FILE *loghandler;
char *logfile;

int init_log(int where,char *file)
{
	wheretolog=where;
	if (!where) return 1;
	if (where == LOG_USES_SYSLOG) {
		fprintf(stderr,"Starting to syslog\n");
		openlog("wmNetMon", LOG_PID, SYSLOG_FACILITY );	
	} else {
		loghandler=fopen(file,"a");
		if (!loghandler) {
			fprintf(stderr,"Unable to open log file \"%s\" - ", file);
			perror("open");
			return 0;
		}
	}
	return 1;
}

int do_log(char *format, ...)
{
	char logline[256];
	va_list args;
	va_start(args, format);
	switch(wheretolog) {
		case LOG_USES_SYSLOG:
			vsnprintf(logline,255, format,args);
			syslog(SYSLOG_LEVEL, logline);	
			break;
		case LOG_USES_LOGFILE:
			if (loghandler) vfprintf(loghandler, format,args);
	}
	return 0;	
}
