// $Id: Application.cpp,v 1.23 2002/10/14 05:14:41 mrq Exp $
#include <fstream>
#include <map>

#include <Ark/ArkDataClass.h>
#include <Ark/ArkConfig.h>

#include <Ark/ArkRenderer.h>
#include <Ark/ArkSystem.h>
#include <Ark/ArkCollision.h>
#include <Modules/Renderer/GLRenderer.h>

#include "Application.h"
#include "HeightOps.h"
#include "Tool.h"
#include "CommandStack.h"

static void LoadClassList(const std::string&, Ark::Config*, Ark::ClassList*);


//=============================================================================
// Application Singleton

Application *g_Application = 0;

Application* 
Application::GetApplication()
{
   assert (g_Application != 0);
   return g_Application;
}

//=============================================================================

Application::Application (UI *ui) : 
   m_UI (ui)
{
   g_Application = this;
   m_View = new TerrainView();

   Ark::String elib = Ark::Sys()->Cfg()->GetStr
      ("server::EntityLib",
       "{game}/scripts/entities.lib");
   
   Ark::Config cfg;
   cfg.Load (elib);
   
   m_Classes = new Ark::ClassList();
   LoadClassList("Entity", &cfg, m_Classes);
}

Application::~Application ()
{
  delete m_Classes;
  delete m_View;
}

//=============================================================================


//=============================================================================

void 
Application::SetView(ViewWidget* view)
{ 
   m_View->SetView(view); 

   ToolHelper::SetView (view);
   WorldHelper::SetView (view);
   
   if (GetWorld())
   {
      m_View->Center();
      m_View->Update();
   }
}



static void LoadClassList(const std::string& name, 
    Ark::Config *cfg,
    Ark::ClassList *classlist)
{
  std::string filename;
  Ark::String fname;

  filename = name + "::ClassDef";
  fname = filename.c_str();
  Ark::String datadef = cfg->GetStr(fname, "");
  if (datadef != "")
  {
    classlist->Load(datadef);
  }

  filename = name + "::Templates";
  fname = filename.c_str();
  Ark::String templates = cfg->GetStr(fname, "");
  if (templates != "")
  {
    classlist->LoadTemplates(templates);   
  }

}
