// $Id: CallbacksEntity.cpp,v 1.4 2002/12/26 21:17:35 mrq Exp $
#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "../Application.h"
#include "ClassSelector.h"
#include "ModelSelector.h"
#include "GLView.h"

void EntityEditor_UpdateAll (GtkWidget *widget);

/////////////////////////////////////////////////////////////////////////
void widget_setResult (GtkWidget *widget, int val)
{
   GtkWidget *parent;
   
   for (;;)
   {
      if (GTK_IS_MENU (widget))
	 parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
	 parent = widget->parent;
      if (parent == NULL)
	 break;
      widget = parent;
   }
   
   int *res = (int*) gtk_object_get_data (GTK_OBJECT(widget), "result");
   
   if (res != NULL)
      *res = val;
}

//////////////////////////////////////////////////////////////////////////

Entity *getEntity (GtkWidget *widget)
{
   GtkWidget *root = lookup_widget (widget, "EntityEditorWindow");
   return (Entity*) gtk_object_get_data (GTK_OBJECT(root), "entity");
}

#define ENTITY(widg) \
	Entity *entity = getEntity(GTK_WIDGET(widg)); \
	if (entity == NULL) \
		return

void setEntityFlag (GtkToggleButton *togglebutton,
		    const Ark::String &name)
{
   ENTITY (togglebutton);
   if (gtk_toggle_button_get_active (togglebutton))
      entity->SetEntry (name, true);
   else
      entity->SetEntry (name, false);
}

void EntityEditor_setClass (GtkWidget *widget,
			     Ark::ClassDef *def)
{
   ENTITY (widget);
   
   entity->SetClass(def);
   GtkWidget *classtext = lookup_widget (widget, "ECPClassText");
   
   gtk_entry_set_text (GTK_ENTRY(classtext), def->m_Name.c_str());

   EntityEditor_UpdateAll(widget);
}

void EntityEditor_setTemplate (GtkWidget *widget,
				const Ark::String &ntemplate)
{
   ENTITY (widget);
 
   GtkWidget *tmpltext = lookup_widget (widget, "ECPTemplateText");  
   gtk_entry_set_text (GTK_ENTRY(tmpltext), ntemplate.c_str());
}

void EntityEditor_setModel (GtkWidget *widget,
			     const Ark::String &model)
{
   ENTITY (widget);
   
   GtkWidget *mdltext = lookup_widget (widget, "ECPModelText");
   gtk_entry_set_text (GTK_ENTRY(mdltext), model.c_str());

   entity->SetEntry ("model", model);

   EntityEditor_UpdateAll(widget);
}

void EntityEditor_UpdateAll (GtkWidget *widget)
{
   ENTITY (widget);

   GtkWidget *twidget = lookup_widget (widget, "ECPModelText");   
   gtk_entry_set_text (GTK_ENTRY(twidget),
		       entity->GetEntry("model")->ToString().c_str());

   twidget = lookup_widget (widget, "ECPClassText");   
   gtk_entry_set_text (GTK_ENTRY(twidget),
		       entity->GetEntry("class")->ToString().c_str());

   twidget = lookup_widget (widget, "ECPNameText");   
   gtk_entry_set_text (GTK_ENTRY(twidget),
		       entity->GetEntry("name")->ToString().c_str());

   twidget = lookup_widget (widget, "ECPShortNameText");
   gtk_entry_set_text (GTK_ENTRY(twidget),
		       entity->GetEntry("shortname")->ToString().c_str());


   twidget = lookup_widget (widget, "ECPAIDriven");
   gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(twidget),
				 entity->GetEntry("aidriven")->d_integer);

   twidget = lookup_widget (widget, "ECPVisible");
   gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(twidget),
				 entity->GetEntry("visible")->d_integer);

   twidget = lookup_widget (widget, "ECPCollision");
   gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(twidget),
				 entity->GetEntry("collider")->d_integer);

   twidget = lookup_widget (widget, "ECPGravity");
   gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(twidget),
				 entity->GetEntry("gravity")->d_integer);

   twidget = lookup_widget (widget, "ECPPathfinding");
   gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(twidget),
				 entity->GetEntry("pathfinder")->d_integer);

   twidget = lookup_widget (widget, "ECPStatic");
   gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(twidget),
				 entity->GetEntry("static")->d_integer);

//   widget = lookup_widget (widget, "ECPTemplateText");   
//   gtk_entry_set_text (GTK_ENTRY(widget),
//		       entity->GetEntry("template")->ToString().c_str());

}


/////////////////////////////////////////////////////////////////////

gboolean
on_EntityEditorWindow_delete_event     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  return FALSE;
}

void
on_EntityPropsClassBrowse_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
   Ark::ClassDef *def = g_EntityClasses.SelectClass ();
   
   if (def != NULL)
      EntityEditor_setClass (GTK_WIDGET(button), def);
}

void
on_EntityPropsTemplateBrowse_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
   ENTITY(button);
   
   Ark::String tmpl = g_EntityClasses.SelectTemplate (entity->GetClass());
   
   if (tmpl != "")
   {
      Ark::String classname = *g_EntityClasses.GetTemplate(tmpl)["class"].
	 d_str;
      EntityEditor_setTemplate (GTK_WIDGET(button), tmpl);
      entity->SetTemplate (classname,tmpl);
      EntityEditor_UpdateAll (GTK_WIDGET(button));
   }
}


void
on_EntityPropsName_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
   ENTITY(editable);
   Ark::String str = gtk_entry_get_text (GTK_ENTRY (editable));
   entity->SetEntry("name", str);
}

void
on_EntityPropsShortName_changed        (GtkEditable     *editable,
                                        gpointer         user_data)
{
   ENTITY(editable);
   Ark::String str = gtk_entry_get_text (GTK_ENTRY (editable));
   entity->SetEntry("shortname", str);
}

void
on_EntityPropsModelBrowse_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
   Ark::String name = g_ModelSelector.SelectModel ("");
   EntityEditor_setModel (GTK_WIDGET(button), name);
}


void
on_EntityPropsPickPosition_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
}


void
on_EntityPropsAIDriven_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   setEntityFlag (togglebutton, "aidriven");
}


void
on_EntityPropsVisible_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   setEntityFlag (togglebutton, "visible");
}

void
on_EntityPropsCollision_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
      setEntityFlag (togglebutton, "collider");
}


void
on_EntityPropsGravity_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   setEntityFlag (togglebutton, "gravity");
}


void
on_EntityPropsPathfinding_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   setEntityFlag (togglebutton, "pathfinder");
}


void
on_EntityPropsStatic_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
   setEntityFlag (togglebutton, "static");
}

void
on_EntityPropertiesList_selection_changed
                                        (GtkList         *list,
                                        gpointer         user_data)
{

}

void
on_EntityPropsOverride_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
}
