/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.tree.Builder;
import java.util.Enumeration;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMDriver
implements Locator,
XMLReader {
    private ContentHandler contentHandler = new DefaultHandler();
    private LexicalHandler lexicalHandler = null;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private AttributesImpl attlist = new AttributesImpl();
    private String[] parts = new String[3];
    private String[] elparts = new String[3];
    private Node root = null;
    static final String FEATURE = "http://xml.org/sax/features/";
    static final String HANDLER = "http://xml.org/sax/properties/";

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setLocale(Locale locale) throws SAXException {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setDocument(Document document) {
        this.root = document;
    }

    public void setStartNode(Node node) throws SAXException {
        if (!(node instanceof Document)) {
            throw new SAXException("DOM input must be an entire Document");
        }
        this.root = node;
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.parse();
    }

    public void parse(String string) throws SAXException {
        this.parse();
    }

    public void parse() throws SAXException {
        if (this.root == null) {
            throw new SAXException("DOMDriver: no start node defined");
        }
        if (this.contentHandler == null) {
            throw new SAXException("DOMDriver: no content handler defined");
        }
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
        this.walkNode(this.root);
        this.contentHandler.endDocument();
    }

    private void walkNode(Node node) throws SAXException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                switch (node2.getNodeType()) {
                    case 9: {
                        break;
                    }
                    case 1: {
                        String string;
                        String string2;
                        Object object;
                        Element element = (Element)node2;
                        this.nsSupport.pushContext();
                        this.attlist.clear();
                        NamedNodeMap namedNodeMap = element.getAttributes();
                        int n2 = 0;
                        while (n2 < namedNodeMap.getLength()) {
                            Attr attr = (Attr)namedNodeMap.item(n2);
                            object = attr.getName();
                            if (((String)object).equals("xmlns")) {
                                this.nsSupport.declarePrefix("", attr.getValue());
                                this.contentHandler.startPrefixMapping("", attr.getValue());
                            } else if (((String)object).startsWith("xmlns:")) {
                                this.nsSupport.declarePrefix(((String)object).substring(6), attr.getValue());
                                this.contentHandler.startPrefixMapping(((String)object).substring(6), attr.getValue());
                            }
                            ++n2;
                        }
                        int n3 = 0;
                        while (n3 < namedNodeMap.getLength()) {
                            object = (Attr)namedNodeMap.item(n3);
                            string2 = object.getName();
                            if (!string2.equals("xmlns") && !string2.startsWith("xmlns:")) {
                                this.parts = this.nsSupport.processName(string2, this.parts, true);
                                if (this.parts == null) {
                                    throw new SAXException("Undeclared namespace in " + string2);
                                }
                                this.attlist.addAttribute(this.parts[0], this.parts[1], this.parts[2], "CDATA", object.getValue());
                            }
                            ++n3;
                        }
                        this.elparts = this.nsSupport.processName(element.getTagName(), this.elparts, false);
                        if (this.elparts == null) {
                            throw new SAXException("Undeclared namespace in " + element.getTagName());
                        }
                        object = this.elparts[0];
                        string2 = this.elparts[1];
                        String string3 = this.elparts[2];
                        this.contentHandler.startElement((String)object, string2, string3, this.attlist);
                        this.walkNode(element);
                        this.contentHandler.endElement((String)object, string2, string3);
                        Enumeration enumeration = this.nsSupport.getDeclaredPrefixes();
                        while (enumeration.hasMoreElements()) {
                            string = (String)enumeration.nextElement();
                            this.contentHandler.endPrefixMapping(string);
                        }
                        this.nsSupport.popContext();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 7: {
                        this.contentHandler.processingInstruction(((ProcessingInstruction)node2).getTarget(), ((ProcessingInstruction)node2).getData());
                        break;
                    }
                    case 8: {
                        if (this.lexicalHandler == null) break;
                        String string = ((Comment)node2).getData();
                        this.lexicalHandler.comment(string.toCharArray(), 0, string.length());
                        break;
                    }
                    case 3: {
                        String string = ((CharacterData)node2).getData();
                        this.contentHandler.characters(string.toCharArray(), 0, string.length());
                        break;
                    }
                }
                ++n;
            }
        }
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/features/validation".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return true;
        }
        if ("http://xml.org/sax/features/string-interning".equals(string)) {
            return false;
        }
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            if (!(object instanceof LexicalHandler)) {
                throw new SAXNotSupportedException("Lexical Handler must be instance of org.xml.sax.ext.LexicalHandler");
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
        this.lexicalHandler = (LexicalHandler)object;
    }

    public static DocumentInfo convert(Document document) throws SAXException {
        Builder builder = new Builder();
        DOMDriver dOMDriver = new DOMDriver();
        dOMDriver.setContentHandler(builder);
        dOMDriver.setDocument(document);
        dOMDriver.parse();
        return builder.getCurrentDocument();
    }
}

