/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.axis;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.NameTest;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import org.xml.sax.SAXException;

public class AttributeEnumeration
implements NodeEnumeration {
    private ElementInfo element;
    private AttributeCollection attlist;
    private NameTest nodeName;
    private int index;
    private int length;

    public AttributeEnumeration(NodeInfo nodeInfo, int n, NameTest nameTest) throws SAXException {
        this.nodeName = nameTest;
        if (nodeInfo instanceof ElementInfo && (n == 2 || n == 0)) {
            this.element = (ElementInfo)nodeInfo;
            if (nameTest instanceof Name) {
                String string = this.element.getAttributeValue((Name)nameTest);
                this.index = 0;
                this.length = string == null ? 0 : 1;
            } else {
                this.attlist = this.element.getAttributeList();
                this.index = 0;
                this.length = this.attlist.getLength();
            }
        } else {
            this.index = 0;
            this.length = 0;
        }
    }

    public boolean hasMoreElements() throws SAXException {
        return this.index < this.length;
    }

    public NodeInfo nextElement() throws SAXException {
        if (this.nodeName instanceof Name) {
            ++this.index;
            return this.element.makeAttributeNode((Name)this.nodeName);
        }
        return this.element.makeAttributeNode(this.element.getAttributeList().getExpandedName(this.index++));
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isReverseSorted() {
        return false;
    }

    public boolean isPeer() {
        return true;
    }
}

