/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.KeyManager;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NodeInfo;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Key
extends Function {
    private DocumentInfo boundDocument = null;
    private Controller boundController = null;

    public String getName() {
        return "key";
    }

    public int getDataType() {
        return 4;
    }

    public int getIntrinsicDependencies() {
        int n = 0;
        if (this.boundDocument == null) {
            n |= 8;
        }
        if (this.boundController == null) {
            n |= 0x40;
        }
        return n;
    }

    protected Expression reduceIntrinsic(int n, Context context) throws SAXException {
        this.checkArgumentCount(2, 2);
        if ((n & 8) != 0) {
            if (this.boundController == null || this.boundDocument == null) {
                Key key = new Key();
                key.addArgument((Expression)this.arguments.elementAt(0));
                key.addArgument((Expression)this.arguments.elementAt(1));
                key.boundDocument = this.boundDocument == null ? context.getContextNode().getDocumentRoot() : this.boundDocument;
                key.boundController = this.boundController == null ? context.getController() : this.boundController;
                key.setStaticContext(this.getStaticContext());
                return key;
            }
            return this;
        }
        if ((n & 0x40) != 0) {
            if (this.boundController == null) {
                Key key = new Key();
                key.addArgument((Expression)this.arguments.elementAt(0));
                key.addArgument((Expression)this.arguments.elementAt(1));
                key.boundController = context.getController();
                key.setStaticContext(this.getStaticContext());
                return key;
            }
            return this;
        }
        return this;
    }

    public Function newInstance() throws SAXException {
        Key key = new Key();
        key.boundDocument = this.boundDocument;
        key.boundController = this.boundController;
        key.setStaticContext(this.getStaticContext());
        return key;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        DocumentInfo documentInfo;
        int n = this.checkArgumentCount(2, 2);
        Value value = (Value)vector.elementAt(0);
        Value value2 = (Value)vector.elementAt(1);
        Controller controller = this.boundController;
        if (controller == null) {
            controller = context.getController();
        }
        if ((documentInfo = this.boundDocument) == null) {
            documentInfo = context.getContextNode().getDocumentRoot();
        }
        String string = value.asString();
        String string2 = this.getStaticContext().makeName(string, false).getAbsoluteName();
        return this.findKey(controller, documentInfo, string2, value2);
    }

    private NodeSetValue findKey(Controller controller, DocumentInfo documentInfo, String string, Value value) throws SAXException {
        boolean bl;
        NodeSetValue nodeSetValue;
        KeyManager keyManager = controller.getKeyManager();
        Vector vector = new Vector();
        if (value instanceof NodeSetValue) {
            nodeSetValue = (NodeSetValue)value;
            bl = false;
            NodeEnumeration nodeEnumeration = nodeSetValue.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                Vector vector2 = keyManager.selectByKey(string, documentInfo, nodeEnumeration.nextElement().getValue(), controller);
                int n = 0;
                while (n < vector2.size()) {
                    vector.addElement(vector2.elementAt(n));
                    ++n;
                }
            }
        } else {
            vector = keyManager.selectByKey(string, documentInfo, value.asString(), controller);
            bl = true;
        }
        switch (vector.size()) {
            case 0: {
                return new EmptyNodeSet();
            }
            case 1: {
                return new SingletonNodeSet((NodeInfo)vector.elementAt(0));
            }
        }
        nodeSetValue = new NodeSetExtent(vector);
        nodeSetValue.setSorted(bl);
        return nodeSetValue;
    }
}

