/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.sql;

import com.icl.saxon.Context;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.style.StyleElement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.xml.sax.SAXException;

public class SQLConnect
extends StyleElement {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;

    public void prepareAttributes() throws SAXException {
        String string = this.attributeList.getValue("database");
        if (string == null) {
            this.reportAbsence("database");
        }
        this.database = AttributeValueTemplate.make(string, this);
        String string2 = this.attributeList.getValue("driver");
        if (string2 == null) {
            if (string.substring(0, 9).equals("jdbc:odbc")) {
                string2 = "sun.jdbc.odbc.JdbcOdbcDriver";
            } else {
                this.reportAbsence("driver");
            }
        }
        this.driver = AttributeValueTemplate.make(string2, this);
        String string3 = this.attributeList.getValue("user");
        this.user = string3 == null ? new StringValue("") : AttributeValueTemplate.make(string3, this);
        String string4 = this.attributeList.getValue("password");
        this.password = string4 == null ? new StringValue("") : AttributeValueTemplate.make(string4, this);
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws SAXException {
        Connection connection = null;
        Statement statement = null;
        String string = this.database.evaluateAsString(context);
        String string2 = this.driver.evaluateAsString(context);
        String string3 = this.user.evaluateAsString(context);
        String string4 = this.password.evaluateAsString(context);
        try {
            Class.forName(string2);
            connection = DriverManager.getConnection(string, string3, string4);
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            throw new SAXException("JDBC Connection Failure: " + exception.getMessage());
        }
        context.getController().setUserData(this.getPrincipalStyleSheet(), "sql:connection", connection);
        context.getController().setUserData(this.getPrincipalStyleSheet(), "sql:statement", statement);
    }
}

