/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; You may only use version 2 of the License,
	you have no option to use any other version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        from gnome theme-switcher capplet - (c) Jonathan Blandford <jrb@gnome.org>

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <X11/Xlib.h>

#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <gtk_common.h>

#define SUFFIX      "gtk-2.0"
#define KEY_SUFFIX  "gtk-2.0-key"

static void
theme_info_free(ThemeInfo *info)
{
    g_free(info->path);
    g_free(info->name);
    g_free(info);
}

static ThemeInfo *
find_theme_info_by_name(const gchar *theme_name, GList *theme_list)
{
    GList *list;

    for (list = theme_list; list; list = list->next) {
        ThemeInfo *info = list->data;

        if (!strcmp(info->name, theme_name))
            return(info);
    }

    return(NULL);
}

static GList *
update_theme_dir(const gchar *theme_dir, GList *theme_list)
{
    ThemeInfo *info;
    gchar *theme_name;
    gboolean has_gtk;
    gboolean has_keybinding;
    gchar *tmp;

    tmp = g_build_filename(theme_dir, SUFFIX, NULL);
    has_gtk = g_file_test(tmp, G_FILE_TEST_IS_DIR);
    g_free(tmp);

    tmp = g_build_filename(theme_dir, KEY_SUFFIX, NULL);
    has_keybinding = g_file_test(tmp, G_FILE_TEST_IS_DIR);
    g_free(tmp);

    theme_name = g_strdup(strrchr(theme_dir, G_DIR_SEPARATOR) + 1);
    info = find_theme_info_by_name(theme_name, theme_list);

    if (info) {
        if(!has_gtk && !has_keybinding) {
            theme_list = g_list_remove(theme_list, info);
            theme_info_free(info);
        }
        else if ((info->has_keybinding != has_keybinding) ||
                (info->has_gtk != has_gtk)) {
            info->has_keybinding = has_keybinding;
            info->has_gtk = has_gtk;
        }
    }
    else {
        if (has_gtk || has_keybinding) {
            info = g_new0(ThemeInfo, 1);
            info->path = g_strdup(theme_dir);
            info->name = g_strdup(theme_name);
            info->has_gtk = has_gtk;
            info->has_keybinding = has_keybinding;

            theme_list = g_list_prepend(theme_list, info);
        }
    }

    g_free(theme_name);
    
    return(theme_list);
}

static GList *
themes_common_list_add_dir(const gchar *dirname, GList *theme_list)
{
#ifdef HAVE_OPENDIR
    struct dirent *de;
    gchar *tmp;
    DIR *dir;

    g_return_val_if_fail(dirname != NULL, theme_list);

    if ((dir = opendir(dirname)) != NULL) {
        while((de = readdir(dir))) {
            if (de->d_name[0] == '.')
                continue;

            tmp = g_build_filename(dirname, de->d_name, NULL);
            theme_list = update_theme_dir(tmp, theme_list);
            g_free(tmp);
        }

        closedir(dir);
    }
#endif

    return(theme_list);
}


GList *
theme_common_get_list(GList *theme_list)
{
    gchar *dir;

    dir = g_build_filename(g_get_home_dir(), ".themes", NULL);
    theme_list = themes_common_list_add_dir(dir, theme_list);
    g_free(dir);

    dir = g_build_filename(g_get_home_dir(), ".themes-gtk2.0", NULL);
    theme_list = themes_common_list_add_dir(dir, theme_list);
    g_free(dir);

    dir = gtk_rc_get_theme_dir();
    theme_list = themes_common_list_add_dir(dir, theme_list);
    g_free(dir);

    return(theme_list);
}

/* Icon theme dirs */

static gchar*
parserc (const gchar * filename)
{
    gchar buf[80];
    gchar *lvalue, *rvalue;
    gchar *name = NULL;
    FILE *fp;

    fp = fopen (filename, "r");
    if (!fp)
    {
        return NULL;
    }
    while (fgets (buf, sizeof (buf), fp))
    {
        lvalue = strtok (buf, "=");
        rvalue = strtok (NULL, "\n");
        if ((lvalue) && (rvalue))
        {
            if (!g_ascii_strcasecmp (lvalue, "Hidden"))
            {
                if (g_ascii_strcasecmp (rvalue, "true"))
                {
                    g_free(name);
                    return NULL;
                }
            }
            else if (!g_ascii_strcasecmp (lvalue, "Name"))
            {
                if (name) 
                {
                    g_free(name);
                }
                name = g_strdup(rvalue);
            }
        }

    }
    fclose (fp);
    return name;
}

static GList *
update_icon_theme_dir(const gchar *theme_dir, GList *theme_list)
{
    ThemeInfo *info;
    gchar *theme_name;
    gchar *tmp;

    tmp = g_build_filename(theme_dir, "index.theme", NULL);
    theme_name = parserc (tmp);
    
    if (!theme_name)
    {
        return(theme_list);
    }

    info = find_theme_info_by_name(theme_name, theme_list);
    if (!info) 
    {
        info = g_new0(ThemeInfo, 1);
        info->path = g_strdup(theme_dir);
        info->name = g_strdup(theme_name);
        info->has_gtk = FALSE;
        info->has_keybinding = FALSE;
        theme_list = g_list_prepend(theme_list, info);
    }
    g_free(theme_name);
    
    return(theme_list);
}

static GList *
icon_themes_list_add_dir(const gchar *dirname, GList *theme_list)
{
#ifdef HAVE_OPENDIR
    struct dirent *de;
    gchar *tmp;
    DIR *dir;

    g_return_val_if_fail(dirname != NULL, theme_list);

    if ((dir = opendir(dirname)) != NULL) {
        while((de = readdir(dir))) {
            if (de->d_name[0] == '.')
                continue;

            tmp = g_build_filename(dirname, de->d_name, NULL);
            theme_list = update_icon_theme_dir(tmp, theme_list);
            g_free(tmp);
        }

        closedir(dir);
    }
#endif

    return(theme_list);
}

GList *
icon_theme_common_get_list(GList *theme_list)
{
    gchar *dir;

    dir = g_build_filename(g_get_home_dir(), ".icons", NULL);
    theme_list = icon_themes_list_add_dir(dir, theme_list);
    g_free(dir);

    dir = g_build_filename(DATADIR, "icons", NULL);
    theme_list = icon_themes_list_add_dir(dir, theme_list);
    g_free(dir);

    return(theme_list);
}
