/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * preferences.c - load and save program settings in xml format
 */

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "preferences.h"
#include "types.h"
#include "utils.h"
#include "support.h"

preferencestype preferences;
extern gchar *xlogdir;
#define PREFERENCES_VERSION 4
gboolean newprefsfile = FALSE;

static void make_default_preferences (void)
{
	preferences.version = 0;
	preferences.x = 10;
	preferences.y = 30;
	preferences.width = 750;
	preferences.height = 540;
	preferences.latitude = 0.0;
	preferences.NS = 1;
	preferences.longitude = 0.0;
	preferences.EW = 1;
	preferences.units = 1;
	preferences.bands = g_strdup ("1.8,3.5,7,10,14,18,21,24,28");
	preferences.modes = g_strdup ("CW,USB,LSB,FM,PSK31,MFSK,MT63,SSTV");
	preferences.bandseditbox = 0;
	preferences.modeseditbox = 0;
	preferences.bandoptionmenu = 0;
	preferences.modeoptionmenu = 0;
	preferences.printall = 0;
	preferences.printsize = 0;
	preferences.printpoint = 0;
	preferences.printorientation = 0;
	preferences.printdestination = 0;
	preferences.hamlib = 0;
	preferences.radio = g_strdup ("Dummy");
	preferences.device = g_strdup ("/dev/ttyS1");
	preferences.rigconf = g_strdup ("?");
	preferences.round = 3;
	preferences.polltime = 0;
	preferences.clock = 0;
	preferences.themecolor = g_strdup ("blue");
	preferences.themefont = g_strdup ("Sans 10");
	preferences.logcolor = 1;
	preferences.autosave = 5;
	preferences.savedir = g_strdup_printf ("%s%s.%s",
		g_get_home_dir (), G_DIR_SEPARATOR_S, PACKAGE);
	preferences.backupdir = g_strdup_printf ("%s%s.%s",
		g_get_home_dir (), G_DIR_SEPARATOR_S, PACKAGE);
	preferences.saving = 1;
	preferences.backup = 1;
	preferences.logstoload = g_strdup ("*");
	preferences.locator = g_strdup ("AA00AA");
	preferences.freefield1 = g_strdup ("UNKNOWN");
	preferences.freefield2 = g_strdup ("UNKNOWN");
	preferences.callsign = g_strdup ("N0CALL");
	preferences.defaultmhz = g_strdup ("?");
	preferences.defaultmode = g_strdup ("?");
	preferences.defaulttxrst = g_strdup ("?");
	preferences.defaultrxrst = g_strdup ("?");
	preferences.defaultpower = g_strdup ("?");
	preferences.defaultfreefield1 = g_strdup ("?");
	preferences.defaultfreefield2 = g_strdup ("?");
	preferences.defaultremarks = g_strdup ("?");
	preferences.b4columns = g_strdup ("1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0");
	preferences.logcwidths = g_strdup ("50,100,50,50,100,50,50,50,50,50,50,50,100,100,100,100,100,200");
	preferences.typeaheadfind = 1;
	preferences.remoteadding = 1;
	preferences.viewtoolbar = 1;
	preferences.viewb4 = 0;
	preferences.b4x = 10;
	preferences.b4y = 30;
	preferences.b4width = 500;
	preferences.b4height = 300;
	preferences.saveasadif = 0;
	preferences.saveastsv = g_strdup ("1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0");
	preferences.handlebarpos = 300;
	preferences.cwf1 = g_strdup ("cq de % % test");
	preferences.cwf2 = g_strdup ("@ de %");
	preferences.cwf3 = g_strdup ("@ ++5nn--#");
	preferences.cwf4 = g_strdup ("tu 73");
	preferences.cwf5 = g_strdup ("@");
	preferences.cwf6 = g_strdup ("%");
	preferences.cwf7 = g_strdup ("@ sri qso b4 gl");
	preferences.cwf8 = g_strdup ("agn");
	preferences.cwf9 = g_strdup ("?");
	preferences.cwf10 = g_strdup ("qrz?");
	preferences.cwf11 = g_strdup ("pse k");
	preferences.cwf12 = g_strdup ("++++test---- % %");
	preferences.cwcq = g_strdup ("tu %");
	preferences.cwsp = g_strdup ("tu 5nn#");
	preferences.cwspeed = 24;
	preferences.fcc = 0;
}

void
parseloadpreferences (xmlDocPtr p, xmlNodePtr cur)
{
	xmlChar *key;
	cur = cur->xmlChildrenNode;
	while (cur != NULL)
	{
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"version")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.version = atoi (key);
			free (key);
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.x = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"y")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.y = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"width")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.width = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"height")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.height = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"latitude")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.latitude = atof (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"NS")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.NS = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"longitude")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.longitude = atof (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"EW")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.EW = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"units")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.units = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"bands")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.bands = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"modes")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.modes = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"modeseditbox")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.modeseditbox = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"bandseditbox")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.bandseditbox = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"bandoptionmenu")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.bandoptionmenu = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"modeoptionmenu")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.modeoptionmenu = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"printall")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.printall = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"printsize")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.printsize = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"printpoint")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.printpoint = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"printdestination")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.printdestination = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"printorientation")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.printorientation = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"hamlib")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.hamlib = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"radio")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.radio = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"device")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.device = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"rigconf")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.rigconf = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"round")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.round = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"polltime")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.polltime = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"clock")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.clock = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"themecolor")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.themecolor = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"themefont")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.themefont = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"logcolor")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.logcolor = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"autosave")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.autosave = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"savedir")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.savedir = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"saving")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.saving = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"logstoload")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.logstoload = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"locator")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.locator = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"freefield1")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.freefield1 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"freefield2")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.freefield2 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"callsign")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.callsign = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"defaultmhz")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.defaultmhz = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"defaultmode")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.defaultmode = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"defaulttxrst")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.defaulttxrst = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"defaultrxrst")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.defaultrxrst = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"defaultpower")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.defaultpower = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"defaultfreefield1")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.defaultfreefield1 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"defaultfreefield2")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.defaultfreefield2 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"defaultremarks")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.defaultremarks = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"b4columns")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.b4columns = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"logcwidths")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.logcwidths = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"typeaheadfind")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.typeaheadfind = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"remoteadding")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.remoteadding = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"viewtoolbar")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.viewtoolbar = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"viewb4")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.viewb4 = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"b4x")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.b4x = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"b4y")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.b4y = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"b4width")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.b4width = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"b4height")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.b4height = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"saveasadif")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.saveasadif = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"saveastsv")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.saveastsv = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"handlebarpos")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.handlebarpos = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf1")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf1 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf2")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf2 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf3")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf3 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf4")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf4 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf5")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf5 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf6")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf6 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf7")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf7 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf8")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf8 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf9")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf9 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf10")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf10 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf11")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf11 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwf12")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwf12 = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwcq")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwcq = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwsp")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwsp = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"cwspeed")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.cwspeed = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"backupdir")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.backupdir = g_strdup (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"backup")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.backup = atoi (key);
			free (key);
		}
		else if ((!xmlStrcmp(cur->name, (const xmlChar *)"fcc")))
		{
			key = xmlNodeListGetString (p, cur->xmlChildrenNode, 1);
			preferences.fcc = atoi (key);
			free (key);
		}
	cur = cur->next;
	}
	return;
}

void parsesavepreferences (xmlNodePtr cur)
{
	gchar *key;
	xmlNodePtr node;

	for (node = cur->children; node != NULL; node = node->next)
	{
		if (!strcmp (node->name, "version"))
		{
			key = g_strdup_printf ("%d", PREFERENCES_VERSION);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		if (!strcmp (node->name, "x"))
		{
			key = g_strdup_printf ("%d", preferences.x);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "y"))
		{
			key = g_strdup_printf ("%d", preferences.y);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "width"))
		{
			key = g_strdup_printf ("%d", preferences.width);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "height"))
		{
			key = g_strdup_printf ("%d", preferences.height);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "latitude"))
		{
			key = g_strdup_printf ("%3.2f", preferences.latitude);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "NS"))
		{
			key = g_strdup_printf ("%d", preferences.NS);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "longitude"))
		{
			key = g_strdup_printf ("%3.2f", preferences.longitude);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "EW"))
		{
			key = g_strdup_printf ("%d", preferences.EW);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "units"))
		{
			key = g_strdup_printf ("%d", preferences.units);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "bands"))
		{
			key = g_strdup (preferences.bands);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "modes"))
		{
			key = g_strdup (preferences.modes);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "modeseditbox"))
		{
			key = g_strdup_printf ("%d", preferences.modeseditbox);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "bandseditbox"))
		{
			key = g_strdup_printf ("%d", preferences.bandseditbox);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "modeoptionmenu"))
		{
			key = g_strdup_printf ("%d", preferences.modeoptionmenu);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "bandoptionmenu"))
		{
			key = g_strdup_printf ("%d", preferences.bandoptionmenu);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "printall"))
		{
			key = g_strdup_printf ("%d", preferences.printall);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "printsize"))
		{
			key = g_strdup_printf ("%d", preferences.printsize);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "printpoint"))
		{
			key = g_strdup_printf ("%d", preferences.printpoint);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "printorientation"))
		{
			key = g_strdup_printf ("%d", preferences.printorientation);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "printdestination"))
		{
			key = g_strdup_printf ("%d", preferences.printdestination);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "hamlib"))
		{
			key = g_strdup_printf ("%d", preferences.hamlib);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "radio"))
		{
			key = g_strdup (preferences.radio);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "device"))
		{
			key = g_strdup (preferences.device);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "rigconf"))
		{
			key = g_strdup (preferences.rigconf);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "round"))
		{
			key = g_strdup_printf ("%d", preferences.round);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "polltime"))
		{
			key = g_strdup_printf ("%d", preferences.polltime);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "clock"))
		{
			key = g_strdup_printf ("%d", preferences.clock);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "themecolor"))
		{
			key = g_strdup (preferences.themecolor);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "themefont"))
		{
			key = g_strdup (preferences.themefont);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "logcolor"))
		{
			key = g_strdup_printf ("%d", preferences.logcolor);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "autosave"))
		{
			key = g_strdup_printf ("%d", preferences.autosave);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "savedir"))
		{
			key = g_strdup (preferences.savedir);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "saving"))
		{
			key = g_strdup_printf ("%d", preferences.saving);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "logstoload"))
		{
			key = g_strdup (preferences.logstoload);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "locator"))
		{
			key = g_strdup (preferences.locator);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "freefield1"))
		{
			key = g_strdup (preferences.freefield1);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "freefield2"))
		{
			key = g_strdup (preferences.freefield2);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "callsign"))
		{
			key = g_strdup (preferences.callsign);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "defaultmhz"))
		{
			key = g_strdup (preferences.defaultmhz);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "defaultmode"))
		{
			key = g_strdup (preferences.defaultmode);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "defaulttxrst"))
		{
			key = g_strdup (preferences.defaulttxrst);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "defaultrxrst"))
		{
			key = g_strdup (preferences.defaultrxrst);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "defaultpower"))
		{
			key = g_strdup (preferences.defaultpower);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "defaultfreefield1"))
		{
			key = g_strdup (preferences.defaultfreefield1);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "defaultfreefield2"))
		{
			key = g_strdup (preferences.defaultfreefield2);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "defaultremarks"))
		{
			key = g_strdup (preferences.defaultremarks);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "b4columns"))
		{
			key = g_strdup (preferences.b4columns);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "logcwidths"))
		{
			key = g_strdup (preferences.logcwidths);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "typeaheadfind"))
		{
			key = g_strdup_printf ("%d", preferences.typeaheadfind);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "remoteadding"))
		{
			key = g_strdup_printf ("%d", preferences.remoteadding);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "viewtoolbar"))
		{
			key = g_strdup_printf ("%d", preferences.viewtoolbar);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "viewb4"))
		{
			key = g_strdup_printf ("%d", preferences.viewb4);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "b4x"))
		{
			key = g_strdup_printf ("%d", preferences.b4x);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "b4y"))
		{
			key = g_strdup_printf ("%d", preferences.b4y);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "b4width"))
		{
			key = g_strdup_printf ("%d", preferences.b4width);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "b4height"))
		{
			key = g_strdup_printf ("%d", preferences.b4height);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "saveasadif"))
		{
			key = g_strdup_printf ("%d", preferences.saveasadif);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "saveastsv"))
		{
			key = g_strdup_printf ("%s", preferences.saveastsv);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "handlebarpos"))
		{
			key = g_strdup_printf ("%d", preferences.handlebarpos);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf1"))
		{
			key = g_strdup_printf ("%s", preferences.cwf1);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf2"))
		{
			key = g_strdup_printf ("%s", preferences.cwf2);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf3"))
		{
			key = g_strdup_printf ("%s", preferences.cwf3);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf4"))
		{
			key = g_strdup_printf ("%s", preferences.cwf4);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf5"))
		{
			key = g_strdup_printf ("%s", preferences.cwf5);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf6"))
		{
			key = g_strdup_printf ("%s", preferences.cwf6);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf7"))
		{
			key = g_strdup_printf ("%s", preferences.cwf7);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf8"))
		{
			key = g_strdup_printf ("%s", preferences.cwf8);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf9"))
		{
			key = g_strdup_printf ("%s", preferences.cwf9);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf10"))
		{
			key = g_strdup_printf ("%s", preferences.cwf10);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf11"))
		{
			key = g_strdup_printf ("%s", preferences.cwf11);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwf12"))
		{
			key = g_strdup_printf ("%s", preferences.cwf12);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwcq"))
		{
			key = g_strdup_printf ("%s", preferences.cwcq);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwsp"))
		{
			key = g_strdup_printf ("%s", preferences.cwsp);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "cwspeed"))
		{
			key = g_strdup_printf ("%d", preferences.cwspeed);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "backupdir"))
		{
			key = g_strdup (preferences.backupdir);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "backup"))
		{
			key = g_strdup_printf ("%d", preferences.backup);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
		else if (!strcmp (node->name, "fcc"))
		{
			key = g_strdup_printf ("%d", preferences.fcc);
			xmlNodeSetContent (node, key);
			g_free (key);
		}
	}
}


static void
newsavepreferences (xmlNodePtr cur)
{
	gchar *key;

	make_default_preferences ();
	key = g_strdup_printf ("%d", PREFERENCES_VERSION);
	xmlNewTextChild (cur, NULL, "version", key);
	key = g_strdup_printf ("%d", preferences.x);
	xmlNewTextChild (cur, NULL, "x", key);
	key = g_strdup_printf ("%d", preferences.y);
	xmlNewTextChild (cur, NULL, "y", key);
	key = g_strdup_printf ("%d", preferences.width);
	xmlNewTextChild (cur, NULL, "width", key);
	key = g_strdup_printf ("%d", preferences.height);
	xmlNewTextChild (cur, NULL, "height", key);
	key = g_strdup_printf ("%3.2f", preferences.latitude);
	xmlNewTextChild (cur, NULL, "latitude", key);
	key = g_strdup_printf ("%d", preferences.NS);
	xmlNewTextChild (cur, NULL, "NS", key);
	key = g_strdup_printf ("%3.2f", preferences.longitude);
	xmlNewTextChild (cur, NULL, "longitude", key);
	key = g_strdup_printf ("%d", preferences.EW);
	xmlNewTextChild (cur, NULL, "EW", key);
	key = g_strdup_printf ("%d", preferences.units);
	xmlNewTextChild (cur, NULL, "units", key);
	key = g_strdup_printf ("%s", preferences.bands);
	xmlNewTextChild (cur, NULL, "bands", key);
	key = g_strdup_printf ("%s", preferences.modes);
	xmlNewTextChild (cur, NULL, "modes", key);
	key = g_strdup_printf ("%d", preferences.bandseditbox);
	xmlNewTextChild (cur, NULL, "bandseditbox", key);
	key = g_strdup_printf ("%d", preferences.modeseditbox);
	xmlNewTextChild (cur, NULL, "modeseditbox", key);
	key = g_strdup_printf ("%d", preferences.bandoptionmenu);
	xmlNewTextChild (cur, NULL, "bandoptionmenu", key);
	key = g_strdup_printf ("%d", preferences.modeoptionmenu);
	xmlNewTextChild (cur, NULL, "modeoptionmenu", key);
	key = g_strdup_printf ("%d", preferences.printall);
	xmlNewTextChild (cur, NULL, "printall", key);
	key = g_strdup_printf ("%d", preferences.printsize);
	xmlNewTextChild (cur, NULL, "printsize", key);
	key = g_strdup_printf ("%d", preferences.printpoint);
	xmlNewTextChild (cur, NULL, "printpoint", key);
	key = g_strdup_printf ("%d", preferences.printorientation);
	xmlNewTextChild (cur, NULL, "printorientation", key);
	key = g_strdup_printf ("%d", preferences.printdestination);
	xmlNewTextChild (cur, NULL, "printdestination", key);
	key = g_strdup_printf ("%d", preferences.hamlib);
	xmlNewTextChild (cur, NULL, "hamlib", key);
	key = g_strdup_printf ("%s", preferences.radio);
	xmlNewTextChild (cur, NULL, "radio", key);
	key = g_strdup_printf ("%s", preferences.device);
	xmlNewTextChild (cur, NULL, "device", key);
	key = g_strdup_printf ("%s", preferences.rigconf);
	xmlNewTextChild (cur, NULL, "rigconf", key);
	key = g_strdup_printf ("%d", preferences.round);
	xmlNewTextChild (cur, NULL, "round", key);
	key = g_strdup_printf ("%d", preferences.polltime);
	xmlNewTextChild (cur, NULL, "polltime", key);
	key = g_strdup_printf ("%d", preferences.clock);
	xmlNewTextChild (cur, NULL, "clock", key);
	key = g_strdup_printf ("%s", preferences.themecolor);
	xmlNewTextChild (cur, NULL, "themecolor", key);
	key = g_strdup_printf ("%s", preferences.themefont);
	xmlNewTextChild (cur, NULL, "themefont", key);
	key = g_strdup_printf ("%d", preferences.logcolor);
	xmlNewTextChild (cur, NULL, "logcolor", key);
	key = g_strdup_printf ("%d", preferences.autosave);
	xmlNewTextChild (cur, NULL, "autosave", key);
	key = g_strdup_printf ("%s", preferences.savedir);
	xmlNewTextChild (cur, NULL, "savedir", key);
	key = g_strdup_printf ("%d", preferences.saving);
	xmlNewTextChild (cur, NULL, "saving", key);
	key = g_strdup_printf ("%s", preferences.logstoload);
	xmlNewTextChild (cur, NULL, "logstoload", key);
	key = g_strdup_printf ("%s", preferences.locator);
	xmlNewTextChild (cur, NULL, "locator", key);
	key = g_strdup_printf ("%s", preferences.freefield1);
	xmlNewTextChild (cur, NULL, "freefield1", key);
	key = g_strdup_printf ("%s", preferences.freefield2);
	xmlNewTextChild (cur, NULL, "freefield2", key);
	key = g_strdup_printf ("%s", preferences.callsign);
	xmlNewTextChild (cur, NULL, "callsign", key);
	key = g_strdup_printf ("%s", preferences.defaultmhz);
	xmlNewTextChild (cur, NULL, "defaultmhz", key);
	key = g_strdup_printf ("%s", preferences.defaultmode);
	xmlNewTextChild (cur, NULL, "defaultmode", key);
	key = g_strdup_printf ("%s", preferences.defaulttxrst);
	xmlNewTextChild (cur, NULL, "defaulttxrst", key);
	key = g_strdup_printf ("%s", preferences.defaultrxrst);
	xmlNewTextChild (cur, NULL, "defaultrxrst", key);
	key = g_strdup_printf ("%s", preferences.defaultpower);
	xmlNewTextChild (cur, NULL, "defaultpower", key);
	key = g_strdup_printf ("%s", preferences.defaultfreefield1);
	xmlNewTextChild (cur, NULL, "defaultfreefield1", key);
	key = g_strdup_printf ("%s", preferences.defaultfreefield2);
	xmlNewTextChild (cur, NULL, "defaultfreefield2", key);
	key = g_strdup_printf ("%s", preferences.defaultremarks);
	xmlNewTextChild (cur, NULL, "defaultremarks", key);
	key = g_strdup_printf ("%s", preferences.b4columns);
	xmlNewTextChild (cur, NULL, "b4columns", key);
	key = g_strdup_printf ("%s", preferences.logcwidths);
	xmlNewTextChild (cur, NULL, "logcwidths", key);
	key = g_strdup_printf ("%d", preferences.typeaheadfind);
	xmlNewTextChild (cur, NULL, "typeaheadfind", key);
	key = g_strdup_printf ("%d", preferences.remoteadding);
	xmlNewTextChild (cur, NULL, "remoteadding", key);
	key = g_strdup_printf ("%d", preferences.viewtoolbar);
	xmlNewTextChild (cur, NULL, "viewtoolbar", key);
	key = g_strdup_printf ("%d", preferences.viewb4);
	xmlNewTextChild (cur, NULL, "viewb4", key);
	key = g_strdup_printf ("%d", preferences.b4x);
	xmlNewTextChild (cur, NULL, "b4x", key);
	key = g_strdup_printf ("%d", preferences.b4y);
	xmlNewTextChild (cur, NULL, "b4y", key);
	key = g_strdup_printf ("%d", preferences.b4width);
	xmlNewTextChild (cur, NULL, "b4width", key);
	key = g_strdup_printf ("%d", preferences.b4height);
	xmlNewTextChild (cur, NULL, "b4height", key);
	key = g_strdup_printf ("%d", preferences.saveasadif);
	xmlNewTextChild (cur, NULL, "saveasadif", key);
	key = g_strdup_printf ("%s", preferences.saveastsv);
	xmlNewTextChild (cur, NULL, "saveastsv", key);
	key = g_strdup_printf ("%d", preferences.handlebarpos);
	xmlNewTextChild (cur, NULL, "handlebarpos", key);
	key = g_strdup_printf ("%s", preferences.cwf1);
	xmlNewTextChild (cur, NULL, "cwf1", key);
	key = g_strdup_printf ("%s", preferences.cwf2);
	xmlNewTextChild (cur, NULL, "cwf2", key);
	key = g_strdup_printf ("%s", preferences.cwf3);
	xmlNewTextChild (cur, NULL, "cwf3", key);
	key = g_strdup_printf ("%s", preferences.cwf4);
	xmlNewTextChild (cur, NULL, "cwf4", key);
	key = g_strdup_printf ("%s", preferences.cwf5);
	xmlNewTextChild (cur, NULL, "cwf5", key);
	key = g_strdup_printf ("%s", preferences.cwf6);
	xmlNewTextChild (cur, NULL, "cwf6", key);
	key = g_strdup_printf ("%s", preferences.cwf7);
	xmlNewTextChild (cur, NULL, "cwf7", key);
	key = g_strdup_printf ("%s", preferences.cwf8);
	xmlNewTextChild (cur, NULL, "cwf8", key);
	key = g_strdup_printf ("%s", preferences.cwf9);
	xmlNewTextChild (cur, NULL, "cwf9", key);
	key = g_strdup_printf ("%s", preferences.cwf10);
	xmlNewTextChild (cur, NULL, "cwf10", key);
	key = g_strdup_printf ("%s", preferences.cwf11);
	xmlNewTextChild (cur, NULL, "cwf11", key);
	key = g_strdup_printf ("%s", preferences.cwf12);
	xmlNewTextChild (cur, NULL, "cwf12", key);
	key = g_strdup_printf ("%s", preferences.cwcq);
	xmlNewTextChild (cur, NULL, "cwcq", key);
	key = g_strdup_printf ("%s", preferences.cwsp);
	xmlNewTextChild (cur, NULL, "cwsp", key);
	key = g_strdup_printf ("%d", preferences.cwspeed);
	xmlNewTextChild (cur, NULL, "cwspeed", key);
	key = g_strdup_printf ("%s", preferences.backupdir);
	xmlNewTextChild (cur, NULL, "backupdir", key);
	key = g_strdup_printf ("%d", preferences.backup);
	xmlNewTextChild (cur, NULL, "backup", key);
	key = g_strdup_printf ("%d", preferences.fcc);
	xmlNewTextChild (cur, NULL, "fcc", key);
	g_free (key);
}

void
loadpreferences (void)
{
	gchar *preferencesfile;
	xmlDocPtr prefs;
	xmlNodePtr cur, node;


	make_default_preferences ();
	/* open preferences file */
	preferencesfile =
		g_strconcat (xlogdir, G_DIR_SEPARATOR_S, "preferences.xml", NULL);
	prefs = xmlParseFile (preferencesfile);

	if (prefs != NULL)
	{
		cur = xmlDocGetRootElement (prefs);
		if (cur == NULL) 
		{
				g_warning (_("empty preferences file"));
				xmlFreeDoc (prefs);
				return;
		}

		if (xmlStrcmp(cur->name, (const xmlChar *) "xlog"))
		{
			g_warning (_("document of the wrong type, root node is not xlog"));
			xmlFreeDoc (prefs);
			return;
		}

		cur = cur->xmlChildrenNode;
		while (cur != NULL) 
		{
			if ((!xmlStrcmp(cur->name, (const xmlChar *) "xlog_preferences")))
				/* read preferences file */
				parseloadpreferences (prefs, cur);
			cur = cur->next;
		}
		xmlFreeDoc (prefs);
	}
	else
	{ /* create a new preferences file with defaults */
		g_print (_("Creating a new preferences file...\n"));
		prefs = xmlNewDoc ("1.0");
		cur = xmlNewDocRawNode (prefs, NULL, "xlog", NULL);
		xmlDocSetRootElement (prefs, cur);
		node = xmlNewChild (cur, NULL, "xlog_preferences", NULL);
		newsavepreferences (node);
		xmlSaveFormatFile (preferencesfile, prefs, 1);
		xmlFreeDoc (prefs);
		newprefsfile = TRUE;
	}
	g_free (preferencesfile);
}

void
savepreferences (void)
{
	gchar *preferencesfile, *key;
	xmlDocPtr prefs;
	xmlNodePtr root, cur;

	/* open preferences file */
	preferencesfile =
		g_strconcat (xlogdir, G_DIR_SEPARATOR_S, "preferences.xml", NULL);
	prefs = xmlParseFile (preferencesfile);
	if (prefs == NULL )
	{
		g_warning (_("preferences not parsed successfully"));
		return;
	}
	root = xmlDocGetRootElement (prefs);
	if (root == NULL)
	{
		g_warning (_("empty preferences file"));
		xmlFreeDoc (prefs);
		return;
	}
	if (xmlStrcmp(root->name, (const xmlChar *) "xlog"))
	{
		g_warning (_("document of the wrong type, root node is not xlog"));
		xmlFreeDoc (prefs);
		return;
	}
	cur = root->xmlChildrenNode;
	while (cur != NULL)
	{
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"xlog_preferences")))
		{
			parsesavepreferences (cur);
			if (!newprefsfile && (preferences.version < 1))
			{	
		        /* introduced in xlog version 0.9.8 */
				key = g_strdup_printf ("%d", PREFERENCES_VERSION);
				xmlNewTextChild (cur, NULL, "version", key);
				key = g_strdup_printf ("%s", preferences.logcwidths);
				xmlNewTextChild (cur, NULL, "logcwidths", key);
				g_free (key);
			}
			if (!newprefsfile && (preferences.version < 2))
			{	
		        /* introduced in xlog version 0.9.10 */
				key = g_strdup_printf ("%d", preferences.saveasadif);
				xmlNewTextChild (cur, NULL, "saveasadif", key);
				g_free (key);
			}
			if (!newprefsfile && (preferences.version < 3))
			{	
		        /* introduced in xlog version 1.1 */
				key = g_strdup_printf ("%s", preferences.saveastsv);
				xmlNewTextChild (cur, NULL, "saveastsv", key);
				key = g_strdup_printf ("%d", preferences.handlebarpos);
				xmlNewTextChild (cur, NULL, "handlebarpos", key);
				g_free (key);
			}
			if (!newprefsfile && (preferences.version < 4))
			{	
		        /* introduced in xlog version 1.2 */
				key = g_strdup_printf ("%s", preferences.cwf1);
				xmlNewTextChild (cur, NULL, "cwf1", key);
				key = g_strdup_printf ("%s", preferences.cwf2);
				xmlNewTextChild (cur, NULL, "cwf2", key);
				key = g_strdup_printf ("%s", preferences.cwf3);
				xmlNewTextChild (cur, NULL, "cwf3", key);
				key = g_strdup_printf ("%s", preferences.cwf4);
				xmlNewTextChild (cur, NULL, "cwf4", key);
				key = g_strdup_printf ("%s", preferences.cwf5);
				xmlNewTextChild (cur, NULL, "cwf5", key);
				key = g_strdup_printf ("%s", preferences.cwf6);
				xmlNewTextChild (cur, NULL, "cwf6", key);
				key = g_strdup_printf ("%s", preferences.cwf7);
				xmlNewTextChild (cur, NULL, "cwf7", key);
				key = g_strdup_printf ("%s", preferences.cwf8);
				xmlNewTextChild (cur, NULL, "cwf8", key);
				key = g_strdup_printf ("%s", preferences.cwf9);
				xmlNewTextChild (cur, NULL, "cwf9", key);
				key = g_strdup_printf ("%s", preferences.cwf10);
				xmlNewTextChild (cur, NULL, "cwf10", key);
				key = g_strdup_printf ("%s", preferences.cwf11);
				xmlNewTextChild (cur, NULL, "cwf11", key);
				key = g_strdup_printf ("%s", preferences.cwf12);
				xmlNewTextChild (cur, NULL, "cwf12", key);
				key = g_strdup_printf ("%s", preferences.cwcq);
				xmlNewTextChild (cur, NULL, "cwcq", key);
				key = g_strdup_printf ("%s", preferences.cwsp);
				xmlNewTextChild (cur, NULL, "cwsp", key);
				key = g_strdup_printf ("%d", preferences.cwspeed);
				xmlNewTextChild (cur, NULL, "cwspeed", key);
				key = g_strdup_printf ("%s", preferences.backupdir);
				xmlNewTextChild (cur, NULL, "backupdir", key);
				key = g_strdup_printf ("%d", preferences.backup);
				xmlNewTextChild (cur, NULL, "backup", key);
				key = g_strdup_printf ("%d", preferences.fcc);
				xmlNewTextChild (cur, NULL, "fcc", key);
				g_free (key);
			}
		}
		cur = cur->next;
	}
	xmlSaveFormatFile (preferencesfile, prefs, 0);
	xmlFreeDoc (prefs);
	g_free (preferencesfile);
}
