##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
Plone Article core classes for images and attachments and layout models
"""

from AccessControl import ClassSecurityInfo
import string
import random
import os
from Products.CMFCore import CMFCorePermissions
from AccessControl import Permissions, getSecurityManager, ClassSecurityInfo, Unauthorized
from OFS import Folder, Image, ObjectManager
from Products.ZAttachmentAttribute import ZAttachmentAttribute
from global_symbols import *
from Products.CMFCore.utils import getToolByName


    
#                                                                           #
#                               IMAGES SUPPORT                              #
#                                                                           #
class ArticleImages(ObjectManager.ObjectManager):

    # Standard security settings
    security = ClassSecurityInfo()
    security.declareObjectProtected(CMFCorePermissions.View)            # $$$ Is this clever ? Isn't it better to make the object private ?
                                                                        # This method makes all class properties & methods protected by View by default
    # Init method
    security.declarePrivate('__init__')
    def __init__(self, ):
        """__init__(self, )"""
        self.images_ids = []            # Images ids list

    security.declareProtected(ArticleCore_editPermission, 'removeImage')
    def removeImage(self, index = 0, REQUEST = {}):
        """
        removeImage(self, index = 0, REQUEST = {})
        - remove the images from the list
        - index is the images index in the list
        """
        # Check lock status
        self.checkLockStatus()

        # Ensure the index is reachable
        if index >= len(self.images_ids):
            return
        
        # Shorten the list
        id = self.images_ids[index]
        del self.images_ids[index]
        self.images_ids = self.images_ids             # Ensure persistancy
        self.manage_delObjects(ids = [id],)

        # Reindex catalog
        self.reindexObject()


    security.declareProtected(ArticleCore_editPermission, 'removeImages')
    def removeImages(self, indexes = [], REQUEST = {}):
        """
        removeImages(self, indexes = [], REQUEST = {})
        - remove the attachment from the list
        - index is the attachment index in the list
        """
        # Check lock status
        self.checkLockStatus()

        # Sort indexes
        indexes.sort()
        indexes.reverse()

        # Remove each one (starting from the end)
        for idx in indexes:
            self.removeImage(idx)



    security.declareProtected(ArticleCore_editPermission, 'changeImage')
    def changeImage(self, index = 0, title = '', file = ''):
        """
        changeImage(self, index = 0, title = '', file = '') 
        - index is the images index in the list
        """
        # Check lock status
        self.checkLockStatus()

        # Ensure the index is reachable
        if index >= len(self.images_ids):
            return

        # Get image object
        img = getattr(self, self.images_ids[index])
        
        # If we have to change the file, manage it
        if file:
            img.manage_edit(title, '', filedata=file)
        else:
            # Change / update title
            img.manage_edit(title, '')

        # Reindex catalog
        self.reindexObject()

    security.declareProtected(ArticleCore_editPermission, 'changeImage')
    def changeImageTitle(self, index = 0, title = ''):
        """
        changeImageTitle(self, index = 0, title = '') 
        - index is the images index in the list
        """
        # Check lock status
        self.checkLockStatus()

        # Ensure the index is reachable
        if index >= len(self.images_ids):
            return

        # Get image object
        img = getattr(self, self.images_ids[index])
        img.manage_edit(title,'')

        # Reindex catalog
        self.reindexObject()

    security.declareProtected(ArticleCore_editPermission, 'appendImage')
    def appendImage(self, title = '', file = '', REQUEST = {}):
        """
        appendImage(self, title = '', file = '', REQUEST = {})
        - Append a new images file at the end of the list.
        """
        # Check lock status
        self.checkLockStatus()

        # Find a random identifier
        id = "Image%08d" % (int(random.random() * 100000))
        while id in self.images_ids:
            id = "Image%08d" % (int(random.random() * 100000))

        #OLD doesn't work under debian with windows filename
        #fixed liked in zaa
        #img = Image.Image(os.path.split(file.filename)[1], title, file, )
        
        # Create the image
        fn = file.filename
        fn = string.split(fn, '/')[-1]
        fn = string.split(fn, '\\')[-1]
        img = Image.Image(fn, title, file, )

        # Append it
        self._setObject(id, img)
        self.images_ids.append(id)
        self.images_ids = self.images_ids             # Ensure persistancy

        # associate with a cache if possible
        img_obj = getattr(self, id)
        cache = getattr(self, 'PloneArticleThumbRAMCache', None)
        Log(LOG_DEBUG, "cache", cache)
        if cache:
            img_obj.ZCacheable_setManagerId('PloneArticleThumbRAMCache')


    security.declareProtected(ArticleCore_editPermission, 'moveImageUp')
    def moveImageUp(self, index):
        """
        moveImageUp(self, index) 
        - Move an image up
        """
        # Check lock status
        self.checkLockStatus()

        if index == 0:
            return              # Ignore first image moving

        # Check index position
        if index >= len(self.images_ids):
            return

        # Swap images
        tmp = self.images_ids[index - 1]
        self.images_ids[index - 1] = self.images_ids[index]
        self.images_ids[index] = tmp

        # Ensure persistancy
        self.images_ids = self.images_ids


    security.declareProtected(ArticleCore_editPermission, 'moveImageDown')
    def moveImageDown(self, index):
        """
        moveImageDown(self, index)
        - Move an image down
        """
        # Check lock status
        self.checkLockStatus()

        # Check index position, ignoring last image moving
        if index >= (len(self.images_ids) - 1):
            return

        # Swap images
        tmp = self.images_ids[index + 1]
        self.images_ids[index + 1] = self.images_ids[index]
        self.images_ids[index] = tmp

        # Ensure persistancy
        self.images_ids = self.images_ids

    security.declareProtected(CMFCorePermissions.View, "listImageIds")
    def listImageIds(self,):
        """
        listImageIds(self,)
        - return all image ids from this object
        """
        return self.images_ids


    security.declareProtected(CMFCorePermissions.View, "listImages")
    def listImages(self, ):
        """
        listImages(self, ) 
        - return images as a list
        """
        imglist = []
        for img in self.listImageIds():
            imglist.append(getattr(self, img))
        return imglist

    
    security.declareProtected(CMFCorePermissions.View, 'getImage')
    def getImage(self, index, ):
        """
        getImage(self, index, )
        """
        return getattr(self, self.images_ids[index])

    security.declareProtected(CMFCorePermissions.View, 'getImageId')
    def getImageId(self, index):
        """
        getImageId(self, index) 
        - return the id of the image
        """
        return self.images_ids[index]

    
