/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.editor.ColourJFrame;
import org.emboss.jemboss.editor.Consensus;
import org.emboss.jemboss.editor.ConsensusOptions;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.IDTableJFrame;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.editor.MatrixJFrame;
import org.emboss.jemboss.editor.Paste;
import org.emboss.jemboss.editor.PatternJFrame;
import org.emboss.jemboss.editor.PrettyPlotJFrame;
import org.emboss.jemboss.editor.PrintAlignment;
import org.emboss.jemboss.editor.PrintAlignmentImage;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.editor.SequenceProperties;
import org.emboss.jemboss.editor.SequenceReader;
import org.emboss.jemboss.editor.SequenceSaver;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class AlignJFrame
extends JFrame {
    protected JScrollPane jspSequence;
    protected static GraphicSequenceCollection gsc;
    private static Matrix mat;
    private PrettyPlotJFrame ppj = null;
    protected static JTextField statusField;
    private File sequenceFile = null;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    protected JCheckBoxMenuItem residueColor;
    protected Hashtable currentColour;
    protected boolean useExitMenu = false;
    protected JMenuBar menuBar;
    PatternJFrame findPattern;
    JCheckBoxMenuItem drawColorBox;

    public AlignJFrame(Vector vseqs) {
        this();
        if (vseqs != null && vseqs.size() > 0) {
            this.openMethod(vseqs);
        }
    }

    public AlignJFrame(File seqFile) {
        this();
        SequenceReader sr = new SequenceReader(seqFile);
        this.sequenceFile = sr.getSequenceFile();
        this.openMethod(sr.getSequenceVector());
        this.setTitle("Jemboss Alignment Viewer    :: " + this.sequenceFile.getName());
    }

    public AlignJFrame(String seqString, String name) {
        this();
        SequenceReader sr = new SequenceReader(seqString);
        this.sequenceFile = null;
        this.openMethod(sr.getSequenceVector());
        this.setTitle("Jemboss Alignment Viewer    :: " + name);
    }

    public AlignJFrame() {
        this(false);
    }

    public AlignJFrame(boolean useExitMenu) {
        this(useExitMenu, new Matrix("resources/resources.jar", "EBLOSUM62"));
    }

    public AlignJFrame(boolean useExitMenu, Matrix mat_) {
        super("Jemboss Alignment Editor");
        this.useExitMenu = useExitMenu;
        final Dimension dScreen = this.getToolkit().getScreenSize();
        mat = mat_;
        this.jspSequence = new JScrollPane();
        this.jspSequence.getViewport().setBackground(Color.white);
        final JButton leftbutt = new JButton("Lock");
        this.jspSequence.setCorner("LOWER_LEFT_CORNER", leftbutt);
        leftbutt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (leftbutt.getText().equals("Lock")) {
                    gsc.setSequenceLock(true);
                    leftbutt.setText("Unlock");
                } else {
                    gsc.setSequenceLock(false);
                    leftbutt.setText("Lock");
                }
            }
        });
        JPanel mainPane = (JPanel)this.getContentPane();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        final JMenuItem calculateCons = new JMenuItem("Consensus");
        final JMenuItem calculatePlotCon = new JMenuItem("Consensus plot");
        JMenuItem openSequence = new JMenuItem("Open...");
        openSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SequenceReader sr = new SequenceReader();
                if (sr.isReading()) {
                    AlignJFrame.this.sequenceFile = sr.getSequenceFile();
                    AlignJFrame.this.openMethod(sr.getSequenceVector());
                    calculateCons.setText("Calculate consensus");
                    calculatePlotCon.setText("Calculate consensus plot");
                    AlignJFrame.this.setTitle("Jemboss Alignment Viewer    :: " + AlignJFrame.this.sequenceFile.getName());
                }
            }
        });
        fileMenu.add(openSequence);
        JMenuItem saveAsMenu = new JMenuItem("Save As...");
        saveAsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SequenceSaver(gsc.getSequenceCollection(), AlignJFrame.this.sequenceFile);
            }
        });
        fileMenu.add(saveAsMenu);
        JMenuItem saveConsMenu = new JMenuItem("Save Consensus");
        saveConsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector<Sequence> v = new Vector<Sequence>();
                v.add(gsc.getConsensusSequence());
                new SequenceSaver(v);
            }
        });
        fileMenu.add(saveConsMenu);
        JMenu printMenu = new JMenu("Print");
        fileMenu.add(printMenu);
        JMenuItem print = new JMenuItem("Print Postscript...");
        print.setToolTipText("Print using available printers in your computer\nor export alignment image to a postscript file (if you have  installed postscript printers)");
        print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PrintAlignment(gsc);
            }
        });
        printMenu.add(print);
        JMenuItem printImage = new JMenuItem("Print Image Files (png/jpeg)...");
        printImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage pai = new PrintAlignmentImage(gsc);
                pai.print();
            }
        });
        printMenu.add(printImage);
        JMenuItem printOneImage = new JMenuItem("Print to Single Image File...");
        printOneImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage pai = new PrintAlignmentImage(gsc);
                String fsave = pai.showOptions();
                if (fsave == null) {
                    return;
                }
                pai.print(fsave, 0.0, 0.0, 0.0, 0.0);
            }
        });
        printMenu.add(printOneImage);
        JMenu printPreviewMenu = new JMenu("Print Preview");
        fileMenu.add(printPreviewMenu);
        JMenuItem printPreview = new JMenuItem("Multiple Pages...");
        printPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage pai = new PrintAlignmentImage(gsc);
                pai.printPreview();
            }
        });
        printPreviewMenu.add(printPreview);
        JMenuItem printSinglePreview = new JMenuItem("Single Page...");
        printSinglePreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage pai = new PrintAlignmentImage(gsc);
                pai.showPrintPreviewOptions();
                pai.printSinglePagePreview();
            }
        });
        printPreviewMenu.add(printSinglePreview);
        fileMenu.add(new JSeparator());
        if (!useExitMenu) {
            JMenuItem close = new JMenuItem("Close");
            close.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlignJFrame.this.dispose();
                    AlignJFrame.this.findPattern.dispose();
                }
            });
            fileMenu.add(close);
        } else {
            JMenuItem fileMenuExit = new JMenuItem("Exit");
            fileMenuExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            fileMenu.add(fileMenuExit);
        }
        this.menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        this.menuBar.add(editMenu);
        JMenuItem insertAnn = new JMenuItem("Insert Annotation Sequence");
        editMenu.add(insertAnn);
        insertAnn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScrollPanel pane = new ScrollPanel(new BorderLayout());
                Box bacross = Box.createVerticalBox();
                JRadioButton openFile = new JRadioButton("Read from File");
                JRadioButton cut = new JRadioButton("Cut and Paste");
                ButtonGroup group = new ButtonGroup();
                group.add(openFile);
                group.add(cut);
                cut.setSelected(true);
                bacross.add(openFile);
                bacross.add(cut);
                pane.add((Component)bacross, "Center");
                int selectedValue = JOptionPane.showConfirmDialog(null, pane, "Cut and Paste/Read from File", 2, 3);
                if (selectedValue == 0) {
                    SequenceReader sr = null;
                    if (openFile.isSelected()) {
                        sr = new SequenceReader();
                    } else {
                        Paste pastePane = new Paste();
                        selectedValue = JOptionPane.showConfirmDialog(null, pastePane, "Cut and Paste", 2, 3);
                        if (selectedValue == 0) {
                            sr = new SequenceReader(pastePane.getSequence());
                        }
                    }
                    if (sr != null && sr.isReading()) {
                        AlignJFrame.this.sequenceFile = sr.getSequenceFile();
                        gsc.addAnnotationSequence(sr.getSequence(0));
                        Dimension dpane = gsc.getPanelSize();
                        gsc.setPreferredSize(dpane);
                        gsc.setNamePanelWidth(gsc.getNameWidth());
                        AlignJFrame.this.jspSequence.setViewportView(gsc);
                    }
                }
            }
        });
        JMenuItem trimMenu = new JMenuItem("Trim Sequences");
        editMenu.add(trimMenu);
        trimMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScrollPanel pane = new ScrollPanel(new BorderLayout());
                Box bacross = Box.createHorizontalBox();
                TextFieldInt start = new TextFieldInt();
                start.setValue(1);
                TextFieldInt end = new TextFieldInt();
                end.setValue(gsc.getMaxSeqLength());
                bacross.add(start);
                bacross.add(new JLabel(" start "));
                bacross.add(end);
                bacross.add(new JLabel(" end"));
                pane.add((Component)bacross, "Center");
                int selectedValue = JOptionPane.showConfirmDialog(null, pane, "Select Sequence Range to Use", 2, 3);
                if (selectedValue == 0) {
                    Vector vseq = gsc.getSequenceCollection();
                    Enumeration enumer = vseq.elements();
                    while (enumer.hasMoreElements()) {
                        Sequence s = (Sequence)enumer.nextElement();
                        s.trim(start.getValue(), end.getValue());
                    }
                    gsc.setMaxSeqLength();
                    gsc.repaint();
                }
            }
        });
        JMenuItem unlock = new JMenuItem("Unlock All Sequences");
        editMenu.add(unlock);
        unlock.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setSequenceLock(false);
            }
        });
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        JMenuItem findMenu = new JMenuItem("Find pattern");
        viewMenu.add(findMenu);
        final PatternJFrame patFrame = this.findPattern = new PatternJFrame();
        findMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Point pos = AlignJFrame.this.getLocationOnScreen();
                pos.y -= patFrame.getHeight();
                if ((double)(pos.y + patFrame.getHeight()) > dScreen.getHeight()) {
                    pos.x = (int)(dScreen.getWidth() - (double)patFrame.getHeight());
                }
                patFrame.setLocation(pos);
                patFrame.setGraphic(gsc);
                patFrame.setVisible(true);
                patFrame.setExtendedState(patFrame.getExtendedState() & 0xFFFFFFFE);
                patFrame.requestFocusInWindow();
                patFrame.toFront();
            }
        });
        viewMenu.add(new JSeparator());
        JMenuItem showMatrix = new JMenuItem("Matrix Display");
        viewMenu.add(showMatrix);
        final MatrixJFrame matFrame = new MatrixJFrame(mat, statusField, this);
        showMatrix.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                matFrame.setMatrix(mat);
                matFrame.setVisible(true);
                matFrame.toFront();
            }
        });
        JMenuItem showColour = new JMenuItem("Colour Display");
        viewMenu.add(showColour);
        final ColourJFrame colFrame = new ColourJFrame(this);
        showColour.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Point pos = AlignJFrame.this.getLocationOnScreen();
                pos.x += AlignJFrame.this.getWidth();
                if ((double)(pos.x + colFrame.getWidth()) > dScreen.getWidth()) {
                    pos.x = (int)(dScreen.getWidth() - (double)colFrame.getWidth());
                }
                colFrame.setLocation(pos);
                colFrame.setCurrentColour(AlignJFrame.this.currentColour);
                colFrame.setVisible(true);
                colFrame.toFront();
            }
        });
        viewMenu.add(new JSeparator());
        this.colourMenus(viewMenu);
        JMenuItem pretty = new JMenuItem("Colour Identical/Matches");
        viewMenu.add(pretty);
        viewMenu.add(new JSeparator());
        final JCheckBoxMenuItem drawBoxes = new JCheckBoxMenuItem("Draw boxes", false);
        drawBoxes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setDrawBoxes(drawBoxes.isSelected());
            }
        });
        viewMenu.add(drawBoxes);
        viewMenu.add(this.drawColorBox);
        pretty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AlignJFrame.this.ppj == null) {
                    AlignJFrame.this.ppj = new PrettyPlotJFrame(gsc);
                } else {
                    AlignJFrame.this.ppj.setGraphicSequenceCollection(gsc);
                }
                gsc.setMatrix(mat);
                AlignJFrame.this.ppj.setVisible(true);
            }
        });
        this.menuBar.add(viewMenu);
        JMenu calculateMenu = new JMenu("Calculate");
        this.menuBar.add(calculateMenu);
        final ConsensusOptions options = new ConsensusOptions(this.jspSequence);
        calculateCons.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                AlignJFrame.this.setCursor(AlignJFrame.this.cbusy);
                try {
                    gsc.deleteSequence("Consensus");
                    float wgt = AlignJFrame.getTotalWeight(gsc.getSequenceCollection());
                    float plu = 0.0f;
                    try {
                        plu = options.getPlurality();
                    }
                    catch (NumberFormatException nfe) {
                        plu = wgt / 2.0f;
                    }
                    float cas = 0.0f;
                    try {
                        cas = options.getCase();
                    }
                    catch (NumberFormatException nfe) {
                        cas = wgt / 2.0f;
                    }
                    Consensus conseq = new Consensus(mat, gsc.getSequenceCollection(), plu, cas, options.getIdentity());
                    int fontSize = gsc.getFontSize();
                    gsc.addSequence(conseq.getConsensusSequence(), true, 0, fontSize);
                    Dimension dpane = gsc.getPanelSize();
                    gsc.setPreferredSize(dpane);
                    gsc.setNamePanelWidth(gsc.getNameWidth());
                    AlignJFrame.this.jspSequence.setViewportView(gsc);
                    calculateCons.setText("Recalculate consensus");
                }
                finally {
                    AlignJFrame.this.setCursor(AlignJFrame.this.cdone);
                }
            }
        });
        calculateMenu.add(calculateCons);
        JMenuItem consOptions = new JMenuItem("Set consensus options...");
        consOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    float wgt = AlignJFrame.getTotalWeight(gsc.getSequenceCollection());
                    options.setCase(wgt / 2.0f);
                    options.setPlurality(wgt / 2.0f);
                    options.setGraphicSequenceCollection(gsc);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                options.setMatrix(mat);
                options.setVisible(true);
            }
        });
        calculateMenu.add(consOptions);
        calculateMenu.add(new JSeparator());
        JMenuItem calculateId = new JMenuItem("Identity table");
        calculateId.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IDTableJFrame idtab = new IDTableJFrame(gsc.getSequenceCollection());
                idtab.setVisible(true);
            }
        });
        calculateMenu.add(calculateId);
        calculateMenu.add(new JSeparator());
        calculatePlotCon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AlignJFrame.this.setCursor(AlignJFrame.this.cbusy);
                gsc.showConsensusPlot(mat, 2);
                AlignJFrame.this.setCursor(AlignJFrame.this.cdone);
                calculatePlotCon.setText("Recalculate Consensus plot");
            }
        });
        calculateMenu.add(calculatePlotCon);
        calculateMenu.add(new JSeparator());
        JMenuItem test = new JMenuItem("Sort by ID");
        calculateMenu.add(test);
        test.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.idSort();
                AlignJFrame.this.jspSequence.setViewportView(gsc);
            }
        });
        String[] sizes = new String[]{"10", "12", "14", "16", "18"};
        final JComboBox<String> fntSize = new JComboBox<String>(sizes);
        fntSize.setSelectedItem("12");
        this.menuBar.add(fntSize);
        fntSize.setEditable(true);
        Dimension dfont = new Dimension(50, 20);
        fntSize.setPreferredSize(dfont);
        fntSize.setMaximumSize(dfont);
        fntSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String fsize = (String)fntSize.getSelectedItem();
                if (gsc != null) {
                    gsc.setFontSizeForCollection(Integer.parseInt(fsize));
                }
            }
        });
        this.setJMenuBar(this.menuBar);
        JMenu helpMenu = new JMenu("Help");
        this.menuBar.add(helpMenu);
        JMenuItem aboutMenu = new JMenuItem("About");
        helpMenu.add(aboutMenu);
        aboutMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassLoader cl = this.getClass().getClassLoader();
                try {
                    URL inURL = cl.getResource("resources/readmeAlign.html");
                    new Browser(inURL, "resources/readmeAlign.html");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Jemboss Alignment Viewer Guide not found!", "Error", 0);
                }
            }
        });
        Dimension d = new Dimension(700, 300);
        this.jspSequence.setPreferredSize(d);
        JPanel seqNamePanel = new JPanel(new BorderLayout());
        seqNamePanel.add((Component)this.jspSequence, "Center");
        mainPane.add((Component)this.jspSequence, "Center");
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        statusField.setBorder(compound);
        statusField.setEditable(false);
        statusField.setText("Current matrix: " + mat.getCurrentMatrixName());
        mainPane.add((Component)statusField, "South");
        this.addWindowListener(new winExit());
        this.pack();
        this.setLocation((int)(dScreen.getWidth() - (double)this.getWidth()) / 3, (int)(dScreen.getHeight() - (double)this.getHeight()) / 3);
    }

    public static float getTotalWeight(Vector vseq) {
        float wgt = 0.0f;
        vseq = gsc.getSequenceCollection();
        Enumeration enumer = vseq.elements();
        while (enumer.hasMoreElements()) {
            Sequence s = (Sequence)enumer.nextElement();
            if (s.getName().equals("Consensus")) continue;
            wgt += s.getWeight();
        }
        return wgt;
    }

    public void setMatrix(Matrix mat) {
        AlignJFrame.mat = mat;
    }

    public void repaintSequences(Hashtable hash) {
        gsc.setColorScheme(hash);
        gsc.repaint();
    }

    protected void openMethod(Vector seqVector) {
        gsc = new GraphicSequenceCollection(seqVector, this.jspSequence, true, false, true, true, statusField);
        gsc.setColorScheme(SequenceProperties.residueColor);
        this.currentColour = (Hashtable)SequenceProperties.residueColor.clone();
        this.residueColor.setSelected(true);
        this.jspSequence.setViewportView(gsc);
        this.colourScheme("Residue colour");
    }

    protected void colourScheme(String colScheme) {
        String status = statusField.getText();
        int ncol = status.indexOf("Colour Scheme: ");
        if (ncol > -1) {
            statusField.setText(status.substring(0, ncol) + "Colour Scheme: " + colScheme);
        } else {
            statusField.setText(status + "              " + "Colour Scheme: " + colScheme);
        }
        this.drawColorBox.setSelected(true);
    }

    private void colourMenus(JMenu viewMenu) {
        final ButtonGroup group = new ButtonGroup();
        final JRadioButton invisibleb = new JRadioButton();
        group.add(invisibleb);
        this.drawColorBox = new JCheckBoxMenuItem("Colour boxes", true);
        this.drawColorBox.addItemListener(new ItemListener(){
            ButtonModel lastSelection;

            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                gsc.setDrawColor(selected);
                if (!selected) {
                    this.lastSelection = group.getSelection();
                    invisibleb.setSelected(true);
                } else if (invisibleb.isSelected()) {
                    this.lastSelection.setSelected(true);
                }
            }
        });
        JMenu propertyMenu = new JMenu("Colour by Property");
        viewMenu.add(propertyMenu);
        JCheckBoxMenuItem acidColor = new JCheckBoxMenuItem("Red=acidic, Blue=basic");
        propertyMenu.add(acidColor);
        group.add(acidColor);
        acidColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.acidColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.acidColor;
                AlignJFrame.this.colourScheme("Red=acidic, Blue=basic");
            }
        });
        JCheckBoxMenuItem polarColor = new JCheckBoxMenuItem("Red=polar");
        propertyMenu.add(polarColor);
        group.add(polarColor);
        polarColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.polarColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.polarColor;
                AlignJFrame.this.colourScheme("Red=polar");
            }
        });
        JCheckBoxMenuItem hydrophobicColor = new JCheckBoxMenuItem("Red=Hydrophobic");
        propertyMenu.add(hydrophobicColor);
        group.add(hydrophobicColor);
        hydrophobicColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.hydrophobicColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.hydrophobicColor;
                AlignJFrame.this.colourScheme("Red=Hydrophobic");
            }
        });
        JCheckBoxMenuItem aromaticColor = new JCheckBoxMenuItem("Red=Aromatic, Blue=Aliphatic");
        propertyMenu.add(aromaticColor);
        group.add(aromaticColor);
        aromaticColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.aromaticColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.aromaticColor;
                AlignJFrame.this.colourScheme("Red=Aromatic, Blue=Aliphatic");
            }
        });
        JCheckBoxMenuItem surfaceColor = new JCheckBoxMenuItem("Red=Surface, Blue=Buried");
        propertyMenu.add(surfaceColor);
        group.add(surfaceColor);
        surfaceColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.surfaceColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.surfaceColor;
                AlignJFrame.this.colourScheme("Red=Surface, Blue=Buried");
            }
        });
        JCheckBoxMenuItem chargeColor = new JCheckBoxMenuItem("Red=Positive, Blue=Negative");
        propertyMenu.add(chargeColor);
        group.add(chargeColor);
        chargeColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.chargeColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.chargeColor;
                AlignJFrame.this.colourScheme("Red=Positive, Blue=Negative");
            }
        });
        JCheckBoxMenuItem sizeColor = new JCheckBoxMenuItem("Red=Tiny, Green=Small, Blue=Large");
        propertyMenu.add(sizeColor);
        group.add(sizeColor);
        sizeColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.sizeColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.sizeColor;
                AlignJFrame.this.colourScheme("Red=Tiny, Green=Small, Blue=Large");
            }
        });
        JCheckBoxMenuItem taylor = new JCheckBoxMenuItem("Taylor Colour");
        viewMenu.add(taylor);
        group.add(taylor);
        taylor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.taylorColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.taylorColor;
                AlignJFrame.this.colourScheme("Taylor");
            }
        });
        this.residueColor = new JCheckBoxMenuItem("Residue Colour");
        viewMenu.add(this.residueColor);
        group.add(this.residueColor);
        this.residueColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.residueColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.residueColor;
                AlignJFrame.this.colourScheme("Residue");
            }
        });
        JCheckBoxMenuItem rasmolColor = new JCheckBoxMenuItem("Rasmol Colour");
        viewMenu.add(rasmolColor);
        group.add(rasmolColor);
        rasmolColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.rasmolColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.rasmolColor;
                AlignJFrame.this.colourScheme("Rasmol");
            }
        });
        JCheckBoxMenuItem nuc = new JCheckBoxMenuItem("Nucleotide Colour");
        viewMenu.add(nuc);
        group.add(nuc);
        nuc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gsc.setColorScheme(SequenceProperties.baseColor);
                AlignJFrame.this.jspSequence.setViewportView(gsc);
                AlignJFrame.this.currentColour = SequenceProperties.baseColor;
                AlignJFrame.this.colourScheme("Nucleotide");
            }
        });
        viewMenu.add(new JSeparator());
    }

    private static Color resolveColor(String[] args, int index) {
        if (args[index].equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (args[index].equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (args[index].equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (args[index].equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (args[index].equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (args[index].equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (args[index].equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (args[index].equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (args[index].equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (args[index].equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (args[index].equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (args[index].equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (args[index].equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (args[index].equalsIgnoreCase("black")) {
            return Color.black;
        }
        return null;
    }

    public static void main(String[] args) {
        AlignJFrame ajFrame = null;
        if (args.length > 0) {
            int i;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].indexOf("-help") <= -1) continue;
                System.out.println("\n                  Jemboss Alignment Editor\n\nDESCRIPTION\nThe Jemboss Alignment Editor can be used interactively to\nedit a sequence alignment (read in fasta or MSF format). It can\nalso be used from the command line to produce image files\nof the alignment.\n\nUSAGE\njava org/emboss/jemboss/editor/AlignJFrame file [options]\n\nfile       This is the multiple sequence alignment in\n           fasta or MSF format.\n\nOPTIONS\n-calc      Calculate consensus and display under the alignment.\n           The following 3 flags can be used to define values\n           used in the calculations.\n           -plu       (plurality) minimum positive match score\n                      value for there to be a consensus.\n           -numid     minimum number of identities for there to\n                      be a consensus.\n           -case      minimum positive match score for setting\n                      the consensus to upper-case.\n-color     Used to define a colour scheme, below is the list of\n           available colour schemes:\n           taylor\n           residue\n           rasmol\n           acid\n           polar\n           hydrophobic\n           aromatic\n           surface\n           charge\n           size\n           base\n\n       java org.emboss.jemboss.editor.AlignJFrame file -color size\n\n-font      Set the font size.\n-id        Display a percentage ID pair table.\n-noshow    Turns of the alignment display.\n-nres      Number of residues to each line is a print out.\n-pretty    EMBOSS prettyplot colour scheme. The -matrix flag option\n           can be used to define a scoring matrix for identifying\n           positive matches.\n           -noBox         switch off box drawing around identical and\n                          positive matches.\n           -minID         define the minimum number of identities. The\n                          default for this is the number of sequences\n                          in the file.\n           -match         define a threshold value for the number of\n                          positive matches, the default is half the\n                          total wgt.\n           -colID         define a lettering colour for the identities.\n           -colIDBack     define a background colour for identities.\n           -colMatch      define a lettering  colour for positive matches.\n           -colMatchBack  define a background colour for positive\n                           matches.\n           Available colour options:\n           red, blue, cyan, darkGray, gray , green, lightGray,\n           magenta , orange, pink, white, yellow, black\n-print     Print the alignment image. The following 2 flags can be\n           used along with the print flag\n           -prefix     prefix for image output file.\n           -onePage    fit the alignment to one page. This option must be\n                       be used with the -nres flag to define the residues\n                       per line.\n           -type       png or jpeg (default is jpeg).\n           -antialias  turn anti-aliasing on.\n           -landscape  Print as landscape (the default is portrait).\n           -margin     Define the left, right, top and bottom margin\n                       (in cm).\n       java org.emboss.jemboss.editor.AlignJFrame file -matrix EBLOSUM62 \\\n                -noshow -print -margin 0.5 0.5 0.5 0.5\n\n-matrix    To define a scoring matrix. Used with the -pretty and -calc\n           option.\n-list      List the available scoring matrix files.\n\nEXAMPLE\njava org.emboss.jemboss.editor.AlignJFrame file -matrix EBLOSUM80 \\\n                             -pretty -noshow -id -print -type png\n\njava org.emboss.jemboss.editor.AlignJFrame file -matrix EPAM250 \\\n                -pretty -colIDBack black -colID white -print \\\n                -margin 0.5 0.5 0.5 0.0 -noshow\n");
                System.exit(0);
            }
            File seqFile = new File(args[0]);
            if (seqFile.canRead()) {
                JembossParams jp = new JembossParams();
                String ed = jp.getEmbossData();
                Matrix m = new Matrix(ed, "EBLOSUM62");
                ajFrame = new AlignJFrame(true, m);
                SequenceReader sr = new SequenceReader(seqFile);
                sr.getSequenceFile();
                ajFrame.openMethod(sr.getSequenceVector());
                ajFrame.setTitle("Jemboss Alignment Viewer    :: " + seqFile.getName());
                gsc.setMatrix(mat);
            }
            String prefix = "output";
            String type = "jpeg";
            boolean show = true;
            boolean print = false;
            int nresiduesPerLine = 0;
            float wgt = AlignJFrame.getTotalWeight(gsc.getSequenceCollection());
            double lmargin = -0.5;
            double rmargin = -0.5;
            double tmargin = -0.5;
            double bmargin = -0.5;
            float plu = wgt / 2.0f;
            float cas = wgt / 2.0f;
            int ident = 0;
            int minID = gsc.getNumberSequences();
            float match = wgt / 2.0f;
            Color colID = Color.red;
            Color colMatch = Color.blue;
            Color colIDBack = Color.white;
            Color colMatchBack = Color.white;
            boolean prettyBox = true;
            boolean landscape = false;
            boolean onePage = false;
            boolean antialias = false;
            for (i = 0; i < args.length; ++i) {
                Color col;
                if (args[i].indexOf("-matrix") > -1) {
                    mat = new Matrix("resources/resources.jar", args[i + 1]);
                    gsc.setMatrix(mat);
                    statusField.setText("Current matrix: " + args[i + 1]);
                    continue;
                }
                if (args[i].indexOf("-plu") > -1) {
                    plu = Float.parseFloat(args[i + 1]);
                    continue;
                }
                if (args[i].indexOf("-match") > -1) {
                    match = Float.parseFloat(args[i + 1]);
                    continue;
                }
                if (args[i].indexOf("-case") > -1) {
                    cas = Float.parseFloat(args[i + 1]);
                    continue;
                }
                if (args[i].indexOf("-numid") > -1) {
                    ident = Integer.parseInt(args[i + 1]);
                    continue;
                }
                if (args[i].indexOf("-colIDBack") > -1) {
                    col = AlignJFrame.resolveColor(args, i + 1);
                    if (col == null) continue;
                    colIDBack = col;
                    continue;
                }
                if (args[i].indexOf("-colMatchBack") > -1) {
                    col = AlignJFrame.resolveColor(args, i + 1);
                    if (col == null) continue;
                    colMatchBack = col;
                    continue;
                }
                if (args[i].indexOf("-colMatch") > -1) {
                    col = AlignJFrame.resolveColor(args, i + 1);
                    if (col == null) continue;
                    colMatch = col;
                    continue;
                }
                if (args[i].indexOf("-colID") > -1) {
                    col = AlignJFrame.resolveColor(args, i + 1);
                    if (col == null) continue;
                    colID = col;
                    continue;
                }
                if (args[i].indexOf("-minID") > -1) {
                    minID = Integer.parseInt(args[i + 1]);
                    continue;
                }
                if (args[i].indexOf("-noBox") > -1) {
                    prettyBox = false;
                    continue;
                }
                if (args[i].indexOf("-font") > -1) {
                    gsc.setFontSizeForCollection(Integer.parseInt(args[i + 1]));
                    continue;
                }
                if (args[i].indexOf("-landscape") > -1) {
                    landscape = true;
                    continue;
                }
                if (args[i].indexOf("-margin") > -1) {
                    lmargin = Double.parseDouble(args[i + 1]);
                    rmargin = Double.parseDouble(args[i + 2]);
                    tmargin = Double.parseDouble(args[i + 3]);
                    bmargin = Double.parseDouble(args[i + 4]);
                    continue;
                }
                if (args[i].indexOf("-onePage") > -1) {
                    onePage = true;
                    continue;
                }
                if (args[i].indexOf("-antialias") <= -1) continue;
                antialias = true;
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i].indexOf("-color") > -1) {
                    if (args[++i].startsWith("taylor")) {
                        gsc.setColorScheme(SequenceProperties.taylorColor);
                        continue;
                    }
                    if (args[i].startsWith("residue")) {
                        gsc.setColorScheme(SequenceProperties.residueColor);
                        continue;
                    }
                    if (args[i].startsWith("rasmol")) {
                        gsc.setColorScheme(SequenceProperties.rasmolColor);
                        continue;
                    }
                    if (args[i].startsWith("acid")) {
                        gsc.setColorScheme(SequenceProperties.acidColor);
                        continue;
                    }
                    if (args[i].startsWith("polar")) {
                        gsc.setColorScheme(SequenceProperties.polarColor);
                        continue;
                    }
                    if (args[i].startsWith("hydro")) {
                        gsc.setColorScheme(SequenceProperties.hydrophobicColor);
                        continue;
                    }
                    if (args[i].startsWith("aromatic")) {
                        gsc.setColorScheme(SequenceProperties.aromaticColor);
                        continue;
                    }
                    if (args[i].startsWith("surface")) {
                        gsc.setColorScheme(SequenceProperties.surfaceColor);
                        continue;
                    }
                    if (args[i].startsWith("charge")) {
                        gsc.setColorScheme(SequenceProperties.chargeColor);
                        continue;
                    }
                    if (args[i].startsWith("size")) {
                        gsc.setColorScheme(SequenceProperties.sizeColor);
                        continue;
                    }
                    if (!args[i].startsWith("base")) continue;
                    gsc.setColorScheme(SequenceProperties.baseColor);
                    continue;
                }
                if (args[i].indexOf("-calc") > -1) {
                    Consensus conseq = new Consensus(mat, gsc.getSequenceCollection(), plu, cas, ident);
                    int fontSize = gsc.getFontSize();
                    gsc.addSequence(conseq.getConsensusSequence(), true, 5, fontSize);
                    Dimension dpane = gsc.getPanelSize();
                    gsc.setPreferredSize(dpane);
                    gsc.setNamePanelWidth(gsc.getNameWidth());
                    continue;
                }
                if (args[i].indexOf("-list") > -1) {
                    System.out.println("AVAILABLE DATABASES:\n" + mat.getKeyNamesString());
                    continue;
                }
                if (args[i].indexOf("-id") > -1) {
                    IDTableJFrame idtab = new IDTableJFrame(gsc.getSequenceCollection());
                    idtab.printTable();
                    continue;
                }
                if (args[i].indexOf("-noshow") > -1) {
                    show = false;
                    continue;
                }
                if (args[i].indexOf("-print") > -1) {
                    print = true;
                    continue;
                }
                if (args[i].indexOf("-nres") > -1) {
                    nresiduesPerLine = Integer.parseInt(args[i + 1]);
                    continue;
                }
                if (args[i].indexOf("-pretty") > -1) {
                    PrettyPlotJFrame pretty = new PrettyPlotJFrame(minID, match, colID, colMatch, colIDBack, colMatchBack, prettyBox);
                    gsc.setPrettyPlot(true, pretty);
                    gsc.setDrawBoxes(false);
                    gsc.setDrawColor(false);
                    continue;
                }
                if (args[i].indexOf("-preview") > -1) {
                    PrintAlignmentImage pai = new PrintAlignmentImage(gsc);
                    pai.printPreview();
                    show = true;
                    continue;
                }
                if (args[i].indexOf("-type") > -1) {
                    if (args[i + 1].equalsIgnoreCase("png") || args[i + 1].equalsIgnoreCase("jpeg")) {
                        type = args[i + 1];
                        continue;
                    }
                    System.out.println("UNKOWN PRINT FORMAT: " + args[i + 1] + " reverting to default format " + type);
                    continue;
                }
                if (args[i].indexOf("-prefix") <= -1) continue;
                prefix = args[i + 1];
            }
            if (print) {
                if (onePage) {
                    PrintAlignmentImage pai = new PrintAlignmentImage(gsc);
                    if (antialias) {
                        pai.setAntiAlias(true);
                    }
                    pai.print(nresiduesPerLine, type, prefix, lmargin, rmargin, tmargin, bmargin);
                } else {
                    PrintAlignmentImage pai = new PrintAlignmentImage(gsc);
                    if (antialias) {
                        pai.setAntiAlias(true);
                    }
                    pai.print(nresiduesPerLine, type, prefix, landscape, lmargin, rmargin, tmargin, bmargin);
                }
            }
            if (!show) {
                System.exit(0);
            }
        } else {
            ajFrame = new AlignJFrame(true);
        }
        ajFrame.setVisible(true);
    }

    static {
        statusField = new JTextField();
    }

    class winExit
    extends WindowAdapter {
        winExit() {
        }

        public void windowClosing(WindowEvent we) {
            AlignJFrame.this.dispose();
            AlignJFrame.this.findPattern.dispose();
        }
    }
}

