/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.graphics;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.emboss.jemboss.editor.SequenceProperties;
import org.emboss.jemboss.graphics.PrintPlot;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.filetree.FileEditorDisplay;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class Graph2DPlot
extends ScrollPanel {
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private Object[][] emboss_data;
    private float xmin = 0.0f;
    private float xmax = 0.0f;
    private float ymin = 0.0f;
    private float ymax = 0.0f;
    private float xmin_screen = 0.0f;
    private float xmax_screen = 0.0f;
    private float ymin_screen = 0.0f;
    private float ymax_screen = 0.0f;
    private StringBuffer graph_data;
    private Color graph_colour = Color.black;
    private TextFieldFloat graph_line;
    private TextFieldFloat xstart;
    private TextFieldFloat xend;
    private TextFieldFloat ystart;
    private TextFieldFloat yend;
    private int xborder = 100;
    private int yborder = 100;
    private int WID = 700;
    private int HGT = 700;
    private int width = this.WID;
    private int height = this.HGT;
    private JComboBox x_formatList = null;
    private JComboBox y_formatList = null;
    private TextFieldInt xticks = null;
    private TextFieldInt yticks = null;
    private JTextField maintitle_field = null;
    private JTextField xtitle_field = null;
    private JTextField ytitle_field = null;
    private static int LINE = 1;
    private static int TEXT = 2;
    private static int RECTANGLE = 3;
    private static int FILLED_RECTANGLE = 4;
    private static int TEXTLINE = 5;
    private static int AXIS = 6;
    private boolean draw_axes = true;
    private boolean rectangle = false;
    private boolean screen_min_max = false;
    private Image offscreen = null;
    private String maintitle = "";
    private String subtitle = "";
    private String xtitle = "";
    private String ytitle = "";
    private String fileName = null;
    private Color[] plplot_colour = new Color[]{Color.black, Color.red, Color.yellow, Color.green, SequenceProperties.AQUAMARINE, Color.pink, SequenceProperties.WHEAT, Color.gray, SequenceProperties.BROWN, Color.blue, SequenceProperties.BLUEVIOLET, Color.cyan, SequenceProperties.TURQUOISE, SequenceProperties.MAGENTA, SequenceProperties.SALMON, Color.white};

    public Graph2DPlot() {
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.setToolTipText("");
    }

    public void setData(Object[][] emboss_data) {
        this.emboss_data = emboss_data;
        this.calcMinMax();
    }

    public void setFileData(String s, String fileName) {
        this.fileName = fileName;
        try {
            StringReader reader = new StringReader(s);
            this.emboss_data = this.readGraph(reader);
        }
        catch (FileNotFoundException fnne) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileName.indexOf("plotorf") > -1) {
            this.WID = 1000;
            this.HGT = 400;
            this.width = this.WID;
            this.height = this.HGT;
        }
        this.calcMinMax();
    }

    public void setFileData(File filename) {
        this.fileName = filename.getName();
        try {
            FileReader reader = new FileReader(filename);
            this.emboss_data = this.readGraph(reader);
        }
        catch (FileNotFoundException fnne) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.fileName.indexOf("plotorf") > -1) {
            this.WID = 1000;
            this.HGT = 400;
            this.width = this.WID;
            this.height = this.HGT;
        }
        this.calcMinMax();
    }

    public JMenuBar getMenuBar(boolean bexit, final JFrame frame) {
        JMenuItem fileMenuExit;
        JMenuBar menubar = new JMenuBar();
        menubar.add(Box.createRigidArea(new Dimension(5, 24)));
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem showMenu = new JMenuItem("Display data...");
        showMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame frame = new JFrame("EMBOSS data file");
                FileEditorDisplay fed = new FileEditorDisplay("graph_data.dat", (Object)Graph2DPlot.this.graph_data.toString());
                JScrollPane jsp = new JScrollPane(fed);
                fed.setCaretPosition(0);
                frame.getContentPane().add(jsp);
                frame.pack();
                frame.setSize(640, 580);
                frame.setVisible(true);
            }
        });
        fileMenu.add(showMenu);
        JMenuItem printMenu = new JMenuItem("Print...");
        printMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPlot pp = new PrintPlot(Graph2DPlot.this);
                pp.print();
            }
        });
        fileMenu.add(printMenu);
        fileMenu.add(new JSeparator());
        if (bexit) {
            fileMenuExit = new JMenuItem("Exit");
            fileMenuExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            fileMenu.add(fileMenuExit);
        } else {
            fileMenuExit = new JMenuItem("Close");
            fileMenuExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    frame.setVisible(false);
                    frame.dispose();
                }
            });
            fileMenu.add(fileMenuExit);
        }
        menubar.add(fileMenu);
        JMenu optionsMenu = new JMenu("Options");
        JMenuItem axesOptions = new JMenuItem("Axes, Labels...");
        axesOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String[] formats = new String[]{"default", "##0.0", "##0.00", "#0.##E0", "##0.##E0", "###0.##E0"};
                Box xbdown = Box.createVerticalBox();
                Box ybdown = Box.createVerticalBox();
                Dimension dim = new Dimension(130, 20);
                Box bacross = Box.createHorizontalBox();
                Graph2DPlot.this.x_formatList = new JComboBox<String>(formats);
                Graph2DPlot.this.x_formatList.setPreferredSize(dim);
                Graph2DPlot.this.x_formatList.setEditable(true);
                bacross.add(Graph2DPlot.this.x_formatList);
                bacross.add(new JLabel(" X-axis Number Format  "));
                xbdown.add(bacross);
                xbdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                Graph2DPlot.this.y_formatList = new JComboBox<String>(formats);
                Graph2DPlot.this.y_formatList.setPreferredSize(dim);
                Graph2DPlot.this.y_formatList.setEditable(true);
                bacross.add(Graph2DPlot.this.y_formatList);
                bacross.add(new JLabel(" Y-axis Number Format"));
                ybdown.add(bacross);
                ybdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.xticks == null) {
                    Graph2DPlot.this.xticks = new TextFieldInt();
                    Graph2DPlot.this.xticks.setValue(10);
                }
                Graph2DPlot.this.xticks.setPreferredSize(dim);
                Graph2DPlot.this.xticks.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.xticks);
                bacross.add(new JLabel(" Number of X ticks  "));
                bacross.add(Box.createHorizontalGlue());
                xbdown.add(bacross);
                xbdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.yticks == null) {
                    Graph2DPlot.this.yticks = new TextFieldInt();
                    Graph2DPlot.this.yticks.setValue(10);
                }
                Graph2DPlot.this.yticks.setPreferredSize(dim);
                Graph2DPlot.this.yticks.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.yticks);
                bacross.add(new JLabel(" Number of Y ticks"));
                bacross.add(Box.createHorizontalGlue());
                ybdown.add(bacross);
                ybdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.xstart == null) {
                    Graph2DPlot.this.xstart = new TextFieldFloat();
                    Graph2DPlot.this.xstart.setValue(Graph2DPlot.this.xmin);
                }
                Graph2DPlot.this.xstart.setPreferredSize(dim);
                Graph2DPlot.this.xstart.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.xstart);
                bacross.add(new JLabel(" Start X Tick  "));
                bacross.add(Box.createHorizontalGlue());
                xbdown.add(bacross);
                xbdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.ystart == null) {
                    Graph2DPlot.this.ystart = new TextFieldFloat();
                    Graph2DPlot.this.ystart.setValue(Graph2DPlot.this.ymin);
                }
                Graph2DPlot.this.ystart.setPreferredSize(dim);
                Graph2DPlot.this.ystart.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.ystart);
                bacross.add(new JLabel(" Start Y Tick"));
                bacross.add(Box.createHorizontalGlue());
                ybdown.add(bacross);
                ybdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.xend == null) {
                    Graph2DPlot.this.xend = new TextFieldFloat();
                    Graph2DPlot.this.xend.setValue(Graph2DPlot.this.xmax);
                }
                Graph2DPlot.this.xend.setPreferredSize(dim);
                Graph2DPlot.this.xend.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.xend);
                bacross.add(new JLabel(" End X Tick  "));
                bacross.add(Box.createHorizontalGlue());
                xbdown.add(bacross);
                xbdown.add(Box.createVerticalStrut(5));
                xbdown.add(new JSeparator());
                xbdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.yend == null) {
                    Graph2DPlot.this.yend = new TextFieldFloat();
                    Graph2DPlot.this.yend.setValue(Graph2DPlot.this.ymax);
                }
                Graph2DPlot.this.yend.setPreferredSize(dim);
                Graph2DPlot.this.yend.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.yend);
                bacross.add(new JLabel(" End Y Tick"));
                bacross.add(Box.createHorizontalGlue());
                ybdown.add(bacross);
                ybdown.add(Box.createVerticalStrut(5));
                ybdown.add(new JSeparator());
                ybdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.xtitle_field == null) {
                    Graph2DPlot.this.xtitle_field = new JTextField(Graph2DPlot.this.xtitle);
                }
                Graph2DPlot.this.xtitle_field.setPreferredSize(dim);
                Graph2DPlot.this.xtitle_field.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.xtitle_field);
                bacross.add(new JLabel(" X Axis Label  "));
                bacross.add(Box.createHorizontalGlue());
                xbdown.add(bacross);
                xbdown.add(Box.createVerticalStrut(5));
                xbdown.add(new JSeparator());
                xbdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.ytitle_field == null) {
                    Graph2DPlot.this.ytitle_field = new JTextField(Graph2DPlot.this.ytitle);
                }
                Graph2DPlot.this.ytitle_field.setPreferredSize(dim);
                Graph2DPlot.this.ytitle_field.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.ytitle_field);
                bacross.add(new JLabel(" Y Axis Label"));
                bacross.add(Box.createHorizontalGlue());
                ybdown.add(bacross);
                ybdown.add(Box.createVerticalStrut(5));
                ybdown.add(new JSeparator());
                ybdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                TextFieldInt xwidth = new TextFieldInt();
                xwidth.setValue(Graph2DPlot.this.WID);
                xwidth.setPreferredSize(dim);
                xwidth.setMaximumSize(dim);
                bacross.add(xwidth);
                bacross.add(new JLabel(" Graph Width "));
                bacross.add(Box.createHorizontalGlue());
                xbdown.add(bacross);
                xbdown.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                TextFieldInt yheight = new TextFieldInt();
                yheight.setValue(Graph2DPlot.this.HGT);
                yheight.setPreferredSize(dim);
                yheight.setMaximumSize(dim);
                bacross.add(yheight);
                bacross.add(new JLabel(" Graph Height "));
                bacross.add(Box.createHorizontalGlue());
                ybdown.add(bacross);
                ybdown.add(Box.createVerticalStrut(5));
                Box graphBox = Box.createVerticalBox();
                bacross = Box.createHorizontalBox();
                final JButton button_colour = new JButton();
                button_colour.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Color newColour = JColorChooser.showDialog(null, "Graph Colour", Graph2DPlot.this.graph_colour);
                        if (newColour != null) {
                            Graph2DPlot.this.graph_colour = newColour;
                            button_colour.setBackground(Graph2DPlot.this.graph_colour);
                        }
                    }
                });
                Dimension buttonSize = new Dimension(22, 24);
                button_colour.setBackground(Graph2DPlot.this.graph_colour);
                button_colour.setPreferredSize(buttonSize);
                button_colour.setMaximumSize(buttonSize);
                bacross.add(button_colour);
                bacross.add(new JLabel(" Graph Colour "));
                bacross.add(Box.createHorizontalGlue());
                graphBox.add(bacross);
                graphBox.add(Box.createVerticalStrut(5));
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.graph_line == null) {
                    Graph2DPlot.this.graph_line = new TextFieldFloat();
                    Graph2DPlot.this.graph_line.setValue(1.0);
                }
                Graph2DPlot.this.graph_line.setPreferredSize(dim);
                Graph2DPlot.this.graph_line.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.graph_line);
                bacross.add(new JLabel(" Graph Line Width "));
                bacross.add(Box.createHorizontalGlue());
                graphBox.add(bacross);
                Box bdown = Box.createVerticalBox();
                bacross = Box.createHorizontalBox();
                if (Graph2DPlot.this.maintitle_field == null) {
                    Graph2DPlot.this.maintitle_field = new JTextField(Graph2DPlot.this.maintitle);
                }
                dim = new Dimension(260, 20);
                Graph2DPlot.this.maintitle_field.setPreferredSize(dim);
                Graph2DPlot.this.maintitle_field.setMaximumSize(dim);
                bacross.add(Graph2DPlot.this.maintitle_field);
                bacross.add(new JLabel(" Main Title"));
                bacross.add(Box.createHorizontalGlue());
                bdown.add(bacross);
                bdown.add(Box.createVerticalStrut(5));
                bdown.add(new JSeparator());
                bdown.add(Box.createVerticalStrut(5));
                JPanel pane = new JPanel(new BorderLayout());
                pane.add((Component)bdown, "North");
                pane.add((Component)xbdown, "Center");
                pane.add((Component)ybdown, "East");
                pane.add((Component)graphBox, "South");
                Object[] options = new Object[]{"OK", "APPLY", "CANCEL"};
                int select = 1;
                while (select == 1) {
                    select = JOptionPane.showOptionDialog(null, pane, "Graph Options", 1, 3, null, options, options[0]);
                    if (select >= 2) continue;
                    if (Graph2DPlot.this.WID != xwidth.getValue() || Graph2DPlot.this.HGT != yheight.getValue()) {
                        Graph2DPlot.this.WID = xwidth.getValue();
                        Graph2DPlot.this.HGT = yheight.getValue();
                        Graph2DPlot.this.width = Graph2DPlot.this.WID;
                        Graph2DPlot.this.height = Graph2DPlot.this.HGT;
                        Graph2DPlot.this.setPreferredSize(new Dimension(Graph2DPlot.this.WID, Graph2DPlot.this.HGT));
                        Graph2DPlot.this.setSize(new Dimension(Graph2DPlot.this.WID, Graph2DPlot.this.HGT));
                        Graph2DPlot.this.removeAll();
                        Graph2DPlot.this.revalidate();
                    }
                    Graph2DPlot.this.offscreen = null;
                    Graph2DPlot.this.repaint();
                }
            }
        });
        optionsMenu.add(axesOptions);
        menubar.add(optionsMenu);
        return menubar;
    }

    public JToolBar getToolBar() {
        JToolBar toolbar = new JToolBar();
        String[] sizes = new String[]{"10", "12", "14", "16", "18"};
        final JComboBox<String> fntSize = new JComboBox<String>(sizes);
        fntSize.setMaximumSize(fntSize.getMinimumSize());
        fntSize.setToolTipText("Font size");
        fntSize.setSelectedItem(Integer.toString(this.getFont().getSize()));
        toolbar.add(fntSize);
        fntSize.setEditable(true);
        fntSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Graph2DPlot.this.setCursor(Graph2DPlot.this.cbusy);
                String fsize = (String)fntSize.getSelectedItem();
                Font fnt = Graph2DPlot.this.getFont();
                fnt = fnt.deriveFont(Float.parseFloat(fsize));
                Graph2DPlot.this.setFont(fnt);
                Graph2DPlot.this.offscreen = null;
                Graph2DPlot.this.repaint();
                Graph2DPlot.this.setCursor(Graph2DPlot.this.cdone);
            }
        });
        toolbar.addSeparator();
        String[] zoom = new String[]{"70", "80", "90", "100", "150", "200"};
        final JComboBox<String> zoomSize = new JComboBox<String>(zoom);
        zoomSize.setMaximumSize(zoomSize.getMinimumSize());
        zoomSize.setToolTipText("Zoom (%)");
        zoomSize.setSelectedItem("100");
        toolbar.add(zoomSize);
        zoomSize.setEditable(true);
        zoomSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Graph2DPlot.this.setCursor(Graph2DPlot.this.cbusy);
                float scale_factor = Float.parseFloat((String)zoomSize.getSelectedItem()) / 100.0f;
                Graph2DPlot.this.width = (int)((float)Graph2DPlot.this.WID * scale_factor);
                Graph2DPlot.this.height = (int)((float)Graph2DPlot.this.HGT * scale_factor);
                Graph2DPlot.this.setPreferredSize(new Dimension(Graph2DPlot.this.width, Graph2DPlot.this.height));
                Graph2DPlot.this.setSize(new Dimension(Graph2DPlot.this.width, Graph2DPlot.this.height));
                Graph2DPlot.this.removeAll();
                Graph2DPlot.this.revalidate();
                Graph2DPlot.this.offscreen = null;
                Graph2DPlot.this.repaint();
                Graph2DPlot.this.setCursor(Graph2DPlot.this.cdone);
            }
        });
        toolbar.add(new JLabel("%"));
        return toolbar;
    }

    private void calcMinMax() {
        int i;
        int xnum = this.emboss_data[0].length;
        if (this.xmin == 0.0f && this.xmax == 0.0f && this.ymin == 0.0f && this.ymax == 0.0f) {
            this.xmin = 1000000.0f;
            this.xmax = -1000000.0f;
            this.ymin = this.xmin;
            this.ymax = this.xmax;
        }
        int ncoords = this.emboss_data.length;
        for (i = 0; i < xnum; ++i) {
            float y;
            float x;
            if (ncoords == 2) {
                x = ((Float)this.emboss_data[0][i]).floatValue();
                y = ((Float)this.emboss_data[1][i]).floatValue();
            } else {
                if ((Integer)this.emboss_data[0][i] == TEXT || (Integer)this.emboss_data[0][i] == TEXTLINE || this.isTick(((Float)this.emboss_data[1][i]).floatValue(), ((Float)this.emboss_data[2][i]).floatValue(), ((Float)this.emboss_data[3][i]).floatValue(), ((Float)this.emboss_data[4][i]).floatValue(), ((Float)this.emboss_data[5][i]).floatValue(), false)) continue;
                x = ((Float)this.emboss_data[1][i]).floatValue();
                y = ((Float)this.emboss_data[2][i]).floatValue();
                if (this.xmin > x) {
                    this.xmin = x;
                }
                if (this.xmax < x) {
                    this.xmax = x;
                }
                if (this.ymin > y) {
                    this.ymin = y;
                }
                if (this.ymax < y) {
                    this.ymax = y;
                }
                x = ((Float)this.emboss_data[3][i]).floatValue();
                y = ((Float)this.emboss_data[4][i]).floatValue();
            }
            if (this.xmin > x) {
                this.xmin = x;
            }
            if (this.xmax < x) {
                this.xmax = x;
            }
            if (this.ymin > y) {
                this.ymin = y;
            }
            if (!(this.ymax < y)) continue;
            this.ymax = y;
        }
        if (this.screen_min_max) {
            if (this.xmin > this.xmax) {
                this.xmin = this.xmin_screen;
                this.xmax = this.xmax_screen;
            }
            if (this.ymin > this.ymax) {
                this.ymin = this.ymin_screen;
                this.ymax = this.ymax_screen;
            }
            if (ncoords > 2) {
                this.draw_axes = false;
                for (i = 0; i < xnum; ++i) {
                    if ((Integer)this.emboss_data[0][i] != LINE && (Integer)this.emboss_data[0][i] != RECTANGLE) continue;
                    float x1 = ((Float)this.emboss_data[1][i]).floatValue();
                    float y1 = ((Float)this.emboss_data[2][i]).floatValue();
                    float x2 = ((Float)this.emboss_data[3][i]).floatValue();
                    float y2 = ((Float)this.emboss_data[4][i]).floatValue();
                    if ((double)Math.abs(x2 - x1) > (double)(this.xmax - this.xmin) * 0.8 && ((double)Math.abs(y2 - y1) < 0.1 || (Integer)this.emboss_data[0][i] == RECTANGLE)) {
                        if (x2 > x1) {
                            this.xmax = x2;
                            this.xmin = x1;
                        } else {
                            this.xmax = x1;
                            this.xmin = x2;
                        }
                        this.draw_axes = true;
                        if ((Integer)this.emboss_data[0][i] == RECTANGLE) {
                            this.rectangle = true;
                        }
                        this.emboss_data[0][i] = new Integer(AXIS);
                        continue;
                    }
                    if (!((double)Math.abs(y2 - y1) > (double)(this.ymax - this.ymin) * 0.8) || !((double)Math.abs(x2 - x1) < 0.1)) continue;
                    if (y2 > y1) {
                        this.ymax = y2;
                        this.ymin = y1;
                    } else {
                        this.ymax = y1;
                        this.ymin = y2;
                    }
                    this.draw_axes = true;
                    if ((Integer)this.emboss_data[0][i] == RECTANGLE) {
                        this.rectangle = true;
                    }
                    this.emboss_data[0][i] = new Integer(AXIS);
                }
            }
            if (!this.draw_axes && this.ymin > this.ymin_screen) {
                this.ymin = this.ymin_screen;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int font_height = fm.getHeight();
        int tick_height = 10;
        int ytick_label_width = this.getYLabelWidth(fm);
        this.xborder = ytick_label_width + font_height + tick_height + 5;
        this.yborder = font_height + font_height + tick_height + 5;
        if (this.offscreen == null) {
            try {
                this.offscreen = this.createImage(this.getWidth(), this.getHeight());
                Graphics og = this.offscreen.getGraphics();
                og.setFont(this.getFont());
                og.setColor(Color.white);
                og.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.emboss_data.length == 2) {
                    this.drawPoints(og);
                } else {
                    this.drawGraphics(og, fm);
                }
                og.setColor(Color.black);
                this.drawTitles(og);
                if (this.draw_axes) {
                    this.drawAxes(og, tick_height);
                }
            }
            catch (OutOfMemoryError e) {
                String msg = "Memory error: " + e + "\nPlease check Jemboss JVM startup options";
                JOptionPane.showMessageDialog(null, msg, "Error", 0);
                throw e;
            }
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public void printComponent(Graphics g) {
        super.paintComponent(g);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int font_height = fm.getHeight();
        int tick_height = 10;
        int ytick_label_width = this.getYLabelWidth(fm);
        this.xborder = ytick_label_width + font_height + tick_height + 5;
        this.yborder = font_height + font_height + tick_height + 5;
        g.setFont(this.getFont());
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.emboss_data.length == 2) {
            this.drawPoints(g);
        } else {
            this.drawGraphics(g, fm);
        }
        g.setColor(Color.black);
        if (this.draw_axes) {
            this.drawAxes(g, tick_height);
        }
    }

    private void drawTitles(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int font_height = fm.getHeight();
        if (this.maintitle_field != null) {
            this.maintitle = this.maintitle_field.getText();
        }
        int title_width = fm.stringWidth(this.maintitle);
        g2d.drawString(this.maintitle, (this.getWidth() - title_width) / 2, font_height + 1);
        title_width = fm.stringWidth(this.subtitle);
        g2d.drawString(this.subtitle, (this.getWidth() - title_width) / 2, font_height * 2 + 2);
    }

    private void drawAxes(Graphics g, int tick_height) {
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int font_height = fm.getHeight();
        int font_height2 = font_height / 2;
        g2d.drawLine(this.xborder, this.getHeight() - this.yborder, this.getWidth() - this.xborder, this.getHeight() - this.yborder);
        if (this.xtitle_field != null) {
            this.xtitle = this.xtitle_field.getText();
        }
        int xtitle_width = fm.stringWidth(this.xtitle);
        g2d.drawString(this.xtitle, (this.getWidth() - xtitle_width) / 2, this.getHeight() - 3);
        g2d.drawLine(this.xborder, this.yborder, this.xborder, this.getHeight() - this.yborder);
        if (this.rectangle) {
            g2d.drawLine(this.xborder, this.yborder, this.getWidth() - this.xborder, this.yborder);
            g2d.drawLine(this.getWidth() - this.xborder, this.yborder, this.getWidth() - this.xborder, this.getHeight() - this.yborder);
        }
        int n_xticks = 10;
        if (this.xticks != null) {
            n_xticks = this.xticks.getValue();
        }
        g2d.translate(this.xborder, this.getHeight() - this.yborder);
        if (this.xstart == null) {
            this.xstart = new TextFieldFloat();
            this.xstart.setValue(this.xmin);
        }
        if (this.xend == null) {
            this.xend = new TextFieldFloat();
            this.xend.setValue(this.xmax);
        }
        float xfactor = (float)(this.getWidth() - 2 * this.xborder) / (float)(this.xend.getValue() - this.xstart.getValue());
        float xinterval = (float)((this.xend.getValue() - this.xstart.getValue()) / (double)n_xticks);
        float xinterval2 = xinterval / 2.0f;
        DecimalFormat myformat = null;
        myformat = this.x_formatList == null || ((String)this.x_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.xmax) : new DecimalFormat((String)this.x_formatList.getSelectedItem());
        for (int i = 0; i <= n_xticks; ++i) {
            float xpos = (float)((double)((float)i * xinterval) + this.xstart.getValue());
            int xpos_major = (int)((float)i * xinterval * xfactor);
            g2d.drawLine(xpos_major, 0, xpos_major, tick_height);
            if (i > 0) {
                int xpos_minor = (int)((float)xpos_major - xinterval2 * xfactor);
                g2d.drawLine(xpos_minor, 0, xpos_minor, tick_height / 2);
            }
            g2d.drawString(myformat.format(xpos), xpos_major - font_height2, font_height + tick_height);
        }
        int n_yticks = 10;
        if (this.yticks != null) {
            n_yticks = this.yticks.getValue();
        }
        if (this.ystart == null) {
            this.ystart = new TextFieldFloat();
            this.ystart.setValue(this.ymin);
        }
        if (this.yend == null) {
            this.yend = new TextFieldFloat();
            this.yend.setValue(this.ymax);
        }
        float yfactor = (float)((double)(this.getHeight() - 2 * this.yborder) / (this.yend.getValue() - this.ystart.getValue()));
        float yinterval = (float)(this.yend.getValue() - this.ystart.getValue()) / (float)n_yticks;
        float yinterval2 = yinterval / 2.0f;
        String numS = null;
        myformat = this.y_formatList == null || ((String)this.y_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.ymax) : new DecimalFormat((String)this.y_formatList.getSelectedItem());
        int ymax_tick_width = 0;
        float y1 = (float)this.ystart.getValue();
        for (int i = 0; i <= n_yticks; ++i) {
            float ypos = (float)i * yinterval;
            int ypos_major = -((int)(ypos * yfactor));
            g2d.drawLine(0, ypos_major, -tick_height, ypos_major);
            if (i > 0) {
                int ypos_minor = (int)((float)ypos_major + yinterval2 * yfactor);
                g2d.drawLine(0, ypos_minor, -tick_height / 2, ypos_minor);
            }
            numS = myformat.format(y1 + (float)i * yinterval);
            int string_width = fm.stringWidth(numS);
            g2d.drawString(numS, -string_width - tick_height, ypos_major);
            if (string_width <= ymax_tick_width) continue;
            ymax_tick_width = string_width;
        }
        g2d.translate(-this.xborder, -this.getHeight() + this.yborder);
        if (this.ytitle_field != null) {
            this.ytitle = this.ytitle_field.getText();
        }
        int ytitle_width = fm.stringWidth(this.ytitle);
        AffineTransform origin = g2d.getTransform();
        AffineTransform newOrig = (AffineTransform)origin.clone();
        newOrig.rotate(Math.toRadians(-90.0), 0.0, 0.0);
        g2d.setTransform(newOrig);
        g2d.drawString(this.ytitle, (-this.getHeight() + ytitle_width) / 2, this.xborder - ymax_tick_width - tick_height - 3);
        g2d.setTransform(origin);
    }

    private int getYLabelWidth(FontMetrics fm) {
        DecimalFormat myformat = null;
        myformat = this.y_formatList == null || ((String)this.y_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.ymax) : new DecimalFormat((String)this.y_formatList.getSelectedItem());
        int width = fm.stringWidth(myformat.format(this.ymax));
        if (width < fm.stringWidth(myformat.format(this.ymin))) {
            width = fm.stringWidth(myformat.format(this.ymax));
        }
        if (width < fm.stringWidth(myformat.format(this.xmax))) {
            width = fm.stringWidth(myformat.format(this.xmax));
        }
        if (width < fm.stringWidth(myformat.format(this.xmin))) {
            width = fm.stringWidth(myformat.format(this.xmin));
        }
        return width;
    }

    public String getToolTipText(MouseEvent e) {
        Point loc = e.getPoint();
        float xpos = (float)(loc.x - this.xborder) * (this.xmax - this.xmin) / (float)(this.getWidth() - 2 * this.xborder) + (float)this.xstart.getValue();
        float ypos = (float)(this.getHeight() - this.yborder - loc.y) * (this.ymax - this.ymin) / (float)(this.getHeight() - 2 * this.yborder) + (float)this.ystart.getValue();
        DecimalFormat xformat = null;
        DecimalFormat yformat = null;
        xformat = this.x_formatList == null || ((String)this.x_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.xmax) : new DecimalFormat((String)this.x_formatList.getSelectedItem());
        yformat = this.y_formatList == null || ((String)this.y_formatList.getSelectedItem()).equals("default") ? this.getFormat(this.ymax) : new DecimalFormat((String)this.y_formatList.getSelectedItem());
        return xformat.format(xpos) + "," + yformat.format(ypos);
    }

    private DecimalFormat getFormat(float max) {
        DecimalFormat myformat = null;
        if (max < 10.0f) {
            myformat = new DecimalFormat("##0.00");
        } else if (max < 10000.0f) {
            myformat = new DecimalFormat("##0.0");
        } else if (max < 100000.0f) {
            myformat = new DecimalFormat("##0.#E0");
        } else if (max < 1000000.0f) {
            myformat = new DecimalFormat("#0.##E0");
        }
        return myformat;
    }

    private void drawGraphics(Graphics g, FontMetrics fm) {
        Graphics2D g2d = (Graphics2D)g;
        BasicStroke stroke = (BasicStroke)g2d.getStroke();
        if (this.graph_line == null) {
            this.graph_line = new TextFieldFloat();
            this.graph_line.setValue(1.0);
        }
        g2d.setStroke(new BasicStroke((float)this.graph_line.getValue()));
        int xnum = this.emboss_data[0].length;
        if (this.xstart == null) {
            this.xstart = new TextFieldFloat();
            this.xstart.setValue(this.xmin);
        }
        if (this.xend == null) {
            this.xend = new TextFieldFloat();
            this.xend.setValue(this.xmax);
        }
        if (this.ystart == null) {
            this.ystart = new TextFieldFloat();
            this.ystart.setValue(this.ymin);
        }
        if (this.yend == null) {
            this.yend = new TextFieldFloat();
            this.yend.setValue(this.ymax);
        }
        float xfactor = (float)(this.getWidth() - 2 * this.xborder) / (float)(this.xend.getValue() - this.xstart.getValue());
        float yfactor = (float)(this.getHeight() - 2 * this.yborder) / (float)(this.yend.getValue() - this.ystart.getValue());
        float xendPoint = (float)(this.xend.getValue() - this.xstart.getValue()) * xfactor;
        float yendPoint = (float)(this.yend.getValue() - this.ystart.getValue()) * yfactor;
        g2d.translate(this.xborder, this.getHeight() - this.yborder);
        for (int i = 0; i < xnum; ++i) {
            int colourID;
            float y2;
            float x2;
            float x1 = (((Float)this.emboss_data[1][i]).floatValue() - (float)this.xstart.getValue()) * xfactor;
            float y1 = -(((Float)this.emboss_data[2][i]).floatValue() - (float)this.ystart.getValue()) * yfactor;
            if ((Integer)this.emboss_data[0][i] == LINE) {
                x2 = (((Float)this.emboss_data[3][i]).floatValue() - (float)this.xstart.getValue()) * xfactor;
                y2 = -(((Float)this.emboss_data[4][i]).floatValue() - (float)this.ystart.getValue()) * yfactor;
                if (!(x1 >= 0.0f && x2 >= 0.0f && x1 <= xendPoint && x2 <= xendPoint && y1 <= 0.0f && y2 <= 0.0f && y1 >= -yendPoint && y2 >= -yendPoint) && this.draw_axes) continue;
                colourID = (int)((Float)this.emboss_data[5][i]).floatValue();
                if (this.graph_colour != null && this.graph_colour != Color.black) {
                    g.setColor(this.graph_colour);
                } else if (colourID >= 0 || colourID < 16) {
                    g.setColor(this.plplot_colour[colourID]);
                }
                g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                continue;
            }
            if ((Integer)this.emboss_data[0][i] == RECTANGLE || (Integer)this.emboss_data[0][i] == FILLED_RECTANGLE) {
                x2 = (((Float)this.emboss_data[3][i]).floatValue() - (float)this.xstart.getValue()) * xfactor;
                y2 = -(((Float)this.emboss_data[4][i]).floatValue() - (float)this.ystart.getValue()) * yfactor;
                colourID = (int)((Float)this.emboss_data[5][i]).floatValue();
                if (this.graph_colour != null && this.graph_colour != Color.black) {
                    g.setColor(this.graph_colour);
                } else if (colourID >= 0 || colourID < 16) {
                    g.setColor(this.plplot_colour[colourID]);
                }
                if (x1 > x2) {
                    float x1_tmp = x1;
                    x1 = x2;
                    x2 = x1_tmp;
                }
                if ((Integer)this.emboss_data[0][i] == RECTANGLE) {
                    g.drawRect((int)x1, (int)y2, (int)Math.abs(x2 - x1), (int)Math.abs(y1 - y2));
                    continue;
                }
                g.fillRect((int)x1, (int)y2, (int)Math.abs(x2 - x1), (int)Math.abs(y1 - y2));
                continue;
            }
            if ((Integer)this.emboss_data[0][i] == TEXT) {
                boolean number = true;
                try {
                    String text = (String)this.emboss_data[5][i];
                    Float.parseFloat(text);
                }
                catch (NumberFormatException nfe) {
                    number = false;
                }
                if (x1 >= 0.0f && y1 <= 0.0f && x1 <= xendPoint && y1 >= -yendPoint) {
                    int colourID2 = (int)((Float)this.emboss_data[3][i]).floatValue();
                    int textWidth = this.justify((String)this.emboss_data[5][i], fm);
                    g.setColor(this.plplot_colour[colourID2]);
                    g.drawString((String)this.emboss_data[5][i], (int)(x1 - (float)textWidth), (int)y1);
                    continue;
                }
                if (y1 > 0.0f && !number) {
                    if (this.xtitle_field != null) continue;
                    this.xtitle_field = new JTextField((String)this.emboss_data[5][i]);
                    continue;
                }
                if (!(y1 < yendPoint) || number || this.maintitle_field != null) continue;
                this.maintitle_field = new JTextField((String)this.emboss_data[5][i]);
                continue;
            }
            if ((Integer)this.emboss_data[0][i] != TEXTLINE) continue;
            if (x1 >= 0.0f && y1 <= 0.0f && x1 <= xendPoint && y1 >= -yendPoint && this.emboss_data[5][i] instanceof Float) {
                colourID = (int)((Float)this.emboss_data[5][i]).floatValue();
                g.setColor(this.plplot_colour[colourID]);
                g.drawString((String)this.emboss_data[6][i], (int)x1, (int)y1);
                continue;
            }
            if (this.emboss_data[6][i] instanceof String) {
                if (this.ytitle_field != null) continue;
                this.ytitle_field = new JTextField((String)this.emboss_data[6][i]);
                continue;
            }
            if (!(y1 < yendPoint) || !(this.emboss_data[5][i] instanceof String) || this.maintitle_field != null) continue;
            this.maintitle_field = new JTextField((String)this.emboss_data[5][i]);
        }
        g2d.translate(-this.xborder, -this.getHeight() + this.yborder);
        g2d.setStroke(stroke);
    }

    private int justify(String s, FontMetrics fm) {
        int textWidth = 0;
        if (s.length() == 1 && this.fileName.indexOf("prettyplot") > -1) {
            return textWidth;
        }
        return fm.stringWidth(s) / 2;
    }

    private void drawPoints(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.graph_colour);
        BasicStroke stroke = (BasicStroke)g2d.getStroke();
        if (this.graph_line == null) {
            this.graph_line = new TextFieldFloat();
            this.graph_line.setValue(1.0);
        }
        g2d.setStroke(new BasicStroke((float)this.graph_line.getValue()));
        int xnum = this.emboss_data[0].length;
        if (this.xstart == null) {
            this.xstart = new TextFieldFloat();
            this.xstart.setValue(this.xmin);
        }
        if (this.xend == null) {
            this.xend = new TextFieldFloat();
            this.xend.setValue(this.xmax);
        }
        if (this.ystart == null) {
            this.ystart = new TextFieldFloat();
            this.ystart.setValue(this.ymin);
        }
        if (this.yend == null) {
            this.yend = new TextFieldFloat();
            this.yend.setValue(this.ymax);
        }
        float xfactor = (float)(this.getWidth() - 2 * this.xborder) / (float)(this.xend.getValue() - this.xstart.getValue());
        float yfactor = (float)(this.getHeight() - 2 * this.yborder) / (float)(this.yend.getValue() - this.ystart.getValue());
        float x1 = (((Float)this.emboss_data[0][0]).floatValue() - (float)this.xstart.getValue()) * xfactor;
        float y1 = -(((Float)this.emboss_data[1][0]).floatValue() - (float)this.ystart.getValue()) * yfactor;
        g2d.translate(this.xborder, this.getHeight() - this.yborder);
        for (int i = 1; i < xnum; ++i) {
            float x2 = (((Float)this.emboss_data[0][i]).floatValue() - (float)this.xstart.getValue()) * xfactor;
            float y2 = -(((Float)this.emboss_data[1][i]).floatValue() - (float)this.ystart.getValue()) * yfactor;
            if (x1 >= 0.0f && x2 >= 0.0f && y1 <= 0.0f && y2 <= 0.0f) {
                g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
            }
            x1 = x2;
            y1 = y2;
        }
        g2d.translate(-this.xborder, -this.getHeight() + this.yborder);
        g2d.setStroke(stroke);
    }

    public Object[][] readGraph(Reader read) throws IOException {
        Object[][] emboss_data;
        String line;
        BufferedReader in = new BufferedReader(read);
        Vector<Object> vx = new Vector<Object>();
        Vector<Float> vy = new Vector<Float>();
        this.graph_data = new StringBuffer();
        int npoints = 0;
        boolean xygraph = false;
        while ((line = in.readLine()) != null) {
            int ind;
            this.graph_data.append(line + "\n");
            if ((line.startsWith("Line") || line.startsWith("Rectangle") || line.startsWith("Filled Rectangle")) && !xygraph) {
                vx.add(line);
                continue;
            }
            if (line.startsWith("##Points ")) {
                ind = line.indexOf(" ");
                npoints = Integer.parseInt(line.substring(ind).trim());
                continue;
            }
            if (line.startsWith("##Screen ")) {
                StringTokenizer tok = new StringTokenizer(line, " ");
                tok.nextToken();
                tok.nextToken();
                this.xmin_screen = Float.parseFloat(tok.nextToken());
                tok.nextToken();
                this.ymin_screen = Float.parseFloat(tok.nextToken());
                tok.nextToken();
                this.xmax_screen = Float.parseFloat(tok.nextToken());
                tok.nextToken();
                this.ymax_screen = Float.parseFloat(tok.nextToken());
                this.screen_min_max = true;
                continue;
            }
            if (line.startsWith("##Xmin ")) {
                StringTokenizer tok = new StringTokenizer(line, " ");
                tok.nextToken();
                this.xmin = Float.parseFloat(tok.nextToken());
                tok.nextToken();
                this.xmax = Float.parseFloat(tok.nextToken());
                tok.nextToken();
                this.ymin = Float.parseFloat(tok.nextToken());
                tok.nextToken();
                this.ymax = Float.parseFloat(tok.nextToken());
                continue;
            }
            if (!(line.startsWith("#") || line.equals("") || line.startsWith("Text") || line.startsWith("Line"))) {
                ind = (line = line.trim()).indexOf("\t");
                if (ind == -1) {
                    ind = line.indexOf(" ");
                }
                xygraph = true;
                vx.add(new Float(line.substring(0, ind).trim()));
                vy.add(new Float(line.substring(ind).trim()));
                continue;
            }
            if (line.startsWith("##Xtitle")) {
                ind = line.indexOf(" ");
                this.xtitle = line.substring(ind).trim();
                if (!this.xtitle.equals("<null>")) continue;
                this.xtitle = "x";
                continue;
            }
            if (line.startsWith("##Ytitle")) {
                ind = line.indexOf(" ");
                this.ytitle = line.substring(ind).trim();
                if (!this.ytitle.equals("<null>")) continue;
                this.ytitle = "y";
                continue;
            }
            if (line.startsWith("##Maintitle ")) {
                ind = line.indexOf(" ");
                this.maintitle = line.substring(ind).trim();
                continue;
            }
            if (line.startsWith("##Subtitle ")) {
                ind = line.indexOf(" ");
                this.subtitle = line.substring(ind).trim();
                continue;
            }
            if (!line.startsWith("Text")) continue;
            vx.add(line);
        }
        npoints = vx.size();
        if (vy.size() > 0) {
            emboss_data = new Object[2][npoints];
            for (int i = 0; i < npoints; ++i) {
                emboss_data[0][i] = (Float)vx.get(i);
                emboss_data[1][i] = (Float)vy.get(i);
            }
        } else {
            emboss_data = new Object[7][npoints];
            for (int i = 0; i < npoints; ++i) {
                this.setGraphicRow(emboss_data, (String)vx.get(i), i);
            }
        }
        return emboss_data;
    }

    private void setGraphicRow(Object[][] emboss_data, String line, int i) {
        StringTokenizer tok = new StringTokenizer(line, " ");
        String type = tok.nextToken();
        if (type.equals("Line")) {
            emboss_data[0][i] = new Integer(LINE);
        } else if (type.startsWith("Textline")) {
            emboss_data[0][i] = new Integer(TEXTLINE);
        } else if (type.startsWith("Text")) {
            emboss_data[0][i] = new Integer(TEXT);
        } else if (type.equals("Rectangle")) {
            emboss_data[0][i] = new Integer(RECTANGLE);
        } else if (type.equals("Filled")) {
            emboss_data[0][i] = new Integer(FILLED_RECTANGLE);
            tok.nextToken();
        }
        tok.nextToken();
        emboss_data[1][i] = Float.valueOf(tok.nextToken());
        tok.nextToken();
        emboss_data[2][i] = Float.valueOf(tok.nextToken());
        tok.nextToken();
        emboss_data[3][i] = Float.valueOf(tok.nextToken());
        tok.nextToken();
        emboss_data[4][i] = Float.valueOf(tok.nextToken());
        if (type.equals("Line") || type.equals("Rectangle") || type.equals("Filled")) {
            tok.nextToken();
            emboss_data[5][i] = Float.valueOf(tok.nextToken());
        } else if (type.startsWith("Textline")) {
            tok.nextToken();
            emboss_data[5][i] = Float.valueOf(tok.nextToken());
            tok.nextToken();
            tok.nextToken();
            String text = new String();
            while (tok.hasMoreTokens()) {
                text = text + " " + tok.nextToken();
            }
            emboss_data[6][i] = text.trim();
        } else if (type.startsWith("Text")) {
            String text = new String();
            while (tok.hasMoreTokens()) {
                text = text + " " + tok.nextToken();
            }
            emboss_data[5][i] = text.trim();
        }
    }

    private boolean isTick(float x1, float y1, float x2, float y2, float colourID, boolean checkBounds) {
        if (colourID != 0.0f) {
            return false;
        }
        if (x1 == x2 || y1 == y2) {
            if (checkBounds) {
                if (this.isOutOfXBounds(x1) || this.isOutOfXBounds(x2) || this.isOutOfYBounds(y1) || this.isOutOfYBounds(y2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean isOutOfXBounds(float x) {
        return x < this.xmin || x > this.xmax;
    }

    private boolean isOutOfYBounds(float y) {
        return y < this.ymin || y > this.ymax;
    }

    public static void main(String[] arg) {
        JFrame frame = new JFrame("Jemboss Graphics");
        Graph2DPlot gp = new Graph2DPlot();
        JScrollPane scroll = new JScrollPane(gp);
        scroll.setPreferredSize(new Dimension(400, 400));
        frame.getContentPane().add(scroll);
        File file = new File(arg[0]);
        gp.setFileData(file);
        frame.setJMenuBar(gp.getMenuBar(false, frame));
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

