/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.emboss.jemboss.Jemboss;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.editor.AlignJFrame;
import org.emboss.jemboss.graphics.Graph2DPlot;
import org.emboss.jemboss.gui.AdvancedOptions;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.BuildProgramMenu;
import org.emboss.jemboss.gui.ResultsMenuBar;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.ShowResultSet;
import org.emboss.jemboss.gui.form.AlignFormat;
import org.emboss.jemboss.gui.form.JembossComboPopup;
import org.emboss.jemboss.gui.form.ListFilePanel;
import org.emboss.jemboss.gui.form.MultiTextField;
import org.emboss.jemboss.gui.form.PlafMacros;
import org.emboss.jemboss.gui.form.ReportFormat;
import org.emboss.jemboss.gui.form.SectionPanel;
import org.emboss.jemboss.gui.form.SetInFileCard;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;
import org.emboss.jemboss.gui.form.TextFieldSink;
import org.emboss.jemboss.gui.sequenceChooser.InputSequenceAttributes;
import org.emboss.jemboss.gui.sequenceChooser.OutputSequenceAttributes;
import org.emboss.jemboss.parser.ParseAcd;
import org.emboss.jemboss.programs.BatchUpdateTimer;
import org.emboss.jemboss.programs.JembossProcess;
import org.emboss.jemboss.programs.ListFile;
import org.emboss.jemboss.server.JembossServer;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.GetHelp;
import org.emboss.jemboss.soap.GetVersion;
import org.emboss.jemboss.soap.JembossRun;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.MakeFileSafe;

public class BuildJembossForm
implements ActionListener {
    private ReportFormat rf;
    private AlignFormat af;
    private TextFieldSink[] textf;
    private TextFieldInt[] textInt;
    private TextFieldFloat[] textFloat;
    private JTextField[] rangeField;
    private JCheckBox[] checkBox;
    private InputSequenceAttributes[] inSeqAttr;
    private ListFilePanel[] filelist;
    private MultiTextField[] multiTextField;
    private JComboBox graphics;
    protected static OutputSequenceAttributes outSeqAttr;
    private Box advSectionBox;
    private Box addSectionBox;
    protected static JPanel advSection;
    protected static JPanel addSection;
    protected static JPanel reqdSection;
    protected static JPanel outSection;
    protected static JPanel inpSection;
    private JembossComboPopup[] fieldOption;
    private JList[] multiOption;
    private SetInFileCard[] inSeq;
    private JButton balign;
    private String applName;
    private String[] db;
    private String[] envp;
    private String cwd;
    private ParseAcd parseAcd;
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private String seqoutResult;
    private String outfileResult;
    private boolean withSoap;
    private JFrame f;
    private JPanel p2;
    private int numofFields;
    private JembossParams mysettings;
    static final String fs;
    static Preferences prfs;
    protected static final String DISPLAY_JOB_SUBMITTED_MSG = "DISPLAY_JOB_SUBMITTED_MSG";

    public BuildJembossForm(String appDescription, String[] db, final String applName, String[] envp, String cwd, String acdText, final boolean withSoap, JPanel formPane, final JembossParams mysettings, JFrame f) {
        this.f = f;
        this.p2 = formPane;
        this.db = db;
        this.cwd = cwd;
        this.mysettings = mysettings;
        this.withSoap = withSoap;
        this.envp = envp;
        this.applName = applName;
        Box fieldPane = Box.createVerticalBox();
        this.parseAcd = new ParseAcd(acdText, false);
        this.numofFields = this.parseAcd.getNumofFields();
        this.attach(this.p2, fieldPane, appDescription);
        this.p2.add((Component)fieldPane, "Center");
        if (outSection != null) {
            this.p2.setBackground(outSection.getBackground());
        }
        ClassLoader cl = this.getClass().getClassLoader();
        JButton bhelp = new JButton(new ImageIcon(cl.getResource("images/Information_button.gif")));
        bhelp.addActionListener(this);
        bhelp.setMargin(new Insets(0, 1, 0, 1));
        bhelp.setToolTipText("Help");
        bhelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String url;
                String text;
                block13: {
                    text = "";
                    url = null;
                    if (!withSoap) {
                        String acddir = mysettings.getAcdDirToParse();
                        String dochome = ".." + fs + "doc" + fs + "programs" + fs + "html";
                        url = acddir + fs + dochome + fs + applName + ".html";
                        try {
                            File f = new File(url);
                            if (f.exists()) {
                                url = f.getCanonicalFile().toURI().toString();
                                break block13;
                            }
                            url = null;
                        }
                        catch (IOException e1) {
                            url = null;
                        }
                    } else {
                        String urlEmbassyPrefix = BuildJembossForm.this.parseAcd.getUrlPrefix();
                        url = mysettings.getembURL();
                        String version = GetVersion.getVersion(mysettings);
                        url = urlEmbassyPrefix != null ? url + "apps/release/" + version + "/embassy/" + urlEmbassyPrefix + "/" : url + "apps/release/" + version + "/emboss/apps/";
                        url = url + applName + ".html";
                    }
                }
                if (url == null || mysettings.isUseTFM()) {
                    GetHelp thishelp = new GetHelp(applName, mysettings);
                    text = thishelp.getHelpText();
                    try {
                        new Browser(url, applName, true, text, mysettings);
                    }
                    catch (IOException ioe3) {}
                } else {
                    try {
                        new Browser(url, applName, mysettings);
                    }
                    catch (IOException ioe2) {
                        GetHelp thishelp = new GetHelp(applName, mysettings);
                        text = thishelp.getHelpText();
                        try {
                            new Browser(url, applName, true, text, mysettings);
                        }
                        catch (IOException ioe3) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.balign = new JButton("Show Alignment");
        this.balign.addActionListener(this);
        ImageIcon rfii = new ImageIcon(cl.getResource("images/Go_button.gif"));
        JButton bgo = new JButton(rfii);
        bgo.setToolTipText("Start a new job using the selected execution mode");
        bgo.setActionCommand("GO");
        bgo.setMargin(new Insets(0, 0, 0, 0));
        bgo.addActionListener(this);
        Box tools = Box.createHorizontalBox();
        Box modeSelectionBox = Box.createVerticalBox();
        JLabel mode = new JLabel("Execution mode:");
        mode.setAlignmentX(0.0f);
        modeSelectionBox.add(mode);
        JComboBox excMode = Jemboss.resultsManager.getExcModeComboBox(mode.getPreferredSize().width);
        modeSelectionBox.add(Box.createRigidArea(new Dimension(5, 0)));
        modeSelectionBox.add(excMode);
        tools.add(Box.createRigidArea(new Dimension(5, 0)));
        tools.add(modeSelectionBox);
        tools.add(Box.createRigidArea(new Dimension(10, 0)));
        tools.add(bgo);
        tools.add(Box.createRigidArea(new Dimension(20, 0)));
        tools.add(bhelp);
        if (this.advSectionBox != null || this.addSectionBox != null) {
            JButton badvanced = new JButton("Advanced Options");
            badvanced.addActionListener(this);
            tools.add(Box.createRigidArea(new Dimension(20, 0)));
            tools.add(badvanced);
        }
        tools.add(Box.createRigidArea(new Dimension(4, 0)));
        tools.add(this.balign);
        this.balign.setVisible(false);
        tools.add(Box.createHorizontalGlue());
        fieldPane.add(Box.createRigidArea(new Dimension(0, 10)));
        fieldPane.add(tools);
        fieldPane.add(Box.createVerticalStrut(10));
        bgo.setMinimumSize(new Dimension(200, 40));
        bgo.setMaximumSize(new Dimension(200, 40));
        if (this.addSectionBox != null) {
            fieldPane.add(this.addSectionBox);
            this.addSectionBox.setVisible(false);
        }
        if (this.advSectionBox != null) {
            fieldPane.add(this.advSectionBox);
            this.advSectionBox.setVisible(false);
        }
        fieldPane.add(Box.createVerticalGlue());
    }

    public void attach(JPanel p3, Box fieldPane, String appDescription) {
        Dimension d;
        int j;
        int ntextf = this.parseAcd.getNumTextf();
        int nint = this.parseAcd.getNumNint();
        int nfloat = this.parseAcd.getNumNfloat();
        int nbool = this.parseAcd.getNumBool();
        int nseqs = this.parseAcd.getNumSeq();
        int nlist = this.parseAcd.getNumList();
        int mlist = this.parseAcd.getNumMList();
        int nrange = this.parseAcd.getNumRange();
        int nflist = this.parseAcd.getNumFileList();
        int nmultiText = this.parseAcd.getNumMultiTextField();
        this.textf = new TextFieldSink[ntextf];
        this.textInt = new TextFieldInt[nint];
        this.textFloat = new TextFieldFloat[nfloat];
        this.checkBox = new JCheckBox[nbool];
        this.inSeqAttr = new InputSequenceAttributes[nseqs];
        this.filelist = new ListFilePanel[nflist];
        this.fieldOption = new JembossComboPopup[nlist];
        this.multiOption = new JList[mlist];
        this.rangeField = new JTextField[nrange];
        this.inSeq = new SetInFileCard[nseqs];
        this.multiTextField = new MultiTextField[nmultiText];
        Box[] lab = new Box[this.numofFields];
        for (j = 0; j < nbool; ++j) {
            this.checkBox[j] = new JCheckBox();
        }
        for (j = 0; j < ntextf; ++j) {
            this.textf[j] = new TextFieldSink();
            d = new Dimension(150, 30);
            this.textf[j].setPreferredSize(d);
            this.textf[j].setMinimumSize(d);
            this.textf[j].setMaximumSize(d);
        }
        for (j = 0; j < nint; ++j) {
            this.textInt[j] = new TextFieldInt();
            d = new Dimension(150, 30);
            this.textInt[j].setPreferredSize(d);
            this.textInt[j].setMinimumSize(d);
            this.textInt[j].setMaximumSize(d);
        }
        for (j = 0; j < nfloat; ++j) {
            this.textFloat[j] = new TextFieldFloat();
            d = new Dimension(150, 30);
            this.textFloat[j].setPreferredSize(d);
            this.textFloat[j].setMinimumSize(d);
            this.textFloat[j].setMaximumSize(d);
        }
        for (j = 0; j < nrange; ++j) {
            this.rangeField[j] = new TextFieldSink();
            d = new Dimension(150, 30);
            this.rangeField[j].setPreferredSize(d);
            this.rangeField[j].setMinimumSize(d);
            this.rangeField[j].setMaximumSize(d);
        }
        int nsection = this.parseAcd.getNumSection();
        if (nsection == 0) {
            nsection = 1;
        }
        int nfield = 0;
        this.advSectionBox = null;
        this.addSectionBox = null;
        reqdSection = null;
        outSection = null;
        inpSection = null;
        if (this.parseAcd.isBatchable() && !this.parseAcd.getExpectedCPU().equalsIgnoreCase("low")) {
            Jemboss.resultsManager.updateMode("batch");
        } else {
            Jemboss.resultsManager.updateMode("interactive");
        }
        this.graphics = this.withSoap && BuildProgramMenu.serverSupportsPDF || !this.withSoap && this.mysettings.getEmbossHavePDF() ? new JComboBox<String>(new String[]{"PNG", "PDF", "SVG", "Jemboss Graphics"}) : new JComboBox<String>(new String[]{"PNG", "SVG", "Jemboss Graphics"});
        for (int j2 = 0; j2 < nsection; ++j2) {
            if (nfield >= this.numofFields) continue;
            SectionPanel sp = new SectionPanel(this.f, p3, fieldPane, this.parseAcd, nfield, this.multiTextField, this.textf, this.textInt, this.textFloat, this.rangeField, this.checkBox, this.inSeqAttr, this.fieldOption, this.multiOption, this.inSeq, this.filelist, this.graphics, this.db, appDescription, lab, this.numofFields, this.mysettings, this.withSoap, this.envp);
            if (sp.isReportFormat()) {
                this.rf = sp.getReportFormat();
            }
            if (sp.isAlignFormat()) {
                this.af = sp.getAlignFormat();
            }
            if (sp.isAdvancedSection()) {
                this.advSectionBox = sp.getSectionBox();
                advSection = sp.getSectionPanel();
            } else if (sp.isAdditionalSection()) {
                this.addSectionBox = sp.getSectionBox();
                addSection = sp.getSectionPanel();
            } else if (sp.getSectionBox() != null) {
                fieldPane.add(sp.getSectionBox());
                if (sp.isInputSection()) {
                    inpSection = sp.getSectionPanel();
                } else if (sp.isRequiredSection()) {
                    reqdSection = sp.getSectionPanel();
                } else if (sp.isOutputSection()) {
                    outSection = sp.getSectionPanel();
                }
            }
            nfield = sp.getFieldNum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent ae) {
        Window resultSetFrame = null;
        if (ae.getActionCommand().startsWith("Advanced Option")) {
            if (this.advSectionBox != null) {
                this.advSectionBox.setVisible(!this.advSectionBox.isVisible());
            }
            if (this.addSectionBox != null) {
                this.addSectionBox.setVisible(!this.addSectionBox.isVisible());
            }
            this.p2.setVisible(false);
            this.p2.setVisible(true);
            return;
        } else if (ae.getActionCommand().startsWith("GO")) {
            boolean batchStart = false;
            this.f.setCursor(this.cbusy);
            if (this.mysettings.getCurrentMode().equals("batch")) {
                batchStart = true;
            }
            try {
                if (!this.withSoap) {
                    Hashtable filesToMove = new Hashtable();
                    ArrayList commandA = new ArrayList();
                    String embossCommand = this.getCommand(filesToMove, commandA);
                    if (embossCommand.equals("NOT OK")) return;
                    if (batchStart) {
                        BatchSoapProcess bsp = new BatchSoapProcess(embossCommand, filesToMove, this.mysettings, commandA);
                        bsp.setWithSoap(false);
                        bsp.start();
                        if (!prfs.getBoolean(DISPLAY_JOB_SUBMITTED_MSG, true)) return;
                        JPanel p = new JPanel(new BorderLayout(1, 10));
                        JLabel jobSubmitted = new JLabel("Your job has been submitted");
                        p.add((Component)jobSubmitted, "First");
                        JLabel checkResults = new JLabel("Use Batch Job Manager");
                        checkResults.setHorizontalTextPosition(2);
                        checkResults.setFont(new Font("Dialog", 0, 13));
                        checkResults.setForeground(new Color(91, 53, 53));
                        ClassLoader cl = this.getClass().getClassLoader();
                        ImageIcon jobIcon = new ImageIcon(cl.getResource("images/Job_manager_button.gif"));
                        checkResults.setIcon(jobIcon);
                        p.add((Component)checkResults, "Center");
                        JLabel checkResults_ = new JLabel(" to check its results");
                        checkResults_.setFont(new Font("Dialog", 0, 13));
                        checkResults_.setForeground(new Color(91, 53, 53));
                        p.add((Component)checkResults_, "After");
                        JCheckBox dontShowAgain = new JCheckBox("don't show this dialog again");
                        dontShowAgain.addItemListener(new ItemListener(){

                            public void itemStateChanged(ItemEvent e) {
                                if (e.getStateChange() == 1) {
                                    prfs.putBoolean(BuildJembossForm.DISPLAY_JOB_SUBMITTED_MSG, false);
                                } else {
                                    prfs.putBoolean(BuildJembossForm.DISPLAY_JOB_SUBMITTED_MSG, true);
                                }
                            }
                        });
                        dontShowAgain.setFont(new Font("Dialog", 0, 10));
                        p.add((Component)dontShowAgain, "Last");
                        JOptionPane.showMessageDialog(null, p, "Job submitted", 1);
                        return;
                    }
                    JembossServer js = new JembossServer(this.mysettings.getResultsHome());
                    Vector filesToMovev = new Vector();
                    Vector result = js.run_prog_array(new Vector(commandA), this.mysettings.getCurrentMode(), filesToMovev, "");
                    Hashtable r = BuildJembossForm.convert(result, false);
                    try {
                        resultSetFrame = new ShowResultSet(r, filesToMove, js.getProjectName(), this.mysettings);
                        return;
                    }
                    catch (OutOfMemoryError e) {
                        result.clear();
                        filesToMove.clear();
                        r.clear();
                        throw e;
                    }
                }
                Hashtable filesToMove = new Hashtable();
                ArrayList commandA = new ArrayList();
                String embossCommand = this.getCommand(filesToMove, commandA);
                if (embossCommand.equals("NOT OK")) return;
                if (this.mysettings.getUseAuth() && this.mysettings.getServiceUserName() == null) {
                    System.out.println("OOPS! Authentication required!");
                }
                try {
                    if (batchStart) {
                        BatchSoapProcess bsp = new BatchSoapProcess(embossCommand, filesToMove, this.mysettings, commandA);
                        bsp.start();
                        return;
                    }
                    JembossRun thisrun = this.mysettings.getUseAuth() ? new JembossRun(embossCommand, "", filesToMove, this.mysettings) : new JembossRun(commandA, "", filesToMove, this.mysettings);
                    resultSetFrame = new ShowResultSet(thisrun.hash(), filesToMove, this.mysettings);
                    return;
                }
                catch (JembossSoapException eae) {
                    if (this.mysettings.getUseAuth()) {
                        AuthPopup ap = new AuthPopup(this.mysettings, this.f);
                        ap.setBottomPanel();
                        ap.setSize(380, 170);
                        ap.pack();
                        ap.setVisible(true);
                        return;
                    }
                    JOptionPane.showMessageDialog(this.f, eae.getMessage(), "Problem in executing server job", 0);
                }
                return;
            }
            catch (OutOfMemoryError e) {
                if (resultSetFrame != null) {
                    resultSetFrame.dispose();
                }
                String msg = "Memory error: " + e + "\nPlease check Jemboss JVM startup options";
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.f, msg, "Error", 0);
                return;
            }
            finally {
                this.f.setCursor(this.cdone);
            }
        } else {
            if (!ae.getActionCommand().startsWith("Show Alignment")) return;
            AlignJFrame ajFrame = new AlignJFrame(new File(this.seqoutResult));
            ajFrame.setVisible(true);
        }
    }

    public static Hashtable convert(Vector vans, boolean keepStatus) {
        Hashtable proganswer = new Hashtable();
        int n = vans.size();
        for (int j = 0; j < n; j += 2) {
            String s = (String)vans.get(j);
            if (s.equals("msg")) {
                String msg = (String)vans.get(j + 1);
                if (msg.indexOf("Error") == -1 && msg.indexOf("error") == -1) continue;
                JOptionPane.showMessageDialog(null, msg, "alert", 0);
                continue;
            }
            if (!keepStatus && s.equals("status")) continue;
            proganswer.put(s, vans.get(j + 1));
        }
        return proganswer;
    }

    private void showStandaloneResults(String stdout) {
        JScrollPane rscroll;
        ScrollPanel pscroll;
        JPanel presults;
        final JFrame res = new JFrame(this.applName + " Results  : " + this.seqoutResult);
        res.setDefaultCloseOperation(2);
        final JTabbedPane fresults = new JTabbedPane();
        res.getContentPane().add((Component)fresults, "Center");
        Hashtable<String, Object> hashRes = new Hashtable<String, Object>();
        Dimension d = res.getToolkit().getScreenSize();
        res.setSize((int)d.getWidth() / 2, (int)d.getHeight() / 2);
        if (!(stdout.equals("") || stdout.startsWith("Created") && (stdout.endsWith(".png") || stdout.endsWith(".dat")))) {
            presults = new JPanel(new BorderLayout());
            pscroll = new ScrollPanel(new BorderLayout());
            rscroll = new JScrollPane(pscroll);
            rscroll.getViewport().setBackground(Color.white);
            presults.add((Component)rscroll, "Center");
            JTextPane atext = new JTextPane();
            atext.setText(stdout);
            atext.setFont(new Font("monospaced", 0, 12));
            pscroll.add((Component)atext, "Center");
            atext.setCaretPosition(0);
            fresults.add(this.applName + " output", presults);
            hashRes.put(this.applName + " output", stdout);
        }
        boolean seenGraphs = false;
        for (int j = 0; j < this.numofFields; ++j) {
            presults = new JPanel(new BorderLayout());
            pscroll = new ScrollPanel(new BorderLayout());
            rscroll = new JScrollPane(pscroll);
            rscroll.getViewport().setBackground(Color.white);
            presults.add((Component)rscroll, "Center");
            if (this.parseAcd.isOutputSequence(j) || this.parseAcd.isOutputFile(j)) {
                try {
                    String name = null;
                    name = this.parseAcd.isOutputSequence(j) ? this.seqoutResult : this.outfileResult;
                    StringBuffer text = new StringBuffer();
                    BufferedReader in = new BufferedReader(new FileReader(name));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        text = text.append(line + "\n");
                    }
                    in.close();
                    String txt = text.toString();
                    JTextPane seqText = new JTextPane();
                    seqText.setText(txt);
                    seqText.setFont(new Font("monospaced", 0, 12));
                    pscroll.add((Component)seqText, "Center");
                    seqText.setCaretPosition(0);
                    fresults.add(name, presults);
                    hashRes.put(name, txt);
                }
                catch (IOException ioe) {
                    if (!this.mysettings.getDebug()) continue;
                    System.out.println("Failed to open sequence file " + this.seqoutResult);
                }
                continue;
            }
            if (!this.parseAcd.isOutputGraph(j) || seenGraphs) continue;
            seenGraphs = true;
            File cwdFile = new File(this.cwd);
            String[] pngFiles = cwdFile.list(new FilenameFilter(){

                public boolean accept(File cwd, String name) {
                    if (name.endsWith(".png") || name.endsWith(".dat")) {
                        return name.startsWith(BuildJembossForm.this.applName);
                    }
                    return false;
                }
            });
            Arrays.sort(pngFiles, new NameComparator());
            for (int i = 0; i < pngFiles.length; ++i) {
                if (pngFiles[i].endsWith(".dat")) {
                    Graph2DPlot gp = new Graph2DPlot();
                    rscroll = new JScrollPane(gp);
                    rscroll.getViewport().setBackground(Color.white);
                    gp.setFileData(new String(this.getLocalFile(new File(pngFiles[i]))), pngFiles[i]);
                    fresults.add(pngFiles[i], rscroll);
                    continue;
                }
                presults = new JPanel(new BorderLayout());
                pscroll = new ScrollPanel(new BorderLayout());
                rscroll = new JScrollPane(pscroll);
                rscroll.getViewport().setBackground(Color.white);
                presults.add((Component)rscroll, "Center");
                byte[] pngContents = this.getLocalFile(new File(pngFiles[i]));
                ImageIcon icon = new ImageIcon(pngContents);
                JLabel picture = new JLabel(icon);
                pscroll.add(picture);
                fresults.add(pngFiles[i], presults);
                hashRes.put(pngFiles[i], pngContents);
            }
        }
        final ResultsMenuBar menubar = new ResultsMenuBar(res, fresults, hashRes, this.mysettings);
        fresults.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                BuildJembossForm.this.setJMenuBar(fresults, res, menubar);
            }
        });
        this.setJMenuBar(fresults, res, menubar);
        res.setVisible(true);
    }

    private void setJMenuBar(JTabbedPane fresults, JFrame res, ResultsMenuBar menuBar) {
        int index = fresults.getSelectedIndex();
        String title = fresults.getTitleAt(index);
        if (title.endsWith(".dat")) {
            Graph2DPlot graph = this.getGraph2DPlot((JScrollPane)fresults.getSelectedComponent());
            if (graph == null) {
                return;
            }
            JMenuBar graphMenuBar = graph.getMenuBar(false, res);
            res.setJMenuBar(graphMenuBar);
        } else {
            res.setJMenuBar(menuBar);
        }
    }

    private Graph2DPlot getGraph2DPlot(JScrollPane jsp) {
        Component comp = jsp.getViewport().getView();
        if (comp instanceof Graph2DPlot) {
            return (Graph2DPlot)comp;
        }
        return null;
    }

    private String addQuote(String l) {
        int n = l.indexOf(" ");
        if (n > -1) {
            l = "\"" + l + "\"";
        }
        return l;
    }

    private String checkParameters(ParseAcd parseAcd, int numofFields, Hashtable filesToMove, List optionsA) {
        String options = "";
        this.seqoutResult = "";
        this.outfileResult = "";
        for (int j = 0; j < numofFields; ++j) {
            int[] sel;
            String att = parseAcd.getParameterAttribute(j, 0).toLowerCase();
            String val = parseAcd.getParamValueStr(j, 0).toLowerCase();
            int h = parseAcd.getGuiHandleNumber(j);
            if (!att.startsWith("appl") && parseAcd.isOutputGraph(j)) {
                if (this.graphics == null) {
                    System.out.println("graphics is NULL");
                }
                optionsA.add("-" + val);
                if (((String)this.graphics.getSelectedItem()).equals("PNG")) {
                    options = options.concat(" -" + val + " png");
                    optionsA.add("png");
                } else if (((String)this.graphics.getSelectedItem()).equals("PDF")) {
                    options = options.concat(" -" + val + " pdf");
                    optionsA.add("pdf");
                } else if (((String)this.graphics.getSelectedItem()).equals("SVG")) {
                    options = options.concat(" -" + val + " svg");
                    optionsA.add("svg");
                } else {
                    options = options.concat(" -" + val + " data");
                    optionsA.add("data");
                }
            }
            if (att.startsWith("dirlist") || att.startsWith("featout") || att.startsWith("string") || att.startsWith("seqout") || att.startsWith("outfile") || att.startsWith("codon") || att.startsWith("regexp")) {
                if (!this.textf[h].getText().equals("") && this.textf[h].isVisible() && this.textf[h].isEnabled()) {
                    options = options.concat(" -" + val + " \"" + this.textf[h].getText()) + "\"";
                    optionsA.add("-" + val);
                    optionsA.add(this.textf[h].getText());
                    if (att.startsWith("seqout")) {
                        this.seqoutResult = this.textf[h].getText();
                    } else if (att.startsWith("outfile")) {
                        this.outfileResult = this.textf[h].getText();
                    }
                } else if (!this.withSoap && this.applName.equals("emma") && att.startsWith("seqoutset")) {
                    options = options.concat(" -" + val + " emma.aln ");
                    optionsA.add("-" + val);
                    optionsA.add("emma.aln");
                    this.seqoutResult = "emma.aln";
                }
                if (!att.startsWith("seqout") || outSeqAttr.getOuputSeqAttr().length() <= 0) continue;
                options = options.concat(outSeqAttr.getOuputSeqAttr());
                optionsA.addAll(outSeqAttr.getOuputSeqAttrA());
                continue;
            }
            if (att.startsWith("pattern")) {
                JTextField[] textFields = this.multiTextField[h].getJTextField();
                if (textFields[0].getText() != null && !textFields[0].getText().trim().equals("")) {
                    options = options.concat(" -" + val + " \"" + textFields[0].getText() + "\"");
                    optionsA.add("-" + val);
                    optionsA.add(textFields[0].getText());
                }
                if (textFields[1].getText() == null || textFields[1].getText().trim().equals("")) continue;
                options = options.concat(" -pmismatch " + textFields[1].getText());
                optionsA.add("-pmismatch");
                optionsA.add(textFields[1].getText());
                continue;
            }
            if (att.startsWith("int")) {
                if (this.textInt[h].getText() == null || this.textInt[h].getText().length() <= 0 || !this.textInt[h].isVisible() || !this.textInt[h].isEnabled()) continue;
                options = options.concat(" -" + val + " " + this.textInt[h].getValue());
                optionsA.add("-" + val);
                optionsA.add(Integer.toString(this.textInt[h].getValue()));
                continue;
            }
            if (att.startsWith("float")) {
                if (this.textFloat[h].getText() == null || this.textFloat[h].getText().length() <= 0 || !this.textFloat[h].isVisible() || !this.textFloat[h].isEnabled()) continue;
                options = options.concat(" -" + val + " " + this.textFloat[h].getValue());
                optionsA.add("-" + val);
                optionsA.add(Double.toString(this.textFloat[h].getValue()));
                continue;
            }
            if (att.startsWith("select")) {
                double max = 1.0;
                if (parseAcd.isMaxParamValue(j)) {
                    max = Double.parseDouble(parseAcd.getMaxParam(j));
                }
                if (max > 1.0 && this.multiOption[h].isVisible() && this.multiOption[h].isEnabled()) {
                    sel = this.multiOption[h].getSelectedIndices();
                    options = options.concat(" -" + val + " ");
                    optionsA.add("-" + val);
                    String l = "";
                    for (int i = 0; i < sel.length; ++i) {
                        options = options.concat(Integer.toString(sel[i] + 1));
                        l = l + Integer.toString(sel[i] + 1);
                        if (i >= sel.length - 1) continue;
                        options = options.concat(",");
                        l = l + ",";
                    }
                    optionsA.add(l);
                    continue;
                }
                if (!this.fieldOption[h].isVisible() || !this.fieldOption[h].isEnabled()) continue;
                options = options.concat(" -" + val + " " + (this.fieldOption[h].getSelectedIndex() + 1));
                optionsA.add("-" + val);
                optionsA.add(Integer.toString(this.fieldOption[h].getSelectedIndex() + 1));
                continue;
            }
            if (att.startsWith("list")) {
                double max = 1.0;
                if (parseAcd.isMaxParamValue(j)) {
                    max = Double.parseDouble(parseAcd.getMaxParam(j));
                }
                if (max > 1.0 && this.multiOption[h].isVisible() && this.multiOption[h].isEnabled()) {
                    sel = this.multiOption[h].getSelectedIndices();
                    options = options.concat(" -" + val + " ");
                    optionsA.add("-" + val);
                    String lval = "";
                    for (int i = 0; i < sel.length; ++i) {
                        options = options.concat(parseAcd.getListLabel(j, sel[i]));
                        lval = lval + parseAcd.getListLabel(j, sel[i]);
                        if (i >= sel.length - 1) continue;
                        options = options.concat(",");
                        lval = lval + ",";
                    }
                    optionsA.add(lval);
                    continue;
                }
                if (!this.fieldOption[h].isVisible() || !this.fieldOption[h].isEnabled()) continue;
                int index = this.fieldOption[h].getSelectedIndex();
                options = options.concat(" -" + val + " " + parseAcd.getListLabel(j, index));
                optionsA.add("-" + val);
                optionsA.add(parseAcd.getListLabel(j, index));
                continue;
            }
            if (att.startsWith("report")) {
                options = options.concat(this.rf.getReportFormat());
                optionsA.addAll(this.rf.getReportFormatA());
                continue;
            }
            if (att.startsWith("align")) {
                options = options.concat(this.af.getAlignFormat());
                optionsA.addAll(this.af.getAlignFormatA());
                continue;
            }
            if (att.startsWith("bool") && this.checkBox[h].isVisible() && this.checkBox[h].isEnabled()) {
                if (this.checkBox[h].isSelected()) {
                    options = options.concat(" -" + val + " ");
                    optionsA.add("-" + val);
                    continue;
                }
                options = options.concat(" -no" + val + " ");
                optionsA.add("-no" + val);
                continue;
            }
            if (att.startsWith("range") && this.rangeField[h].isVisible() && this.rangeField[h].isEnabled()) {
                int blank;
                if (this.rangeField[h].getText().equals("")) continue;
                String rangeText = this.rangeField[h].getText();
                while ((blank = rangeText.indexOf(" ")) > -1) {
                    String rangePrefix = rangeText.substring(0, blank);
                    String rangeSuffix = rangeText.substring(blank + 1, rangeText.length());
                    rangeText = rangePrefix.concat(rangeSuffix);
                }
                options = options.concat(" -" + val + " " + rangeText + " ");
                optionsA.add("-" + val);
                optionsA.add(rangeText);
                continue;
            }
            if (att.startsWith("infile") || att.startsWith("datafile") || att.startsWith("matrix")) {
                if (this.textf[h].getText().equals("") || !this.textf[h].isVisible() || !this.textf[h].isEnabled()) continue;
                if (this.withSoap) {
                    options = this.filesForSoap(this.textf[h].getText(), options, val, filesToMove);
                    continue;
                }
                options = options.concat(" -" + val + " " + this.textf[h].getText());
                optionsA.add("-" + val);
                optionsA.add(this.textf[h].getText());
                continue;
            }
            if (att.startsWith("filelist")) {
                if (this.withSoap) {
                    String fns = this.filelist[h].getListFile();
                    String ls = System.getProperty("line.separator");
                    options = this.filesForSoap("internalList::internalList" + ls + fns, options, val, filesToMove);
                    continue;
                }
                String[] fl = this.filelist[h].getArrayListFile();
                String flist = fl[0];
                for (int i = 1; i < fl.length; ++i) {
                    flist = flist.concat("," + fl[i]);
                }
                options = options.concat(" -" + val + " " + flist);
                optionsA.add("-" + val);
                optionsA.add(flist);
                continue;
            }
            if (!att.startsWith("seqset") && !att.startsWith("seqall") && !att.startsWith("sequence")) continue;
            int seq = h + 1;
            if (this.inSeq[h].isFileName()) {
                String fn = new String(this.inSeq[h].getFileChosen());
                if ((fn = fn.trim()).indexOf(":") > -1 && fn.indexOf(":\\") < 0) {
                    int n;
                    while ((n = fn.indexOf(" ")) > -1) {
                        fn = new String(fn.substring(0, n) + fn.substring(n + 1));
                    }
                }
                optionsA.add("-" + val);
                optionsA.add(fn);
                if (this.withSoap) {
                    options = this.filesForSoap(fn, options, val, filesToMove);
                } else {
                    fn = this.addQuote(fn);
                    options = options.concat(" -" + val + " " + fn);
                }
                if (fn.endsWith(":") || fn.endsWith(":*")) {
                    String ls = PlafMacros.getLineSeparator();
                    int n = JOptionPane.showConfirmDialog(this.f, "Do you really want to extract" + ls + "the whole of " + fn + " database?", "Confirm the sequence entry", 0);
                    if (n == 1) {
                        options = "NOT OK";
                        break;
                    }
                }
            } else if (this.inSeq[h].isListFile()) {
                String fns = this.inSeq[h].getListFile();
                String ls = System.getProperty("line.separator");
                if (this.withSoap) {
                    options = this.filesForSoap("internalList::internalList" + ls + fns, options, val, filesToMove);
                } else {
                    String fna = System.getProperty("user.dir") + System.getProperty("file.separator") + "seq.list";
                    this.inSeq[h].writeListFile(fna);
                    options = options.concat(" -" + val + " list::" + fna);
                    optionsA.add("-" + val);
                    optionsA.add("list::" + fna);
                }
            } else {
                String cp = this.inSeq[h].getCutNPasteText();
                String fn = new String(this.applName + new Integer(h).toString());
                if (this.withSoap) {
                    MakeFileSafe sf = new MakeFileSafe(fn);
                    String sfn = sf.getSafeFileName();
                    filesToMove.put(sfn, cp.getBytes());
                    options = options.concat(" -" + val + " " + sfn);
                } else {
                    String tmp = null;
                    try {
                        File tf;
                        try {
                            tmp = JembossParams.isCygwin() ? JembossParams.getCygwinRoot() + System.getProperty("file.separator") + "tmp" : System.getProperty("java.io.tmpdir");
                            tf = File.createTempFile(fn, ".jembosstmp", new File(tmp));
                        }
                        catch (IOException ioe) {
                            tf = File.createTempFile(fn, ".jembosstmp", new File(this.cwd));
                        }
                        PrintWriter out = new PrintWriter(new FileWriter(tf));
                        out.println(cp);
                        out.close();
                        fn = tf.getCanonicalPath();
                        fn = this.addQuote(fn);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(null, "Cannot write to\n" + tmp + "\n" + "or\n" + this.cwd, "Problem creating a temporary file!", 0);
                    }
                    options = options.concat(" -" + val + " " + fn);
                    optionsA.add("-" + val);
                    optionsA.add(fn);
                }
            }
            options = options.concat(this.inSeqAttr[h].getInputSeqAttr(seq));
            optionsA.addAll(this.inSeqAttr[h].getInputSeqAttrA(seq));
        }
        return options;
    }

    private String filesForSoap(String fn, String options, String val, Hashtable filesToMove) {
        if (fn.startsWith("@") || fn.startsWith("list::") || fn.startsWith("internalList::")) {
            String lfn = "";
            if (fn.startsWith("@")) {
                lfn = fn.substring(1);
            } else if (fn.startsWith("list::")) {
                lfn = fn.substring(6);
            }
            File inFile = new File(lfn);
            if (inFile.exists() && inFile.canRead() && inFile.isFile() || fn.startsWith("internalList::")) {
                ListFile.parse(fn, filesToMove);
                if (fn.startsWith("internalList::")) {
                    options = options.concat(" -" + val + " list::internalList");
                } else {
                    MakeFileSafe sf = new MakeFileSafe(lfn);
                    String sfs = sf.getSafeFileName();
                    options = options.concat(" -" + val + " list::" + sfs);
                }
            } else {
                options = options.concat(" -" + val + " list::" + lfn);
            }
            String sfn = lfn;
        } else {
            MakeFileSafe sf = new MakeFileSafe(fn);
            String sfn = sf.getSafeFileName();
            File inFile = new File(fn);
            if (inFile.exists() && inFile.canRead() && inFile.isFile()) {
                filesToMove.put(sfn, this.getLocalFile(inFile));
                options = options.concat(" -" + val + " " + sfn);
            } else {
                options = options.concat(" -" + val + " " + fn);
            }
        }
        return options;
    }

    private byte[] getLocalFile(File name) {
        byte[] b = null;
        try {
            long s = name.length();
            b = new byte[(int)s];
            FileInputStream fi = new FileInputStream(name);
            fi.read(b);
            fi.close();
        }
        catch (IOException ioe) {
            System.out.println("Cannot read file: " + name);
        }
        return b;
    }

    private String getCommand(Hashtable filesToMove, List commandA) {
        String command = this.applName;
        commandA.add(command);
        int numofFields = this.parseAcd.getNumofFields();
        String options = this.checkParameters(this.parseAcd, numofFields, filesToMove, commandA);
        if (options.equals("NOT OK")) {
            command = "NOT OK";
        } else {
            for (int i = 0; i < commandA.size(); ++i) {
                String s = (String)commandA.get(i);
                if (!s.equals("stdout")) continue;
                commandA.set(i, "stdoutfile");
            }
            command = command.concat(options.replaceAll("\"stdout\"", "stdoutfile") + " -auto");
            commandA.add("-auto");
        }
        return command;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    static {
        fs = System.getProperty("file.separator");
        prfs = Preferences.userNodeForPackage(BuildJembossForm.class);
    }

    public class NameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int obj2;
            int obj1 = this.findInt((String)o1);
            if (obj1 < (obj2 = this.findInt((String)o2))) {
                return -1;
            }
            if (obj1 > obj2) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return ((Object)this).equals(obj);
        }

        private int findInt(String exp) {
            RECompiler rec = new RECompiler();
            try {
                REProgram rep = rec.compile("^(.*?)([:digit:]+)");
                RE regexp = new RE(rep);
                if (regexp.match(exp)) {
                    int ia = new Integer(regexp.getParen(2));
                    return ia;
                }
            }
            catch (RESyntaxException rese) {
                System.out.println("RESyntaxException ");
            }
            return -1;
        }
    }

    public class BatchSoapProcess
    extends Thread {
        private String embossCommand;
        List command;
        private Hashtable filesToMove;
        private JembossParams mysettings;
        private boolean withSoap = true;

        public BatchSoapProcess(String embossCommand, Hashtable filesToMove, JembossParams mysettings, List command) {
            this.embossCommand = embossCommand;
            this.filesToMove = filesToMove;
            this.mysettings = mysettings;
            this.command = command;
        }

        public void setWithSoap(boolean withSoap) {
            this.withSoap = withSoap;
        }

        public void run() {
            try {
                JembossProcess er;
                JFrame fsend = new JFrame("job submission");
                JProgressBar progressBar = new JProgressBar();
                progressBar.setStringPainted(true);
                progressBar.setString("Starting your job in asynchronous mode...");
                progressBar.setBackground(Color.white);
                progressBar.setIndeterminate(true);
                fsend.getContentPane().add(progressBar);
                fsend.pack();
                Dimension d = BuildJembossForm.this.f.getToolkit().getScreenSize();
                fsend.setLocation((int)(d.getWidth() - (double)fsend.getWidth()) / 2, (int)(d.getHeight() - (double)fsend.getHeight()) / 2);
                fsend.setVisible(true);
                if (this.withSoap) {
                    JembossRun thisrun = this.mysettings.getUseAuth() ? new JembossRun(this.embossCommand, "", this.filesToMove, this.mysettings) : new JembossRun(this.command, "", this.filesToMove, this.mysettings);
                    er = new JembossProcess((String)thisrun.get("jobid"));
                } else {
                    JembossServer js = new JembossServer(this.mysettings.getResultsHome());
                    Vector filesToMovev = new Vector();
                    Vector result = js.run_prog_array(new Vector(this.command), this.mysettings.getCurrentMode(), filesToMovev, "");
                    Hashtable resultHash = BuildJembossForm.convert(result, false);
                    er = new JembossProcess((String)resultHash.get("jobid"));
                }
                Jemboss.resultsManager.addResult(er);
                Jemboss.resultsManager.updateStatus();
                if (!Jemboss.resultsManager.isAutoUpdate()) {
                    Jemboss.resultsManager.setAutoUpdate(true);
                    String freq = (String)AdvancedOptions.jobMgr.getSelectedItem();
                    int ind = freq.indexOf(" ");
                    new BatchUpdateTimer(Integer.parseInt(freq.substring(0, ind)));
                }
                fsend.setVisible(false);
                fsend.dispose();
            }
            catch (JembossSoapException eae) {
                AuthPopup ap = new AuthPopup(this.mysettings, BuildJembossForm.this.f);
                ap.setBottomPanel();
                ap.setSize(380, 170);
                ap.pack();
                ap.setVisible(true);
                BuildJembossForm.this.f.setCursor(BuildJembossForm.this.cdone);
            }
        }
    }
}

