/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SequenceGroup;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ScalePanel
extends Panel
implements MouseMotionListener,
MouseListener {
    protected int offy = 4;
    public int width;
    protected AlignViewport av;
    AlignmentPanel ap;
    boolean stretchingGroup = false;
    int min;
    int max;
    boolean mouseDragging = false;
    int[] reveal;

    public ScalePanel(AlignViewport av, AlignmentPanel ap) {
        this.setLayout(null);
        this.av = av;
        this.ap = ap;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent evt) {
        int x = evt.getX() / this.av.getCharWidth() + this.av.getStartRes();
        final int res = this.av.hasHiddenColumns ? this.av.getColumnSelection().adjustForHiddenColumns(x) : x;
        this.min = res;
        this.max = res;
        if ((evt.getModifiers() & 4) == 4) {
            PopupMenu pop = new PopupMenu();
            if (this.reveal != null) {
                MenuItem item = new MenuItem("Reveal");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ScalePanel.this.av.showColumn(ScalePanel.this.reveal[0]);
                        ScalePanel.this.reveal = null;
                        ScalePanel.this.ap.paintAlignment(true);
                        if (ScalePanel.this.ap.overviewPanel != null) {
                            ScalePanel.this.ap.overviewPanel.updateOverviewImage();
                        }
                    }
                });
                pop.add(item);
                if (this.av.getColumnSelection().getHiddenColumns().size() > 1) {
                    item = new MenuItem("Reveal All");
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ScalePanel.this.av.showAllHiddenColumns();
                            ScalePanel.this.reveal = null;
                            ScalePanel.this.ap.paintAlignment(true);
                            if (ScalePanel.this.ap.overviewPanel != null) {
                                ScalePanel.this.ap.overviewPanel.updateOverviewImage();
                            }
                        }
                    });
                    pop.add(item);
                }
                this.add(pop);
                pop.show(this, evt.getX(), evt.getY());
            } else if (this.av.getColumnSelection().contains(res)) {
                MenuItem item = new MenuItem("Hide Columns");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ScalePanel.this.av.hideColumns(res, res);
                        if (ScalePanel.this.av.getSelectionGroup() != null && ScalePanel.this.av.getSelectionGroup().getSize() == ScalePanel.this.av.alignment.getHeight()) {
                            ScalePanel.this.av.setSelectionGroup(null);
                        }
                        ScalePanel.this.ap.paintAlignment(true);
                        if (ScalePanel.this.ap.overviewPanel != null) {
                            ScalePanel.this.ap.overviewPanel.updateOverviewImage();
                        }
                    }
                });
                pop.add(item);
                this.add(pop);
                pop.show(this, evt.getX(), evt.getY());
            }
        } else {
            if (!evt.isControlDown() && !evt.isShiftDown()) {
                this.av.getColumnSelection().clear();
            }
            this.av.getColumnSelection().addElement(res);
            SequenceGroup sg = new SequenceGroup();
            for (int i = 0; i < this.av.alignment.getSequences().size(); ++i) {
                sg.addSequence(this.av.alignment.getSequenceAt(i), false);
            }
            sg.setStartRes(res);
            sg.setEndRes(res);
            this.av.setSelectionGroup(sg);
            if (evt.isShiftDown()) {
                int min = Math.min(this.av.getColumnSelection().getMin(), res);
                int max = Math.max(this.av.getColumnSelection().getMax(), res);
                for (int i = min; i < max; ++i) {
                    this.av.getColumnSelection().addElement(i);
                }
                sg.setStartRes(min);
                sg.setEndRes(max);
            }
        }
        this.ap.paintAlignment(true);
    }

    public void mouseReleased(MouseEvent evt) {
        this.mouseDragging = false;
        int res = evt.getX() / this.av.getCharWidth() + this.av.getStartRes();
        if (res > this.av.alignment.getWidth()) {
            res = this.av.alignment.getWidth() - 1;
        }
        if (this.av.hasHiddenColumns) {
            res = this.av.getColumnSelection().adjustForHiddenColumns(res);
        }
        if (!this.stretchingGroup) {
            this.ap.paintAlignment(false);
            return;
        }
        SequenceGroup sg = this.av.getSelectionGroup();
        if (res > sg.getStartRes()) {
            sg.setEndRes(res);
        } else if (res < sg.getStartRes()) {
            sg.setStartRes(res);
        }
        this.stretchingGroup = false;
        this.ap.paintAlignment(false);
    }

    public void mouseDragged(MouseEvent evt) {
        SequenceGroup sg;
        this.mouseDragging = true;
        int res = evt.getX() / this.av.getCharWidth() + this.av.getStartRes();
        if (res < 0) {
            res = 0;
        }
        if (this.av.hasHiddenColumns) {
            res = this.av.getColumnSelection().adjustForHiddenColumns(res);
        }
        if (res > this.av.alignment.getWidth()) {
            res = this.av.alignment.getWidth() - 1;
        }
        if (res < this.min) {
            this.min = res;
        }
        if (res > this.max) {
            this.max = res;
        }
        if ((sg = this.av.getSelectionGroup()) != null) {
            this.stretchingGroup = true;
            if (!this.av.getColumnSelection().contains(res)) {
                this.av.getColumnSelection().addElement(res);
            }
            if (res > sg.getStartRes()) {
                sg.setEndRes(res);
            }
            if (res < sg.getStartRes()) {
                sg.setStartRes(res);
            }
            for (int i = this.min; i <= this.max; ++i) {
                int col = this.av.getColumnSelection().adjustForHiddenColumns(i);
                if (col < sg.getStartRes() || col > sg.getEndRes()) {
                    this.av.getColumnSelection().removeElement(col);
                    continue;
                }
                this.av.getColumnSelection().addElement(col);
            }
            this.ap.paintAlignment(false);
        }
    }

    public void mouseEntered(MouseEvent evt) {
        if (this.mouseDragging) {
            this.ap.seqPanel.scrollCanvas(null);
        }
    }

    public void mouseExited(MouseEvent evt) {
        if (this.mouseDragging) {
            this.ap.seqPanel.scrollCanvas(evt);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
        if (!this.av.hasHiddenColumns) {
            return;
        }
        int res = evt.getX() / this.av.getCharWidth() + this.av.getStartRes();
        res = this.av.getColumnSelection().adjustForHiddenColumns(res);
        this.reveal = null;
        for (int i = 0; i < this.av.getColumnSelection().getHiddenColumns().size(); ++i) {
            int[] region = (int[])this.av.getColumnSelection().getHiddenColumns().elementAt(i);
            if (res + 1 != region[0] && res - 1 != region[1]) continue;
            this.reveal = region;
            break;
        }
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.drawScale(g, this.av.getStartRes(), this.av.getEndRes(), this.getSize().width, this.getSize().height);
    }

    public void drawScale(Graphics gg, int startx, int endx, int width, int height) {
        gg.setFont(this.av.getFont());
        gg.setColor(Color.white);
        gg.fillRect(0, 0, width, height);
        gg.setColor(Color.black);
        ColumnSelection cs = this.av.getColumnSelection();
        gg.setColor(new Color(220, 0, 0));
        for (int i = 0; i < cs.size(); ++i) {
            int sel = cs.columnAt(i);
            if (this.av.hasHiddenColumns) {
                sel = this.av.getColumnSelection().findColumnPosition(sel);
            }
            if (sel < startx || sel > endx) continue;
            gg.fillRect((sel - startx) * this.av.charWidth, 0, this.av.charWidth, this.getSize().height);
        }
        gg.setColor(Color.black);
        int scalestartx = startx / 10 * 10;
        FontMetrics fm = gg.getFontMetrics(this.av.getFont());
        int y = this.av.charHeight - fm.getDescent();
        if (scalestartx % 10 == 0) {
            scalestartx += 5;
        }
        int maxX = 0;
        for (int i = scalestartx; i < endx; i += 5) {
            if (i % 10 == 0) {
                String string = String.valueOf(this.av.getColumnSelection().adjustForHiddenColumns(i));
                if ((i - startx - 1) * this.av.charWidth > maxX) {
                    gg.drawString(string, (i - startx - 1) * this.av.charWidth, y);
                    maxX = (i - startx + 1) * this.av.charWidth + fm.stringWidth(string);
                }
                gg.drawLine((i - startx - 1) * this.av.charWidth + this.av.charWidth / 2, y + 2, (i - startx - 1) * this.av.charWidth + this.av.charWidth / 2, y + fm.getDescent() * 2);
                continue;
            }
            gg.drawLine((i - startx - 1) * this.av.charWidth + this.av.charWidth / 2, y + fm.getDescent(), (i - startx - 1) * this.av.charWidth + this.av.charWidth / 2, y + fm.getDescent() * 2);
        }
        if (this.av.hasHiddenColumns) {
            gg.setColor(Color.blue);
            if (this.av.getShowHiddenMarkers()) {
                for (int i = 0; i < this.av.getColumnSelection().getHiddenColumns().size(); ++i) {
                    int res = this.av.getColumnSelection().findHiddenRegionPosition(i) - startx;
                    if (res < 0 || res > endx - scalestartx) continue;
                    gg.fillPolygon(new int[]{res * this.av.charWidth - this.av.charHeight / 4, res * this.av.charWidth + this.av.charHeight / 4, res * this.av.charWidth}, new int[]{y - this.av.charHeight / 2, y - this.av.charHeight / 2, y + 8}, 3);
                }
            }
            if (this.reveal != null && this.reveal[0] > startx && this.reveal[0] < endx) {
                gg.drawString("Reveal Columns", this.reveal[0] * this.av.charWidth, 0);
            }
        }
    }
}

