# btsutils -- Python module to interact with debbugs servers.
# Copyright (C) 2007  Gustavo R. Montesino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os

import BugExceptions
from html import html
from soap import soap

class debbugs:

    def __init__(self, users=[]):
        self.soap = soap(users=users)
        self.html = html(users=users)

    def setUsers(self, users=[]):
        """Sets the BTS users

        Receives a list of user email addresses. The users are used
        to retrieve usertags."""

        self.soap.setUsers(users)
        self.html.setUsers(users)

    def get(self, bugnumber):
        """Query the debbugs server for a given bug
    
        Return a Bug instance with the bug data.
        """
    
        try:
            return self.soap.get(bugnumber)
        except:
            return self.html.get(bugnumber) 

    def query(self, btsquery):
        """Query the debbugs server with the given query

        Return a list of Bug instances with the bugs which match the
        query string."""
    
        try:
            return self.soap.query(btsquery)
        except:
            return self.html.query(btsquery)

    def forward(self, bug, address):
        """Mark a bug as forwarded"""

        pid = os.fork()
        if pid == 0:
            os.execlp("bts", "bts", "forward", str(bug), address)

    def tag(self, bug, op, tag):
        """Set a tag on a bug report"""

        if not op in ["+", "-", "="]:
            raise BugExceptions.InvalidBugTagError("Invalid bug tag operator: %s" % op)

        if os.spawnlp(os.P_WAIT, "bts", "bts", bug.getBug(), "tag", op, tag) != 0:
            raise BugExceptions.InvalidBugTagError("Couldn't tag %s" % bug.getBug())

# vim: tabstop=4 expandtab shiftwidth=4
