
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvsroot/aolserver/aolserver/doc/ns_adp_include.n,v 1.1 2006/04/13 19:07:12 jgdavidson Exp $
'\"
'\" 
.so man.macros
.TH ns_adp_include n 4.5 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_adp_argc, ns_adp_argv, ns_adp_bind_args, ns_adp_dir, ns_adp_eval, ns_adp_ident, ns_adp_include, ns_adp_parse, ns_adp_safeeval \- ADP execution commands
.SH SYNOPSIS
.nf
\fBns_adp_argc\fR
\fBns_adp_argv\fR ?\fIindex\fR?
\fBns_adp_bind_args\fR \fIvar1\fR ?\fIvar2...\fR?
\fBns_adp_dir\fR
\fBns_adp_eval\fR \fIpage\fR ?\fIarg ...\fR?
\fBns_adp_ident\fR ?\fIstring\fR?
\fBns_adp_include\fR ?\fI-cache seconds\fR? ?\fI-nocache\fR? \fIfile \fR?\fIarg ...\fR?
\fBns_adp_parse ?\fI-file file\fR? ?\fI-string string\fR? ?\fI-savedresult varName\fR? ?\fI-cwd path\fR? ?\fIargs ... \fR?
\fBns_adp_safeeval\fR \fIpage\fR ?\fIarg ...\fR?
.fi
.BE

.SH DESCRIPTION
.PP
These commands enable execution of ADP files or strings.  Each call
to \fBns_adp_include\fR results in a new ADP "call frame" similar
to a Tcl procedure with local variable scope.  Variables may be
passed to these call frames as optional arguements and then accessed
via the \fBns_adp_argc\fR, \fBns_adp_argv\fR, and \fBns_adp_bind_args\fR
commands.  The \fBns_adp_eval\fR, \fBns_adp_safeeval\fR, or
\fRns_adp_parse\fR can also accept arguments via the same mechanism
but execute in the same ADP call frame as their parent, i.e., with
the same local variables.  See the \fBns_adp\fR page for details
on ADP syntax and control flow.

.TP
\fBns_adp_argc\fR
This command returns the number of optional arguments passed to the
ADP.  The count includes the argument for the ADP file or string.

.TP
\fBns_adp_argv\fR ?\fIindex ?default?\fR?
This command returns the list of arguments passed to the ADP.  If
the optional \fIindex\fR argument is specified, only the given
argument is returned instead of the full list.  If the optional
\fIdefault\fR argument is specified along with an \fIindex\fR
argument, it serves as the value to return if the cooresponding
index was not passed to the call frame.

.TP
\fBns_adp_bind_args\fR \fIvar1\fR ?\fIvar2...\fR?
This command can be used to set multiple optional ADP arguments to
a list of local variables.  Argument binding begins with argument
number 1, i.e., the first argument beyond the ADP file or script.

.TP
\fBns_adp_dir\fR
This command returns the directory in which the ADP currently being
processed resides and which relative ADP files will be found.

.TP
\fBns_adp_eval\fR \fIpage\fR ?\fIarg ...\fR?
This command evaluates the ADP specified by \fIpage\fR and returns
the output as the result. If any arguments are specified, they will
be passed to the ADP.

.TP
\fBns_adp_ident\fR ?\fIstring\fR?
This command returns and/or sets an arbitrary version management
string for the given ADP file.  It could be used to specify a header
replaced via a CVS/RCS checkin:
.CS
<% ns_adp_ident {$Header: /cvsroot/aolserver/aolserver/doc/ns_adp_include.n,v 1.1 2006/04/13 19:07:12 jgdavidson Exp $} %>
.CE

.TP
\fBns_adp_include\fR ?\fI-cache seconds\fR? ?\fI-nocache\fR? \fIfile \fR?\fIarg ...\fR?
This command parses the specified file as an ADP, including the
text blocks and any output generated by script blocks in the current
output buffer.  The execution occurs in a new call frame with private
local variables similar to a Tcl procedure.  The \fIfilename\fR is
the file containing the ADP to be parsed.  If the file is not an
absolute filename, the file is considered relative to the current
ADP working directory which is the directory of the previously
included file.  Optional arguments (\fIarg...\fR) can be passed to
the included ADP; see the \fBns_adp_argv\fR command above for details
on accessing the values of these variables.  The optional \fI-cache
seconds\fR argument specifies the time to cache the results of
execution.  All output generated by any scripts and included ADP's
are saved for subsequent requests unless an included ADP has a
\fI-nocache\fR option.  The use of \fI-cache\fR and \fI-nocache\fR
can be used to increase performance of ADP used to generated a mix
of personalized, non-cacheable, content and shared content which
changes more slowly.  Under high load, the performance improvement
can be substaintial, especially in cases where the cached content
is the result of accessing a slow databases or web services.  See
the \fBEXAMPLES\fR section for an example of using cached output.

.TP
\fBns_adp_parse ?\fI-file file\fR? ?\fI-string string\fR? ?\fI-savedresult varName\fR? ?\fI-cwd path\fR? ?\fIargs ... \fR?
This function processes the specified ADP file or string and returns
the result as a string. Processing a second ADP from inside an ADP
is normally best done with \fBns_adp_include\fR as that command
resolves relative pathnames passed to it.  Also note that
\fBns_adp_parse\fR will ignore any directives to turn on streaming.
Tcl_Eval is used to evaluate the Tcl commands in the ADP.
.sp
The \fI-string adp\fR option can be used to parse a string of ADP
text.  Although the \fI<% ... %>\fR syntax is allowed in the string,
if you have this embedded in an ADP, you have to be careful in
constructing the string that you do not prematurely terminate an
enclosing script.
.sp
The \fI-file file\fR option can be used to parse ADP contained in
the given file.  This use is similar to that of \fBns_adp_include\fR
except the result is returned by the command instead of automatically
being appended to the output stream.
.sp
The \fI-global\fR and \fI-local\fR options are deprecated. All calls
are now local to the current ADP call frame such that the \fI-local\fR
option is ignored and the \fI-global\fR option generates an error.
.sp
Additional arguments are passed to the ADP execution and can be
accessed via the \fBns_adp_argc\fR, \fBns_adp_argv\fR, and
\fBns_adp_bind_args\fR commands.

.TP
\fBns_adp_safeeval\fR \fIstring\fR ?\fIarg ...\fR?
The command evaluates the given ADP string in a safe environment
which ignores all cases of \fI<% ... %>\fR and \fI<%= ... %>\fR
commands, only allowing execution of per-defined registered tags.
This usage can be helpful to expose a limited set of dynamic
functionality to publishing staff without exposing the full command
set.

.SH EXAMPLE
The following example demonstrates passing an argument to an included
ADP file:

.CS
<% ns_adp_include included.adp arg1 arg2 arg3 %>
.CE

.PP
The variables could be accessed within \fIincluded.adp\fR with:

.CS
ns_adp_argc
\fI--> return 4\fR
ns_adp_argv 1
\fI--> returns "arg1"\fR
ns_adp_argv 10 MyDefault
\fI--> returns "MyDefault" as there is no 10th argument\fR
.CE

The followiong example demonstrates using the \fI-cache\fR and
\fI-nocache\fR options to the \fBns_adp_include\fR command to enhance
performance through caching execution output.  Given the following
files:

.PP
\fItop.adp:\fR
.CS
<% ns_adp_include -cache 60 cached.adp %>
.CE
.PP
\fIcached.adp:\fR
.CS
<%
ns_adp_puts "Time at cache: [ns_time]"
ns_adp_include -nocache nocache.adp
%>
.CE
.PP
\fInocache.adp:\fR
.RE
.CS
<% ns_adp_puts "Time now: [ns_time]" %>
.CE
.PP
the results of \fIcached.adp\fR will only update once every 60
seconds while the results of \fInocache.adp\fR will be executed on
each request, even though it's included withing \fIcached.adp\fR.

.SH "SEE ALSO"
ns_adp_ctl(1), ns_adp_puts(n), ns_adp_flush(n), ns_adp_close(n)

.SH KEYWORDS
ADP, dynamic pages, execution
