/*
 * This file provides a system independant interface to send and
 * receive ICMP messages.
 */

/* $Id: mod_icmp.h,v 1.3 1999/10/11 05:25:19 fgouget Exp $ */

#ifndef _mod_icmp_h_
#define _mod_icmp_h_

#if defined(__STDC__) || defined(__cplusplus)
#define PROTO(a,b) a b
#else
#define PROTO(a,b) a()
#endif
#ifdef __cplusplus
#define API "C"
#else
#define API
#endif

typedef void* icmp_handle;

/* initialize the ICMP module, return a pointer to it. */
extern icmp_handle PROTO(
   icmp_open,
   (
	void
   ));

/* set a socket option. Returns >= 0 if successful, -1 otherwise */
extern int PROTO(
   icmp_set_option,
   (
	icmp_handle handle,	/* module handle */
	int level,
	int optname,		/* option to be set */
	void *optval,		/* option value */
	int optlen		/* length of option value */
   ));

/* set the timeout for receives */
extern void PROTO(
   icmp_set_timeout,
   (
	icmp_handle handle,
	unsigned long timeout	/* timeout in microseconds */
   ));

/* get the ID used in packets */
extern unsigned short PROTO(
   icmp_get_id,
   (
	icmp_handle handle
   ));

/**
 * Sends an ICMP message.
 * (!!) this will have to be extended to support any kind of message (e.g. UDP)
 *
 * @param handle the icmp handle
 * @param msg points to a buffer containing the message
 *        (!!) what does this contain exactly? the ip options, the icmp header, just the data
 * @param msg_size the message size
 * @param to_addr the address of the host to which the message is to be sent
 * @param to_addr_size the size of the destination host address
 * @return >=0 if successful, -1 otherwise
 */
extern int PROTO(
   icmp_send,
   (
	icmp_handle handle,
	void *msg,
	int msg_size,
	struct sockaddr *to_addr,
	int to_addr_size
   ));

/**
 * Waits for an ICMP message.
 * (!!) in fact this should be any message since we might send UDP messages too
 *
 * @param handle the icmp handle
 * @param buffer must point to a buffer in which the message will be stored. If the 
 *        buffer is too small the function will fail
 *        (!!) what is stored ? just the datsa, the icmp header, the ip header too ?
 * @param buffer_size the size of the allocated buffer. This value is modified to 
 *        store the actual size of the message
 * @param from_addr must point to a buffer in which to store the address of the 
 *        host this message was received from
 * @param from_addr_size the size of the from_addr buffer. On return this contains the 
 *        actual size of the address stored in the buffer.
 * @return >0 if successful, 0 if the function timed out and -1 if it failed
 *         (!!) it said "-1: interrupted, should be called again"
 */
extern int PROTO(
   icmp_recv,
   (
	icmp_handle handle,
	char *buffer,
	int buffer_size,
	struct sockaddr *from_addr,
	int *from_addr_size,
	double *elapsed
   ));

/**
 * Closes the ICMP handle.
 *
 * @return >=0 if successful, -1 otherzise
 */
extern int PROTO(
   icmp_close,
   (
	icmp_handle handle
   ));

#endif	/* End of File */
