#include "cdo_int.h"

int cdoTaxisCreate(int taxisType)
{
  if (CdoDefault::TaxisType != CDI_UNDEFID) taxisType = CdoDefault::TaxisType;
  return taxisCreate(taxisType);
}


void
cdoSetNAN(double missval, size_t gridsize, double *array)
{
  if (DBL_IS_NAN(missval))
    {
      const double newmissval = -9e33;
      for (size_t i = 0; i < gridsize; ++i)
        if (DBL_IS_EQUAL(array[i], missval)) array[i] = newmissval;
    }
}

