#!/bin/sh
#
# Copyright (c) 2008, 2011, 2019  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

[ -z "$CONFGET" ] && CONFGET='./confget'
[ -z "$TESTDIR" ] && TESTDIR='t'

echo '1..15'


if [ ! -f "$TESTDIR/t1.ini" ]; then
        echo "Bail out!  No test file $TESTDIR/t1.ini"
        exit 255
fi
v=`$CONFGET '-c' '-f' "$TESTDIR/t1.ini" '-s' 'a' 'key1' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 1'; else echo "not ok 1 res is '$res'"; fi
v=`$CONFGET '-c' '-f' "$TESTDIR/t1.ini" '-s' 'a' 'key2' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 2'; else echo "not ok 2 res is '$res'"; fi
v=`$CONFGET '-c' '-f' "$TESTDIR/t1.ini" '-s' 'a' 'key3' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 3'; else echo "not ok 3 res is '$res'"; fi
v=`$CONFGET '-c' '-f' "$TESTDIR/t1.ini" '-s' 'a' 'key4' `
res="$?"
if [ "$res" != 0 ]; then echo 'ok 4'; else echo "not ok 4 res is '$res'"; fi
v=`$CONFGET '-c' '-f' "$TESTDIR/t1.ini" '-s' 'b sect' 'key5' `
res="$?"
if [ "$res" != 0 ]; then echo 'ok 5'; else echo "not ok 5 res is '$res'"; fi
v=`$CONFGET '-c' '-f' "$TESTDIR/t1.ini" '-s' 'b sect' 'key4' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 6'; else echo "not ok 6 res is '$res'"; fi
v=`$CONFGET '-c' '-f' "$TESTDIR/t1.ini" '-s' 'c' 'key5' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 7'; else echo "not ok 7 res is '$res'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-c' 'key1' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 8'; else echo "not ok 8 res is '$res'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-c' 'key2' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 9'; else echo "not ok 9 res is '$res'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-c' 'key3' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 10'; else echo "not ok 10 res is '$res'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-c' '-s' 'Q1' 'key4' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 11'; else echo "not ok 11 res is '$res'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-c' '-s' 'Q1' 'key6' `
res="$?"
if [ "$res" = 0 ]; then echo 'ok 12'; else echo "not ok 12 res is '$res'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-c' 'key6' `
res="$?"
if [ "$res" != 0 ]; then echo 'ok 13'; else echo "not ok 13 res is '$res'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-c' '-s' 'Q1' 'key1' `
res="$?"
if [ "$res" != 0 ]; then echo 'ok 14'; else echo "not ok 14 res is '$res'"; fi
v=`env Q1='key4&amp;key5=%09%09%20val%27ue5&key6' Q2='' QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3' $CONFGET -t http_get '-c' '-s' 'Q2' 'key1' `
res="$?"
if [ "$res" != 0 ]; then echo 'ok 15'; else echo "not ok 15 res is '$res'"; fi
