/*
  xmms - DBMix output plugin

   Description: 
   ============
   This program is an output plugin for xmms v0.9 or greater.
   The plugin allows a data stream to be generated using xmms,
   an to be sent to the DBMix sound daemon for 
   Fourier/Additive Synthesis.  This allows a user may output multiple
   audio streams concurrently to the same audio device.
  

   Original Output Plugin code: (C) 1998-1999 Mikael Alm, Olle Hallnas,
                                Thomas Nillson and 4Front Technologies

   Modifications by Robert Michael S Dean, (c) 1999-2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "dbmixout.h"
#include <xmms/configfile.h>

#include <dbchannel.h>
#include <dbaudiolib.h>
#include <gtk/gtk.h>

static GtkWidget *configure_win = NULL;
static GtkWidget *main_box;
static GtkWidget *name_box,*ipc_box,*close_box,*label,*text,*button_box,*ok,*cancel;
static GtkWidget *ipc_frame/* ,*ipc_group,*pipe_radiobutton, *shm_radiobutton*/ ;
#ifdef CLOSE_FLAG
static GtkWidget *close_group,*close_frame,*close_radiobutton, *open_radiobutton;
#endif
static GtkWidget *buffer_size_spin;
static GtkWidget *enable_buffer_button;

extern gint xmms_session_id;
extern gint close_flag;

#ifdef DBMIX_DYNAMIC_LIBRARY
extern DBAudioLibFunctions * dbaudiofxns;
#endif

static gchar channel_name[DB_CHANNEL_NAME_SIZE];

extern DBMixConfig dbmix_cfg;

static void ok_button(GtkWidget * w, gpointer data)
{
	ConfigFile *cfgfile;
	gchar * str1;
	
	str1 = gtk_entry_get_text(GTK_ENTRY(text));

#ifdef DBMIX_DYNAMIC_LIBRARY
	dbaudiofxns->DBAudio_Set_Channel_Name(str1);
#else
	DBAudio_Set_Channel_Name(str1);
#endif


#if CLOSE_FLAG
	if(GTK_TOGGLE_BUTTON(close_radiobutton)->active)
	{
		dbmix_cfg.close_flag = TRUE;
	}
	else
	{
		dbmix_cfg.close_flag = FALSE;
	}
#endif	

	cfgfile = xmms_cfg_open_default_file();

	xmms_cfg_write_int(cfgfile, "DBMIX", "buffer_size", dbmix_cfg.buffer_size);
	xmms_cfg_write_int(cfgfile, "DBMIX", "prebuffer", dbmix_cfg.prebuffer);
	xmms_cfg_write_int(cfgfile, "DBMIX", "buffer_enable", dbmix_cfg.buffer_enable);
#if CLOSE_FLAG
	xmms_cfg_write_int(cfgfile, "DBMIX", "close_flag",dbmix_cfg.close_flag);
#endif
	xmms_cfg_write_string(cfgfile, "DBMIX", "channel_name",dbmix_cfg.channel_name);
	xmms_cfg_write_default_file(cfgfile);

	xmms_cfg_free(cfgfile);

	gtk_widget_destroy(configure_win);
}


void get_value_buffer(GtkAdjustment * adj)
{
	dbmix_cfg.buffer_size = adj->value;
}


void get_value_prebuffer(GtkAdjustment * adj)
{
	dbmix_cfg.prebuffer = adj->value;
}


void enter_callback( GtkWidget *widget, GtkWidget *entry )
{
	strcpy(dbmix_cfg.channel_name,gtk_entry_get_text(GTK_ENTRY(entry)));
}


void enable_buffer_clicked(GtkWidget *widget) 
{ 
    if (GTK_TOGGLE_BUTTON(widget)->active) 
    { 
       dbmix_cfg.buffer_enable = TRUE; 
    } 
    else 
    { 
       dbmix_cfg.buffer_enable = FALSE; 
    } 
    
    /* Grey out the button if needed */ 
    gtk_widget_set_sensitive(GTK_WIDGET(buffer_size_spin),dbmix_cfg.buffer_enable); 
} 

void dbmix_configure(void)
{
	GtkWidget *buffer_frame, *buffer_vbox, *buffer_table;
	GtkWidget *buffer_size_box, *buffer_size_label;
	GtkObject *buffer_size_adj;

	if (!configure_win)
	{ 
		configure_win = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_signal_connect(GTK_OBJECT(configure_win), "destroy",
						   GTK_SIGNAL_FUNC(gtk_widget_destroyed), &configure_win);
		gtk_window_set_title(GTK_WINDOW(configure_win), "DBMix Plugin configuration");
/* 		gtk_window_set_policy(GTK_WINDOW(configure_win), FALSE, FALSE, FALSE); */
		gtk_window_set_position(GTK_WINDOW(configure_win), GTK_WIN_POS_MOUSE); 
		gtk_container_border_width(GTK_CONTAINER(configure_win), 10);

		/* make boxes */
		{
			main_box = gtk_vbox_new(FALSE,0);
			gtk_widget_show(main_box);
			
			name_box = gtk_hbox_new(FALSE,0);
			gtk_widget_show(name_box);
			
			ipc_box = gtk_hbox_new(FALSE,0);
			gtk_widget_show(ipc_box);

			close_box = gtk_hbox_new(FALSE,0);
			gtk_widget_show(close_box);
		}
		
		/* Fill name box */
		{
			gchar str1[DB_CHANNEL_NAME_SIZE];
			gint tempint;

			label = gtk_label_new("Channel Name:");
			gtk_box_pack_start(GTK_BOX(name_box),label,FALSE,FALSE,10);
			gtk_widget_show(label);
			
			text = gtk_entry_new_with_max_length(DB_CHANNEL_NAME_SIZE-1);

#ifdef DBMIX_DYNAMIC_LIBRARY
			dbaudiofxns->DBAudio_Get_Channel_Name(str1);
#else
			DBAudio_Get_Channel_Name(str1);
#endif
			
			sscanf(str1,"%s - %d",channel_name,&tempint);
		   
			gtk_entry_set_text(GTK_ENTRY(text),channel_name);

			gtk_signal_connect(GTK_OBJECT(text), "changed",
							   GTK_SIGNAL_FUNC(enter_callback),
							   text);

			gtk_box_pack_start(GTK_BOX(name_box),text,FALSE,FALSE,10);
			gtk_widget_show(text);
		}


		/* fill ipc box */
/* 		{ */
/* 			ipc_frame = gtk_frame_new("IPC Method:"); */
/* 			gtk_container_set_border_width(GTK_CONTAINER(ipc_frame), 5); */
/* 			gtk_widget_show(ipc_frame); */

/* 			pipe_radiobutton = gtk_radio_button_new_with_label(NULL, */
/* 													 "Use pipes for IPC"); */
/* 			ipc_group = gtk_radio_button_group(GTK_RADIO_BUTTON(pipe_radiobutton)); */
/* 			shm_radiobutton = gtk_radio_button_new_with_label(ipc_group, */
/* 													 "Use shared memory for IPC"); */
			
/* 			switch(dbaudiofxns->DBAudio_Get_Channel_Type()) */
/* 			{ */
/* 			case PIPE_CHANNEL: */
/* 				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(pipe_radiobutton),TRUE); */
/* 				break; */
/* 			default: */
/* 				break; */
/* 			} */


/* 			gtk_container_add(GTK_CONTAINER(ipc_frame),ipc_box); */

/* 			gtk_box_pack_start(GTK_BOX(ipc_box),pipe_radiobutton,TRUE,TRUE,0); */
/* 			gtk_box_pack_start(GTK_BOX(ipc_box),shm_radiobutton,TRUE,TRUE,0); */
/* 			gtk_widget_show(pipe_radiobutton); */
/* 		} */

		/* fill close open frame */

#if CLOSE_FLAG
		{
			close_frame = gtk_frame_new("Channel Handling:");
			gtk_container_set_border_width(GTK_CONTAINER(close_frame), 5);
			gtk_widget_show(close_frame);

			close_radiobutton = gtk_radio_button_new_with_label(NULL,
									   "Open and close a channel for each song.");
			close_group = (GtkWidget*)gtk_radio_button_group(GTK_RADIO_BUTTON(close_radiobutton));
			open_radiobutton = (GtkWidget*)gtk_radio_button_new_with_label((GSList *)close_group,
									   "Use one channel for all songs.");
			
			if(dbmix_cfg.close_flag)
			{
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(close_radiobutton),TRUE);
			}
			else
			{
				gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(open_radiobutton),TRUE);
			}

			gtk_container_add(GTK_CONTAINER(close_frame),close_box);

			gtk_box_pack_start(GTK_BOX(close_box),close_radiobutton,TRUE,TRUE,0);
			gtk_box_pack_start(GTK_BOX(close_box),open_radiobutton,TRUE,TRUE,0);
			gtk_widget_show(close_radiobutton);
			gtk_widget_show(open_radiobutton);
		}

#endif

		{
			buffer_frame = gtk_frame_new("Buffering:");
			gtk_container_set_border_width(GTK_CONTAINER(buffer_frame), 5);
			
			buffer_vbox = gtk_vbox_new(FALSE, 0);
			gtk_container_add(GTK_CONTAINER(buffer_frame), buffer_vbox);

			/* check box to enable buffer  */
			enable_buffer_button = gtk_check_button_new_with_label("Enable Prebuffer (Prevents skips on slower systems)"); 
			gtk_widget_show (enable_buffer_button); 
			gtk_signal_connect(GTK_OBJECT(enable_buffer_button), "clicked", 
							   GTK_SIGNAL_FUNC(enable_buffer_clicked), NULL); 
			gtk_box_pack_start(GTK_BOX(buffer_vbox),enable_buffer_button,FALSE,FALSE,0); 

			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enable_buffer_button),
										 dbmix_cfg.buffer_enable);

			/* spin box fro buffer size */
			buffer_table = gtk_table_new(2, 1, TRUE);
			gtk_container_set_border_width(GTK_CONTAINER(buffer_table), 5);
			gtk_box_pack_start(GTK_BOX(buffer_vbox), buffer_table, FALSE, FALSE, 0);
			
			buffer_size_box = gtk_hbox_new(FALSE, 5);
			gtk_table_attach_defaults(GTK_TABLE(buffer_table), buffer_size_box, 0, 1, 0, 1);
			buffer_size_label = gtk_label_new("Buffer size (ms):");
			gtk_box_pack_start(GTK_BOX(buffer_size_box), buffer_size_label, FALSE, FALSE, 0);
			buffer_size_adj = gtk_adjustment_new(dbmix_cfg.buffer_size, 200, 10000, 100, 100, 100);

			buffer_size_spin = gtk_spin_button_new(GTK_ADJUSTMENT(buffer_size_adj), 8, 0);
			gtk_widget_set_usize(buffer_size_spin, 60, -1);
			gtk_box_pack_start(GTK_BOX(buffer_size_box), buffer_size_spin, FALSE, FALSE, 0);

			/* Grey out the button if needed */ 
			gtk_widget_set_sensitive(GTK_WIDGET(buffer_size_spin),dbmix_cfg.buffer_enable); 
			
#if 0

			buffer_pre_box = gtk_hbox_new(FALSE, 5);
			gtk_table_attach_defaults(GTK_TABLE(buffer_table), buffer_pre_box, 1, 2, 0, 1);
			buffer_pre_label = gtk_label_new("Pre-buffer (percent):");
			gtk_box_pack_start(GTK_BOX(buffer_pre_box), buffer_pre_label, FALSE, FALSE, 0);
			buffer_pre_adj = gtk_adjustment_new(dbmix_cfg.prebuffer, 0, 90, 1, 1, 1);
			buffer_pre_spin = gtk_spin_button_new(GTK_ADJUSTMENT(buffer_pre_adj), 1, 0);
			gtk_widget_set_usize(buffer_pre_spin, 60, -1);
			gtk_box_pack_start(GTK_BOX(buffer_pre_box), buffer_pre_spin, FALSE, FALSE, 0);

			gtk_signal_connect (GTK_OBJECT (buffer_pre_adj), "value_changed",
								GTK_SIGNAL_FUNC (get_value_prebuffer),
								GINT_TO_POINTER (2));

#endif

			gtk_signal_connect (GTK_OBJECT (buffer_size_adj), "value_changed",
								GTK_SIGNAL_FUNC (get_value_buffer),
								GINT_TO_POINTER (1));

			gtk_widget_show(buffer_frame);

		}


		/* add ok cancel buttons */
		{
			button_box = gtk_hbutton_box_new();
			gtk_button_box_set_layout(GTK_BUTTON_BOX(button_box), GTK_BUTTONBOX_END);
			gtk_button_box_set_spacing(GTK_BUTTON_BOX(button_box), 10);
			
			ok = gtk_button_new_with_label("Ok");
			gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(ok_button), NULL);
			GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
			gtk_box_pack_start(GTK_BOX(button_box), ok, TRUE, TRUE, 0);
			
			cancel = gtk_button_new_with_label("Cancel");
			gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(configure_win));
			GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
			gtk_box_pack_start(GTK_BOX(button_box), cancel, TRUE, TRUE, 0);

			GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
			GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);

			gtk_widget_show(ok);
			gtk_widget_grab_default(ok);

			gtk_widget_show(cancel);
			gtk_widget_show(button_box);
		}

		/* add components to window*/
		gtk_box_pack_start(GTK_BOX(main_box),name_box,TRUE,TRUE,10);
		gtk_box_pack_start(GTK_BOX(main_box),ipc_frame,TRUE,TRUE,10);
#ifdef CLOSE_FLAG
		gtk_box_pack_start(GTK_BOX(main_box),close_frame,TRUE,TRUE,10);
#endif
		gtk_box_pack_start(GTK_BOX(main_box),buffer_frame,TRUE,TRUE,10);

		gtk_box_pack_start(GTK_BOX(main_box),button_box,TRUE,TRUE,10);

		gtk_container_add(GTK_CONTAINER(configure_win),main_box);
		gtk_widget_show_all(configure_win);
 	}
 	else
	{
 		gdk_window_raise(configure_win->window);
	}
}
