/*
 *  connectdialog.h
 *  ui
 *
 *  Created by Mikael Gransell on 4/11/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */


#ifndef _CONNECT_DIALOG_H_
#define _CONNECT_DIALOG_H_

#include <QDialog>

#include "rpctypes.h"
#include "backendconnection.h"
#include "ui_connectdialog.h"

class PublicHubs;
class FavouriteHubs;

class ConnectDialog : public QDialog
{
	Q_OBJECT
public:
	ConnectDialog( const BackendConnectionPtr& backendConn,
				   QWidget* parent = NULL );
	~ConnectDialog() {	}
	
public slots:
	void publicHubList( const QList<rpc_types::HubEntry>& hubs );
	
	void favouriteHubList( const QList<rpc_types::FavouriteHub>& hubs );
	void favouriteHubAdded( const rpc_types::FavouriteHub& hubs );
	void favouriteHubRemoved( const string& hubs );
	
	void getLists();
	
private slots:
	void on_quickConnectButton_pressed();

private:
	BackendConnectionPtr backendConnection;
	Ui::connectDialog ui;
	PublicHubs* publicHubs;
	FavouriteHubs* favouriteHubs;
};

#endif
