# 深度看图|../common/deepin-image-viewer.svg|

## 概述|../common/icon_overview.svg|


深度看图是深度科技精心打造的一款图片查看和管理应用。外观时尚、性能流畅，支持多种图片格式，任何图片想看就看。深度看图的照片管理功能，让您可以将图片按日期排列在时间线上，还可以将图片添加到收藏夹或归类到不同的相册中，将图片管理得井井有条。

![1|mian](png/main.png)

## 使用入门|../common/icon_guide.svg|

您可以通过以下方式运行或关闭深度看图，或者创建深度看图的快捷方式。

### 运行深度看图

1. 点击桌面底部的 启动器 ![launcher_icon](icon/launcher_icon.svg) 或将鼠标指针移到屏幕左上角，进入启动器界面。
2. 上下滚动鼠标滚轮浏览或通过搜索，找到应用 ![viewer](icon/deepin-image-viewer.svg)点击运行。
3. 将鼠标指针置于深度看图应用程序的图标上，右键点击 ![viewer](icon/deepin-image-viewer.svg)，您可以：
 - 点击 **发送到桌面**，在桌面创建快捷方式。
 - 点击 **发送到任务栏**，将应用程序固定到任务栏。
 - 点击 **开机自动启动**，将应用程序添加到开机启动项，在电脑开机时自动运行该应用程序。

![tips](icon/tips.svg)：您可以在控制中心中将深度看图设置为默认的图片查看程序，具体操作请参考 [默认启动设置](dman:///dde-control-center#默认程序设置)。

### 关闭深度看图

- 在深度看图界面点击  ![close_icon](icon/close_icon.svg) ，退出深度看图。
- 在任务栏右键单击 ![viewer](icon/deepin-image-viewer.svg) ，选择 **关闭所有** 来退出深度看图。
- 在深度看图界面点击 ![icon_menu](icon/icon_menu.svg) ，选择 **退出** 来退出深度看图。

## 图片查看|../common/icon_pictureview.svg|

使用深度看图直接打开图片文件可以进入基本的看图界面。

### 界面介绍

![1|main](png/main.png)


<table class="block1">
    <caption>主界面</caption>
    <tbody>
        <tr>
            <td> ![folder](icon/folder.svg) </td>
            <td>图片管理</td>
            <td>进入图片管理界面。包括时间线、相册功能。</td>
        </tr>
		<tr>
            <td> ![adapt-image](icon/adapt-image.svg) </td>
            <td>1:1显示</td>
            <td>图片按照实际尺寸显示。当图片超出界面范围时，界面上会出现导航窗口。</td>
        </tr>
		<tr>
            <td> ![adapt-screen](icon/adapt-screen.svg) </td>
            <td>自适应</td>
            <td>图片适应界面尺寸显示。</td>
        </tr>
		<tr>
            <td> ![clockwise-rotation](icon/clockwise-rotation.svg) </td>
            <td>顺时针</td>
            <td>图片顺时针旋转90度。</td>
        </tr>
		<tr>
            <td> ![contrarotate](icon/contrarotate.svg) </td>
            <td>逆时针</td>
            <td>图片逆时针旋转90度。</td>
        </tr>
		<tr>
            <td> ![delete](icon/delete.svg) </td>
            <td>删除</td>
            <td>删除当前图片。</td>
        </tr>
	    <tr>
            <td> ![previous](icon/previous.svg) </td>
            <td>上一张</td>
            <td>显示上一张图片。</td>
        </tr>
		<tr>
            <td> ![next](icon/next.svg) </td>
            <td>下一张</td>
            <td>显示下一张图片。</td>
        </tr>
    </tbody>
</table>

> ![tips](icon/tips.svg)：点击导航窗口上的 ![close_icon](icon/close_icon.svg) 可以关闭导航窗口，也可以在看深度看图界面上单击鼠标右键选择 **打开导航窗口/关闭导航窗口**。

### 幻灯片播放图片

1. 在深度看图界面上，单击鼠标右键。
2. 选择 **幻灯片放映**，图片将以幻灯片形式全屏播放。
3. 按下键盘上的 ![Esc](icon/Esc.svg) 键可以退出播放。

![0|slideshow](png/slideshow.png)

### 复制图片

1. 在深度看图界面上，单击鼠标右键。
2. 选择 **复制**。
3. 在桌面或者指定位置，单击鼠标右键。
4. 选择 **粘贴**，将图片文件复制到该位置。

> ![tips](icon/tips.svg)：**复制到剪贴板** 是复制功能的补充，当您想将图片作为内容插入到文档中或者发送给好友时，就可以将图片复制到剪贴板，然后粘贴了。

![0|copy](png/copy.png)

### 打印图片

1. 在深度看图界面上，单击鼠标右键。
2. 选择 **打印**。
3. 选择一个打印机。
4. 根据需要设置打印属性。
4. 选择 **打印**，将图片发送到打印机进行打印。

> ![notess](icon/notes.svg)：如果选择的是pdf打印机还需要选择打印位置，将在指定位置输出pdf文件。

![0|print](png/print.png)

### 删除图片

在深度看图中您可以通过如下方法删除图片：

- 点击深度看图界面上的 ![delete_press](icon/delete.svg)  图标。
- 右键单击图片，选择 **丢到回收站**。
- 在深度看图界面上，按下键盘的 ![Delete](icon/Delete.svg)  键。

![0|delete](png/delete.png)

### 旋转图片

1. 在深度看图界面上，单击鼠标右键。
2. 选择 **顺时针旋转/逆时针旋转**。
3. 图片将会顺时针转旋转90°/逆时针旋转90°。

![0|rotate](png/rotate.png)

### 设置为壁纸

1. 在深度看图界面上，单击鼠标右键。
2. 选择 **设为壁纸** 即可将当前图片设置为壁纸。

![0|wallpaper](png/wallpaper.png)


### 查看图片信息

1. 在深度看图界面上，单击鼠标右键。
2. 选择 **图片信息** 可以显示图片信息。

![1|info](png/info.png)

## 图片管理|../common/icon_picturemanagement.svg|

在图片管理界面，您可以通过时间线和相册来管理您的图片。


### 时间线管理

时间线中的图片按照日期划分，将同一天的图片显示在一起，不同日期的图片分栏排列，最新的日期在最上方。

![1|timeline](png/timeline.png)


#### 预览图缩放

通过拖动界面侧边的滚动条可以缩放时间线上图片的缩略图大小。


#### 同步文件夹

深度看图在启动时会对已同步管理的文件夹进行重新同步。

1. 在深度看图时间线界面上，点击左下角的 ![Synchronize](icon/Synchronize.svg) 图标。
2. 点击 **添加文件夹**。
3. 选择图片所在文件夹位置。
4. 点击 **打开**，将文件夹中的图片同步到时间线上。

![0|timeline](png/timeline.png)

> ![tips](icon/tips.svg)：在同步目录管理界面上，点击同步目录行上的 × 可以取消同步。

#### 收藏图片

时间线上的图片还可以收藏。

1. 在深度看图的时间线界面上，打开一张图片查看。
2. 点击界面上的 ![collect](icon/collect.svg) ，将图片加入我的收藏![collect-active](icon/collect-active.svg)。
3. 也可以再次点击![collect-active](icon/collect-active.svg) ，取消收藏![collect](icon/collect.svg)。

> ![tips](icon/tips.svg)：在预览或查看时间线上的图片时，选择右键菜单中的 **收藏** 或 **取消收藏** 也可以完成对应的操作。

![1|favorites](png/favorites.png)

#### 添加到相册

1. 在深度看图时间线界面上，右键单击图片。
2. 选择 **添加到相册**。
3. 选择一个相册，将图片添加到相册中。


![0|add-to-album](png/add-to-album.png)


#### 在文件管理器显示

1. 在深度看图时间线界面上，右键单击图片。
2. 选择 **在文件管理器中显示**，就可以在文件管理器中打开图片所在的文件夹。

![0|display](png/display.png)

### 相册管理


相册界面会显示相册缩略图，相册名称，相册中图片的起止时间。

![1|album](png/album.png)

> ![notes](icon/notes.svg)：**我的收藏** 是系统根据实际情况自动生成的，这个相册不可删除、重命名。


#### 相册图片缩放

通过拖动界面侧边的滚动条可以缩放相册缩略图大小。

#### 新建相册

1. 在深度看图相册界面，点击 + 号。
2. 输入相册名称。
3. 按下键盘上的 ![enter](icon/Enter.svg) 键。

![0|album](png/album.png)

> ![tips](icon/tips.svg)：通过主菜单 ![icon_menu](icon/icon_menu.svg) 的 **新建相册** 选项也可以新建相册。

#### 添加图片到相册

您可以通过一下方式添加图片到相册：
- 和在时间线一样通过[同步文件夹](#同步文件夹)添加图片到相册，文件夹会同时同步到时间线。
- 在时间线界面将图片[添加到相册](#添加到相册)。
- 直接从文件管理器中拖拽图片文件或文件夹到相册。

#### 移除相册的图片

1. 在深度看图相册界面上，右键单击相册中的图片。
2. 选择 **从相册中移除**，可以将图片从该相册中移除。

![0|remove](png/remove.png)

#### 复制相册

1. 在深度看图相册界面上，右键单击相册。
2. 选择 **复制** 会复制相册中的所有图片。

#### 重命名相册

1. 在深度看图界面上，右键单击需要改名的相册。
2. 选择 **重命名**。
3. 输入相册名称，按下![enter](icon/Enter.svg) 键或者鼠标单击界面空白区域。

![0|rename-album](png/rename.png)




## 选项设置|../common/icon_optionsetting.svg|

通过主菜单了解更多有用信息。

### 切换主题

1. 在深度看图界面，点击  ![icon_menu](icon/icon_menu.svg) 。
2. 点击 **浅色主题/深色主题**，来切换主题颜色。

### 设置

1. 在深度看图界面，点击  ![icon_menu](icon/icon_menu.svg) 。
2. 点击 **设置**。
3. 您可以根据需要进行以下设置：
 - 设置幻灯片效果、时常。
 - 查看默认快捷键或设置自定义快捷键。
 - 恢复默认设置。

![1|setting](png/setting.png)

### 帮助

您可以点击帮助获取深度看图的帮助手册，通过帮助进一步让您了解和使用深度看图。

1. 在深度看图界面，点击  ![icon_menu](icon/icon_menu.svg) 。
2. 点击 **帮助**。
3. 查看关于深度看图的帮助手册。

![1|heip](png/help.png)


### 关于

您可以点击关于查看深度看图的版本介绍。

1. 在深度看图界面，点击  ![icon_menu](icon/icon_menu.svg) 。
2. 点击 **关于**。
3. 查看关于深度看图的版本和介绍。

![0|about](png/about.png)


### 退出

您可以进入菜单栏点击退出深度看图。

1. 在深度看图界面，点击 ![icon_menu](icon/icon_menu.svg)。
2. 点击 **退出**。
