<?php
# dvdisaster: English homepage translation
# Copyright (C) 2004-2012 Carsten Gnörlich
#
# UTF-8 trigger: äöüß 
#
# Include our PHP sub routines, then call begin_page()
# to start the HTML page, insert the header, 
# navigation and news if appropriate.

require("../include/dvdisaster.php");
begin_page();
?>

<!-- Insert actual page content below -->

<h3 class="top"><a name="top">Obecné otázky a odpovědi</a></h3><a href="#pronounce">1.1 Jaká je výslovnost názvu &quot;dvdisaster&quot;?</a><p><a href="#pipo">1.2 Co jsou kontroly kvality a proč nepodporujete více?</a><p><a href="#compat">1.3 Je dvdisaster kompatibilní s budoucími verzemi?</a><p><a href="#eccpos">1.4 Rozšířené bitové kopie mají data pro opravu chyb připojena na konci. Není to špatná volba?</a><p><a href="#recovery">1.5 Jaký je rozdíl mezi opravou souborů a opravou bitových kopií?</a><p><hr><p><b><a name="pronounce">1.1 Jaká je výslovnost názvu &quot;dvdisaster&quot;?</a></b><p>Jelikož výraz vychází z angličtiny, jednoduše vyslovte &quot;dv&quot; následované &quot;disaster&quot;. Foneticky tedy &quot;dý-vý-dizéstr&quot;.<div class="talignr"><a href="#top">↑</a></div><b><a name="pipo">1.2 Co jsou kontroly kvality a proč nepodporujete více?</a></b><p>Optické disky mají zabudovanou opravu chyb, která je podobná metodě používané dvdisaster. Některé mechaniky jsou schopné při čtení disku hlásit počet opravených chyb. To poskytuje hrubou představu o kvalitě disku a zápisu.<p>Protože dvdisaster je volný software, může obsahovat pouze volně šiřitelný kód a informace. To nyní platí pro C2 <a href="howtos10.php">kontroly</a> CD disků, které mají volně dostupnou bezplatnou dokumentaci.<p>Na druhou stranu kontrola kvality u DVD (&quot;PI/PO kontroly&quot;) žádný standard nemají. Výrobci kteří je podporují používají proprietární programovací rozhraní. Příslušné specifikace nejsou pro volný software k dispozici. Musíme proto počkat než si výrobci uvědomí, že dostupnost volného softwaru pro jejich mechaniky zvýší jejich prodejnost.<p><div class="talignr"><a href="#top">↑</a></div><b><a name="compat">1.3 Je dvdisaster kompatibilní s budoucími verzemi?</a></b><p>Ano, soubory dvdisaster jsou určeny k dlouhodobé archivaci po mnoho let. Po aktualizaci na novější verzi dvdisaster můžete stále používat soubory pro opravu a rozšířené bitové kopie vytvořené staršími verzemi. Není <i>žádný</i> důvod vytvářet je znovu.<div class="talignr"><a href="#top">↑</a></div><p><b><a name="eccpos">1.4 Rozšířené bitové kopie mají data pro opravu chyb připojena na konci. Není to špatná volba?</a></b><p>Ne. Nejdříve trochu terminologie: Pokud rozšíříme 80 bajtů uživatelských dat o 20 bajtů dat pro opravu chyb, získáme &quot;ECC blok&quot; velikosti 100 bajtů. U tohoto ECC bloku si nyní musíme uvědomit, že:<ol>
<li>Na pozici dat pro opravu chyb v ECC bloku nezáleží.<p>RS dekodér nerozlišuje mezi uživatelskými daty a daty pro opravu chyb. Z pohledu RS dekodéru je náš ECC blok sekvence 100 bajtů u kterých lze opravit libovolný úsek 20 bajtů. Dokud je k dispozici minimálně 80 nepoškozených bajtů, lze opravit prvních 20 bajtů, posledních 20 bajtů nebo jakýkoliv úsek mezi. Z toho lze vyvodit, že na pozici ECC dat v ECC bloku nezáleží; jestli je přidán na konec uživatelských dat nebo je vložen prokládaně mezi nemá žádný vliv na schopnost opravy.</li>

<li>Správná distribuce ECC bloků vyrovnává vliv chybných částí disku.<p>U optických disků je větší pravděpodobnost, že bude poškozena vnější část disku; z technických důvodů je tohle jediné místo, kde je možné umístit data pro opravu chyb. Tento efekt je ale vyrovnán distribucí ECC bloků v obsahu disku. Předpokládejme, že disk je zaplněn z 80% uživatelskými daty, takže zůstává 20% volného prostoru pro data pro opravu chyb. Nyní si znovu představte dříve zmiňovaný 100 bajtový ECC blok. Potřebujeme pro něj 80 bajtů uživatelských data a dalších 20 bajtů v oblasti dat pro opravu chyb. I s takovýmto omezením je možné zmiňovaných 100 bajtů na disku uložit rovnoměrně, od středu po okraj s co největší vzdáleností od jejich sousedů. Spolu s bodem (1) tak lze vyrušit vliv špatných oblastí disku. Ze symetrie vyplývá, že pro každý opravný bajt uložený v (poškozené) vnější oblasti bude k dispozici bajt uživatelských dat v (nepoškozené) vnitřní oblasti disku.<p>(Pokud vám to stále nedochází, představte si ECC data uložená na vnitřní části disku a uživatelská data na vnější části disku. Poté znovu zauvažujte nad bodem (1) a všimněte si, že z pohledu opravy chyb se nic nezměnilo.)</li>
</ol>
<div class="talignr"><a href="#top">↑</a></div><p><b><a name="recovery">1.5 Jaký je rozdíl mezi opravou souborů a opravou bitových kopií?</a></b><p>Optické disky jsou složeny z 2048bajtových sektorů. Většina je použita k uložení uživatelských dat, některé z nich ale obsahují tzv. &quot;meta data&quot;, tedy například informace o adresářích.<br>V příkladu 1.5.1 (níže) je adresář &quot;Obrázky&quot; obsahující tři soubory &quot;les.jpg&quot;, &quot;skála.jpg&quot; a &quot;ochrana.par&quot;<a href="#note1"><sup>1)</sup></a>. Všimněte si, jak jsou soubory na disku přiřazeny k fyzickým sektorům (zelené/modré čtverečky), a že jeden dodatečný metadata sektor (červený čtverec) je třeba k uložení adresářové struktury &quot;Obrázky&quot;.<p><table width="100%"><tr><td align="center"><img src="images/metadata1.png" alt="Vztah mezi souborovým systémem a sektory disku"></td></tr></table><p><b>Nedostatky opravy souborů při použití na optických discích.</b><br>Nyní si představme, že pracujeme s opravou souborů. Soubor &quot;ochrana.par&quot; obsahuje opravná data umožňující opravit poškozené sektory souborů &quot;les.jpg&quot; a &quot;skála.jpg&quot;. To bude fungovat pouze pokud potřebujeme opravit sektory obsahující data souborů. Pokud se ale poškodí sektory obsahující metadata, ochrana opravou souborů se zhroutí. Podívejte se na příklad 1.5.2. Pokud se červený sektor adresáře stane nečitelným, stane se nepřístupným nejen adresář &quot;Obrázky&quot;, ale také všechny soubory v &quot;Obrázky&quot;. To je způsobeno logickou strukturou systému souborů ISO/UDF, protože po ztrátě adresáře neexistuje způsob jak zelené a modré sektory přiřadit k souborům. Došlo tak ke kompletní ztrátě dat, přestože všechny sektory jednotlivých souborů jsou stále čitelné.<p><table width="100%"><tr><td align="center"><img src="images/metadata2.png" alt="Nečitelnost sektoru s metadaty způsobí ztrátu všech dat"></td></tr></table><p><p>Přesunutí souboru &quot;ochrana.par&quot; na jiný disk problém neřeší - adresář stále nelze opravit protože není souborem &quot;ochrana.par&quot; chráněn.<p><b>Výhody opravy bitových kopií při použití na optických discích.</b><br>dvdisaster používá opravu souborů na úrovni bitové kopie. Disk je načten a zpracováván jako bitová kopie ve formátu ISO. Bitová kopie obsahuje sekvenci všech sektorů disku, včetně těch obsahujících metadata systému souborů. Protože oprava chyb dvdisaster chrání <i>všechny sektory</i> bitové kopie, může být opraven jak obsah souborů, tak sektory metadat (např. adresáře). Rozdílný rozsah ochrany je uveden v příkladu 1.5.3.<table width="100%"><tr><td align="center"><img src="images/metadata3.png" alt="Ochrana na úrovni bitové kopie"></td></tr></table><p>Navíc čtení poškozené bitové kopie, ani použití opravy chyb, nevyžaduje jakékoliv informace systému souborů disku. Dokud je mechanika schopna disk rozpoznat, dvdisaster bude schopen načíst všechny jeho čitelné sektory. Neexistují proto &quot;sektory selhání&quot; jako v případě opravy souborů.<table width="30%" cellpadding="0">
<tr><td class="hsep"></td></tr>
</table><a name="note1"><sup>1)</sup> Nemáme v úmyslu urážet projekt PAR/PAR2. Carsten si je pouze jistý, že oprava souborů u optických disků nefunguje :-)</a><div class="talignr"><a href="#top">↑</a></div><p><!-- do not change below --> <?php
# end_page() adds the footer line and closes the HTML properly.

end_page();
?>