/*
 * Copyright (C) 2007-2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define FAST

#define XCONC(a, b, c)  a ## _ ## b ## _ ## c
#define CONC(a, b, c)   XCONC(a, b, c)

#include <fenv.h>
#include <inttypes.h>
#include <math.h>
#include <setjmp.h>

#include "glue-main.h"
#include "glue-floatx.h"

#include "exec-all.h"
#include "arch_gen_cpu_x86_state.h"
#include "arch_gen_cpu_x86_fpu.h"
#include "arch_gen_cpu_x86_core.h"
#include "arch_gen_cpu_x86_align.h"

#define NAME		CHIP
#define NAME_(x)	CHIP_(x)
#include "qemu/cpu_jit_op.c"
#undef NAME_
#undef NAME
