--
-- Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.ALL;
use expect.procedures.ALL;
library ieee;
use ieee.std_logic_1164.ALL;

entity test_bench is
end test_bench;

architecture structural of test_bench is
	signal vcc : std_logic;
	signal val : std_logic;
	signal gnd : std_logic;
	signal b : std_logic;
	signal adj_c : integer;
	signal adj_d : integer;
	signal adj_e : integer;
	signal adj_f : integer;
	signal sigs : std_logic_vector(1 to 10);
	
	signal  voltage_a : std_logic;
	signal  voltage_b : std_logic;
	signal  voltage_c : std_logic;
	signal  voltage_d : std_logic;
	signal  voltage_e : std_logic;
	signal  voltage_f : std_logic;
	signal  voltage_g : std_logic;
	signal  voltage_h : std_logic;
	signal  voltage_i : std_logic;
	signal  voltage_j : std_logic;
	signal  digi_a : std_logic;
	signal  digi_b : std_logic;
	signal  digi_c : std_logic;
	signal  digi_d : std_logic;
	signal  digi_e : std_logic;
	signal  digi_f : std_logic;
	signal  digi_g : std_logic;
	signal  digi_h : std_logic;
	signal  digi_i : std_logic;
	signal  digi_j : std_logic;
begin
	oscilloscope : oscilloscope
		port map (
			a => val,
			b => b,
			gnd => gnd,
			vcc => vcc,
			adj_c => adj_c,
			adj_d => adj_d,
			adj_e => adj_e,
			adj_f => adj_f
		);


--	potentiometer : potentiometer
--		port map (
--			left => vcc,
--			mid => val,
--			right => gnd
--		);

	sinusgen : sinusgen
		port map (
			gnd => gnd,
			vcc => vcc,
			output => val
		);

--	VERTICAL_POSITION : potentiometer
--		port map (
--			left => vcc,
--			mid => f,
--			right => gnd
--		);
--
--	VOLTS_DIV : potentiometer
--		port map (
--			left => vcc,
--			mid => d,
--			right => gnd 
--		);
--
--	TRIGGER_LEVEL : potentiometer
--		port map (
--			left => vcc,
--			mid => c,
--			right => gnd
--		);
--
--	SEC_DIV : potentiometer
--		port map (
--			left => vcc,
--			mid => e,
--			right => gnd
--		);
	
	battery : battery
		generic map (
			voltage => 5000
		)
		port map (
			vdd => gnd,
			vss => vcc
		);
	
end structural;
