/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "glue.h"
#include "glue-gui-gtk-led3.h"

typedef struct {
	GtkVBoxClass parent_class;
} GuiGtkLed3Class;

static void
gui_gtk_led3_color(GdkPixbuf *pixbuf, unsigned int r, unsigned int g, unsigned int b)
{
	int width, height, rowstride;
	guchar *pixels, *p;
	unsigned int x, y;

	assert(gdk_pixbuf_get_n_channels(pixbuf) == 4);
	assert(gdk_pixbuf_get_colorspace(pixbuf) == GDK_COLORSPACE_RGB);
	assert(gdk_pixbuf_get_bits_per_sample(pixbuf) == 8);
	assert(gdk_pixbuf_get_has_alpha(pixbuf));

	width = gdk_pixbuf_get_width(pixbuf);
	height = gdk_pixbuf_get_height(pixbuf);
	rowstride = gdk_pixbuf_get_rowstride(pixbuf);
	pixels = gdk_pixbuf_get_pixels(pixbuf);

	for (y = 0; y < height; y++) {
		for (x = 0; x < width; x++) {
			int d2;

			p = pixels + y * rowstride + x * 4;
			d2 = (x-width/2)*(x-width/2) + (y-height/2)*(y-height/2);
			if (d2 <= ((width-4)/2)*((width-4)/2)) {
				/* Circle */
				p[0] = r;
				p[1] = g;
				p[2] = b;
				p[3] = 0xff;
			} else if (d2 <= (width/2)*(width/2)) {
				/* Frame */
				p[0] = 0x00;
				p[1] = 0x00;
				p[2] = 0x00;
				p[3] = 0xff;
			} else {
				/* Outside */
				p[0] = 0;
				p[1] = 0;
				p[2] = 0;
				p[3] = 0x00;
			}
		}
	}
}

static void
gui_gtk_led3_class_init(GuiGtkLed3Class *klass)
{
}

static void
gui_gtk_led3_init(GuiGtkLed3 *ttt)
{
}

GType
gui_gtk_led3_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkLed3Class),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_led3_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkLed3),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_led3_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_VBOX,
				"Led3", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKLED3_TYPE	gui_gtk_led3_get_type()

GtkWidget *
gui_gtk_led3_new(const char *desc)
{
	GuiGtkLed3 *widget;

	widget = GUI_GTK_LED3(g_object_new(GUIGTKLED3_TYPE, NULL));

	widget->pixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, 1, 8, 16, 16);
	gui_gtk_led3_color(widget->pixbuf, 0, 0, 0);
	widget->led = gtk_image_new();
	gtk_image_set_from_pixbuf(GTK_IMAGE(widget->led),
			widget->pixbuf);
	gtk_widget_show(widget->led);
	gtk_box_pack_start(GTK_BOX(widget), widget->led,
			FALSE, FALSE, 5);

	widget->desc = gtk_label_new(desc);
	gtk_widget_show(widget->desc);
	gtk_box_pack_start(GTK_BOX(widget), widget->desc,
			FALSE, FALSE, 1);

	return GTK_WIDGET(widget);
}

void
gui_gtk_led3_set(GuiGtkLed3 *widget, unsigned int r, unsigned int g, unsigned int b)
{
	gui_gtk_led3_color(widget->pixbuf, r, g, b);
	gtk_image_set_from_pixbuf(GTK_IMAGE(widget->led),
			widget->pixbuf);
}
