/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LIB_USB_H_INCLUDED
#define __LIB_USB_H_INCLUDED

/* usb_msg.content.linestate.usb_speed */
#define USB_SPEED_UNCONNECTED		0
#define USB_SPEED_FULL			1
#define USB_SPEED_LOW			2

/* usb_msg.content.usb_*.pid */
#define USB_PID_SOF	0xA5
#define USB_PID_SETUP	0x2D
#define USB_PID_IN	0x69
#define USB_PID_OUT	0xE1
#define USB_PID_DATA0	0xC3
#define USB_PID_DATA1	0x4B
#define USB_PID_ACK	0xD2
#define USB_PID_NAK	0x5A
#define USB_PID_STALL	0x1E
#define USB_PID_PRE	0x3C

/* cf. USB Spec. Rev. 1.1, chapter 9.3 "USB Device Requests" */
/* bmRequestType */
#define USB_DEV_REQ_DEVICE_TO_HOST	(1<<7)
#define USB_DEV_REQ_TYPE		(1<<6|1<<5)
#define USB_DEV_REQ_TYPE_STANDARD	(0<<6|0<<5)
#define USB_DEV_REQ_TYPE_CLASS		(0<<6|1<<5)
#define USB_DEV_REQ_TYPE_VENDOR		(1<<6|0<<5)
#define USB_DEV_REQ_TYPE_RESERVED	(1<<6|1<<5)
#define USB_DEV_REQ_RECIPIENT		0x1F	/* bits 0:4 */
#define USB_DEV_REQ_RECIPIENT_DEVICE	0
#define USB_DEV_REQ_RECIPIENT_INTERFACE	1
#define USB_DEV_REQ_RECIPIENT_ENDPOINT	2
#define USB_DEV_REQ_RECIPIENT_OTHER	3
/* cf. USB Spec. Rev. 1.1, chapter 9.4 "Standard Device Requests" */
/* bRequest */
#define USB_DEV_REQ_GET_STATUS		0x00
#define USB_DEV_REQ_CLEAR_FEATURE	0x01
#define USB_DEV_REQ_SET_FEATURE		0x03
#define USB_DEV_REQ_SET_ADDRESS		0x05
#define USB_DEV_REQ_GET_DESCRIPTOR	0x06
#define USB_DEV_REQ_SET_DESCRIPTOR	0x07 /* optional */
#define USB_DEV_REQ_GET_CONFIGURATION	0x08
#define USB_DEV_REQ_SET_CONFIGURATION	0x09
#define USB_DEV_REQ_GET_INTERFACE	0x0A
#define USB_DEV_REQ_SET_INTERFACE	0x0B
#define USB_DEV_REQ_SYNCH_FRAME		0x0C /* optional */
/* descriptor types */
#define USB_DESCRIPTOR_TYPE_DEVICE		1
#define USB_DESCRIPTOR_TYPE_CONFIGURATION	2
#define USB_DESCRIPTOR_TYPE_STRING		3
#define USB_DESCRIPTOR_TYPE_INTERFACE		4
#define USB_DESCRIPTOR_TYPE_ENDPOINT		5
/* device/endpoint features */
#define USB_FEATURE_ENDPOINT_STALL		0x0000
#define USB_FEATURE_DEVICE_REMOTE_WAKEUP	0x0001

#ifndef USB_ENDPOINT_ADDRESS_MASK

/* endpoint data flow directions */
#define USB_ENDPOINT_ADDRESS_MASK	0x0F
#define USB_ENDPOINT_DIR_MASK		0x80
#define USB_ENDPOINT_IN			0x80
#define USB_ENDPOINT_OUT		0x00

#endif /* USB_ENDPOINT_ADDRESS_MASK */

const char *
cim_usb_debug_pid2str(unsigned char pid);
const char *
cim_usb_debug_descriptortype2str(unsigned int descriptor_type);
const char *
cim_usb_debug_defaultrequest2str(unsigned char bRequest);

#endif /* __LIB_USB_H_INCLUDED */
