/*
 * Copyright (C) 2004-2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "build_config.h"

#ifdef INIT_RM

/*
 * Power-on Self Test
 */

.section .text
.code16gcc

#include "libsys.h"


_C_LABEL(post): .globl _C_LABEL(post)
	/* Check jo/jno (0x70, 0x71) */
	movb $0, %al
	cmpb $1, %al
	jo fail
	movw $0, %ax
	cmpw $1, %ax
	jo fail
	movl $0, %eax
	cmpl $1, %eax
	jo fail
	movb $0x80, %al
	cmpb $0x01, %al
	jno fail
	movw $0x8000, %ax
	cmpw $0x0001, %ax
	jno fail
	movl $0x80000000, %eax
	cmpl $0x00000001, %eax
	jno fail

	/* Check jb/jae (0x72, 0x73) */
	movb $0x80, %al
	cmpb $0x80, %al
	jb fail
	movw $0x8000, %ax
	cmpw $0x8000, %ax
	jb fail
	movl $0x80000000, %eax
	cmpl $0x80000000, %eax
	jb fail
	movb $0, %al
	cmpb $0, %al
	jb fail
	movw $0, %ax
	cmpw $0, %ax
	jb fail
	movl $0, %eax
	cmpl $0, %eax
	jb fail

	movb $0x81, %al
	cmpb $0x80, %al
	jb fail
	movw $0x8001, %ax
	cmpw $0x8000, %ax
	jb fail
	movl $0x80000001, %eax
	cmpl $0x80000000, %eax
	jb fail
	movb $0x80, %al
	cmpb $1, %al
	jb fail
	movw $0x8000, %ax
	cmpw $1, %ax
	jb fail
	movl $0x80000000, %eax
	cmpl $1, %eax
	jb fail
	movb $1, %al
	cmpb $0, %al
	jb fail
	movw $1, %ax
	cmpw $0, %ax
	jb fail
	movl $1, %eax
	cmpl $0, %eax
	jb fail

	movb $0x80, %al
	cmpb $0x81, %al
	jae fail
	movw $0x8000, %ax
	cmpw $0x8001, %ax
	jae fail
	movl $0x80000000, %eax
	cmpl $0x80000001, %eax
	jae fail
	movb $0, %al
	cmpb $0x80, %al
	jae fail
	movw $0, %ax
	cmpw $0x8000, %ax
	jae fail
	movl $0, %eax
	cmpl $0x80000000, %eax
	jae fail
	movb $0, %al
	cmpb $1, %al
	jae fail
	movw $0, %ax
	cmpw $1, %ax
	jae fail
	movl $0, %eax
	cmpl $1, %eax
	jae fail

	/* Check je/jne (0x74, 0x75) */
	movb $0x80, %al
	cmpb $0x80, %al
	jne fail
	movw $0x8000, %ax
	cmpw $0x8000, %ax
	jne fail
	movl $0x80000000, %eax
	cmpl $0x80000000, %eax
	jne fail
	movb $0, %al
	cmpb $0, %al
	jne fail
	movw $0, %ax
	cmpw $0, %ax
	jne fail
	movl $0, %eax
	cmpl $0, %eax
	jne fail

	movb $0x81, %al
	cmpb $0x80, %al
	je fail
	movw $0x8001, %ax
	cmpw $0x8000, %ax
	je fail
	movl $0x80000001, %eax
	cmpl $0x80000000, %eax
	je fail
	movb $1, %al
	cmpb $0, %al
	je fail
	movw $1, %ax
	cmpw $0, %ax
	je fail
	movl $1, %eax
	cmpl $0, %eax
	je fail

	/* Check jbe/ja (0x76, 0x77) */
	movb $0x80, %al
	cmpb $0x80, %al
	ja fail
	movw $0x8000, %ax
	cmpw $0x8000, %ax
	ja fail
	movl $0x80000000, %eax
	cmpl $0x80000000, %eax
	ja fail
	movb $0, %al
	cmpb $0, %al
	ja fail
	movw $0, %ax
	cmpw $0, %ax
	ja fail
	movl $0, %eax
	cmpl $0, %eax
	ja fail

	movb $0x81, %al
	cmpb $0x80, %al
	jbe fail
	movw $0x8001, %ax
	cmpw $0x8000, %ax
	jbe fail
	movl $0x80000001, %eax
	cmpl $0x80000000, %eax
	jbe fail
	movb $0x80, %al
	cmpb $1, %al
	jbe fail
	movw $0x8000, %ax
	cmpw $1, %ax
	jbe fail
	movl $0x80000000, %eax
	cmpl $1, %eax
	jbe fail
	movb $2, %al
	cmpb $1, %al
	jbe fail
	movw $2, %ax
	cmpw $1, %ax
	jbe fail
	movl $2, %eax
	cmpl $1, %eax
	jbe fail

	movb $0x80, %al
	cmpb $0x81, %al
	ja fail
	movw $0x8000, %ax
	cmpw $0x8001, %ax
	ja fail
	movl $0x80000000, %eax
	cmpl $0x80000001, %eax
	ja fail
	movb $1, %al
	cmpb $0x80, %al
	ja fail
	movw $1, %ax
	cmpw $0x8000, %ax
	ja fail
	movl $1, %eax
	cmpl $0x80000000, %eax
	ja fail
	movb $1, %al
	cmpb $2, %al
	ja fail
	movw $1, %ax
	cmpw $2, %ax
	ja fail
	movl $1, %eax
	cmpl $2, %eax
	ja fail

	/* Check js/jns (0x78, 0x79) */
	movb $0x80, %al
	cmpb $0x80, %al
	js fail
	movw $0x8000, %ax
	cmpw $0x8000, %ax
	js fail
	movl $0x80000000, %eax
	cmpl $0x80000000, %eax
	js fail
	movb $1, %al
	cmpb $1, %al
	js fail
	movw $1, %ax
	cmpw $1, %ax
	js fail
	movl $1, %eax
	cmpl $1, %eax
	js fail

	movb $0x81, %al
	cmpb $0x80, %al
	js fail
	movw $0x8001, %ax
	cmpw $0x8000, %ax
	js fail
	movl $0x80000001, %eax
	cmpl $0x80000000, %eax
	js fail
	movb $0x80, %al
	cmpb $1, %al
	js fail
	movw $0x8000, %ax
	cmpw $1, %ax
	js fail
	movl $0x80000000, %eax
	cmpl $1, %eax
	js fail
	movb $2, %al
	cmpb $1, %al
	js fail
	movw $2, %ax
	cmpw $1, %ax
	js fail
	movl $2, %eax
	cmpl $1, %eax
	js fail

	movb $0x80, %al
	cmpb $0x81, %al
	jns fail
	movw $0x8000, %ax
	cmpw $0x8001, %ax
	jns fail
	movl $0x80000000, %eax
	cmpl $0x80000001, %eax
	jns fail
	movb $1, %al
	cmpb $0x80, %al
	jns fail
	movw $1, %ax
	cmpw $0x8000, %ax
	jns fail
	movl $1, %eax
	cmpl $0x80000000, %eax
	jns fail
	movb $0, %al
	cmpb $1, %al
	jns fail
	movw $0, %ax
	cmpw $1, %ax
	jns fail
	movl $0, %eax
	cmpl $1, %eax
	jns fail

	/* Check jpe/jpo (0x7a, 0x7b) */
	movl $0x80000000, %eax
	subl $0x80000000, %eax
	jpo fail
	movl $1, %eax
	subl $1, %eax
	jpo fail

	movl $0x80000001, %eax
	subl $0x80000000, %eax
	jpe fail
	movl $2, %eax
	subl $1, %eax
	jpe fail

	/* Check jl/jge (0x7c, 0x7d) */
	movb $0x80, %al
	cmpb $0x80, %al
	jl fail
	movw $0x8000, %ax
	cmpw $0x8000, %ax
	jl fail
	movl $0x80000000, %eax
	cmpl $0x80000000, %eax
	jl fail
	movb $0, %al
	cmpb $0, %al
	jl fail
	movw $0, %ax
	cmpw $0, %ax
	jl fail
	movl $0, %eax
	cmpl $0, %eax
	jl fail

	movb $0x81, %al
	cmpb $0x80, %al
	jl fail
	movw $0x8001, %ax
	cmpw $0x8000, %ax
	jl fail
	movl $0x80000001, %eax
	cmpl $0x80000000, %eax
	jl fail
	movb $1, %al
	cmpb $0x80, %al
	jl fail
	movw $1, %ax
	cmpw $0x8000, %ax
	jl fail
	movl $1, %eax
	cmpl $0x80000000, %eax
	jl fail
	movb $1, %al
	cmpb $0, %al
	jl fail
	movw $1, %ax
	cmpw $0, %ax
	jl fail
	movl $1, %eax
	cmpl $0, %eax
	jl fail

	movb $0x80, %al
	cmpb $0x81, %al
	jge fail
	movw $0x8000, %ax
	cmpw $0x8001, %ax
	jge fail
	movl $0x80000000, %eax
	cmpl $0x80000001, %eax
	jge fail
	movb $0x80, %al
	cmpb $1, %al
	jge fail
	movw $0x8000, %ax
	cmpw $1, %ax
	jge fail
	movl $0x80000000, %eax
	cmpl $1, %eax
	jge fail
	movb $0, %al
	cmpb $1, %al
	jge fail
	movw $0, %ax
	cmpw $1, %ax
	jge fail
	movl $0, %eax
	cmpl $1, %eax
	jge fail

	/* Check jle/jg (0x7e, 0x7f) */
	movb $0x80, %al
	cmpb $0x80, %al
	jg fail
	movw $0x8000, %ax
	cmpw $0x8000, %ax
	jg fail
	movl $0x80000000, %eax
	cmpl $0x80000000, %eax
	jg fail
	movb $0, %al
	cmpb $0, %al
	jg fail
	movw $0, %ax
	cmpw $0, %ax
	jg fail
	movl $0, %eax
	cmpl $0, %eax
	jg fail

	movb $0x80, %al
	cmpb $0x81, %al
	jg fail
	movw $0x8000, %ax
	cmpw $0x8001, %ax
	jg fail
	movl $0x80000000, %eax
	cmpl $0x80000001, %eax
	jg fail
	movb $0x80, %al
	cmpb $1, %al
	jg fail
	movw $0x8000, %ax
	cmpw $1, %ax
	jg fail
	movl $0x80000000, %eax
	cmpl $1, %eax
	jg fail
	movb $0, %al
	cmpb $1, %al
	jg fail
	movw $0, %ax
	cmpw $1, %ax
	jg fail
	movl $0, %eax
	cmpl $1, %eax
	jg fail

	movb $0x81, %al
	cmpb $0x80, %al
	jle fail
	movw $0x8001, %ax
	cmpw $0x8000, %ax
	jle fail
	movl $0x80000001, %eax
	cmpl $0x80000000, %eax
	jle fail
	movb $1, %al
	cmpb $0x80, %al
	jle fail
	movw $1, %ax
	cmpw $0x8000, %ax
	jle fail
	movl $1, %eax
	cmpl $0x80000000, %eax
	jle fail
	movb $1, %al
	cmpb $0, %al
	jle fail
	movw $1, %ax
	cmpw $0, %ax
	jle fail
	movl $1, %eax
	cmpl $0, %eax
	jle fail

	lretw

fail:
	jmp fail

#endif /* INIT_RM */
