/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.LogTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FlexReader
extends BaseTiffReader {
    protected static final int FLEX = 65200;
    public static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    protected double[] factors;

    public FlexReader() {
        super("Evotec Flex", "flex");
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        byte[] bytes;
        block7: {
            int q;
            int i;
            int num;
            block6: {
                FormatTools.assertId(this.currentId, true, 1);
                bytes = super.openBytes(no, buf);
                if (this.core.pixelType[0] == 1) {
                    num = bytes.length;
                    for (i = num - 1; i >= 0; --i) {
                        q = (int)((double)(bytes[i] & 0xFF) * this.factors[no]);
                        bytes[i] = (byte)(q & 0xFF);
                    }
                }
                if (this.core.pixelType[0] != 3) break block6;
                num = bytes.length / 2;
                for (i = num - 1; i >= 0; --i) {
                    q = (int)((double)(bytes[i] & 0xFF) * this.factors[no]);
                    byte b0 = (byte)(q & 0xFF);
                    byte b1 = (byte)(q >> 8 & 0xFF);
                    int ndx = 2 * i;
                    if (this.core.littleEndian[0]) {
                        bytes[ndx] = b0;
                        bytes[ndx + 1] = b1;
                        continue;
                    }
                    bytes[ndx] = b1;
                    bytes[ndx + 1] = b0;
                }
                break block7;
            }
            if (this.core.pixelType[0] != 5) break block7;
            num = bytes.length / 4;
            for (i = num - 1; i >= 0; --i) {
                q = (int)((double)(bytes[i] & 0xFF) * this.factors[no]);
                byte b0 = (byte)(q & 0xFF);
                byte b1 = (byte)(q >> 8 & 0xFF);
                byte b2 = (byte)(q >> 16 & 0xFF);
                byte b3 = (byte)(q >> 24 & 0xFF);
                int ndx = 4 * i;
                if (this.core.littleEndian[0]) {
                    bytes[ndx] = b0;
                    bytes[ndx + 1] = b1;
                    bytes[ndx + 2] = b2;
                    bytes[ndx + 3] = b3;
                    continue;
                }
                bytes[ndx] = b3;
                bytes[ndx + 1] = b2;
                bytes[ndx + 2] = b1;
                bytes[ndx + 3] = b0;
            }
        }
        return bytes;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int i;
        super.initStandardMetadata();
        this.core.orderCertain[0] = false;
        String xml = (String)TiffTools.getIFDValue(this.ifds[0], 65200, true, String.class);
        Vector n = new Vector();
        Vector f = new Vector();
        FlexHandler handler = new FlexHandler(n, f);
        try {
            SAXParser saxParser = SAX_FACTORY.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException exc) {
            throw new FormatException(exc);
        }
        catch (SAXException exc) {
            throw new FormatException(exc);
        }
        int nsize = n.size();
        int fsize = f.size();
        if (debug && (nsize != fsize || nsize != this.core.imageCount[0])) {
            LogTools.println("Warning: mismatch between image count, names and factors (count=" + this.core.imageCount[0] + ", names=" + nsize + ", factors=" + fsize + ")");
        }
        for (i = 0; i < nsize; ++i) {
            this.addMeta("Name " + i, n.get(i));
        }
        for (i = 0; i < fsize; ++i) {
            this.addMeta("Factor " + i, f.get(i));
        }
        this.factors = new double[this.core.imageCount[0]];
        int max = 0;
        for (int i2 = 0; i2 < fsize; ++i2) {
            double q;
            block9: {
                String factor = (String)f.get(i2);
                q = 1.0;
                try {
                    q = Double.parseDouble(factor);
                }
                catch (NumberFormatException exc) {
                    if (!debug) break block9;
                    LogTools.println("Warning: invalid factor #" + i2 + ": " + factor);
                }
            }
            this.factors[i2] = q;
            if (!(q > this.factors[max])) continue;
            max = i2;
        }
        Arrays.fill(this.factors, fsize, this.factors.length, 1.0);
        this.core.pixelType[0] = this.factors[max] > 256.0 ? 5 : (this.factors[max] > 1.0 ? 3 : 1);
    }

    public class FlexHandler
    extends DefaultHandler {
        private Vector names;
        private Vector factors;

        public FlexHandler(Vector names, Vector factors) {
            this.names = names;
            this.factors = factors;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (!qName.equals("Array")) {
                return;
            }
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                String name = attributes.getQName(i);
                if (name.equals("Name")) {
                    this.names.add(attributes.getValue(i));
                    continue;
                }
                if (!name.equals("Factor")) continue;
                this.factors.add(attributes.getValue(i));
            }
        }
    }
}

